/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.basic.operations.file_upload;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.basic.models.FileUploadUrlInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicGeneratedUserUploadContentUrl
extends Operation {
    private String path = "/basic/v1/public/namespaces/{namespace}/users/{userId}/files";
    private String method = "POST";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private String category;
    private String fileType;

    @Deprecated
    public PublicGeneratedUserUploadContentUrl(String customBasePath, String namespace, String userId, String category, String fileType) {
        this.namespace = namespace;
        this.userId = userId;
        this.category = category;
        this.fileType = fileType;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("category", this.category == null ? null : Arrays.asList(this.category));
        queryParams.put("fileType", this.fileType == null ? null : Arrays.asList(this.fileType));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.userId == null) {
            return false;
        }
        return this.fileType != null;
    }

    public FileUploadUrlInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new FileUploadUrlInfo().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("category", "None");
        result.put("fileType", "None");
        return result;
    }

    public static PublicGeneratedUserUploadContentUrlBuilder builder() {
        return new PublicGeneratedUserUploadContentUrlBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getCategory() {
        return this.category;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public static class PublicGeneratedUserUploadContentUrlBuilder {
        private String customBasePath;
        private String namespace;
        private String userId;
        private String category;
        private String fileType;

        PublicGeneratedUserUploadContentUrlBuilder() {
        }

        public PublicGeneratedUserUploadContentUrlBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public PublicGeneratedUserUploadContentUrlBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicGeneratedUserUploadContentUrlBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public PublicGeneratedUserUploadContentUrlBuilder category(String category) {
            this.category = category;
            return this;
        }

        public PublicGeneratedUserUploadContentUrlBuilder fileType(String fileType) {
            this.fileType = fileType;
            return this;
        }

        public PublicGeneratedUserUploadContentUrl build() {
            return new PublicGeneratedUserUploadContentUrl(this.customBasePath, this.namespace, this.userId, this.category, this.fileType);
        }

        public String toString() {
            return "PublicGeneratedUserUploadContentUrl.PublicGeneratedUserUploadContentUrlBuilder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", userId=" + this.userId + ", category=" + this.category + ", fileType=" + this.fileType + ")";
        }
    }
}

