/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.basic.operations.misc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.basic.models.CountryGroupObject;
import net.accelbyte.sdk.api.basic.models.UpdateCountryGroupRequest;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class UpdateCountryGroup
extends Operation {
    private String path = "/basic/v1/admin/namespaces/{namespace}/misc/countrygroups/{countryGroupCode}";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String countryGroupCode;
    private String namespace;
    private UpdateCountryGroupRequest body;

    @Deprecated
    public UpdateCountryGroup(String customBasePath, String countryGroupCode, String namespace, UpdateCountryGroupRequest body) {
        this.countryGroupCode = countryGroupCode;
        this.namespace = namespace;
        this.body = body;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.countryGroupCode != null) {
            pathParams.put("countryGroupCode", this.countryGroupCode);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public UpdateCountryGroupRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.countryGroupCode == null) {
            return false;
        }
        return this.namespace != null;
    }

    public CountryGroupObject parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new CountryGroupObject().createFromJson(json);
    }

    public static UpdateCountryGroupBuilder builder() {
        return new UpdateCountryGroupBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getCountryGroupCode() {
        return this.countryGroupCode;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public UpdateCountryGroupRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setCountryGroupCode(String countryGroupCode) {
        this.countryGroupCode = countryGroupCode;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBody(UpdateCountryGroupRequest body) {
        this.body = body;
    }

    public static class UpdateCountryGroupBuilder {
        private String customBasePath;
        private String countryGroupCode;
        private String namespace;
        private UpdateCountryGroupRequest body;

        UpdateCountryGroupBuilder() {
        }

        public UpdateCountryGroupBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public UpdateCountryGroupBuilder countryGroupCode(String countryGroupCode) {
            this.countryGroupCode = countryGroupCode;
            return this;
        }

        public UpdateCountryGroupBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public UpdateCountryGroupBuilder body(UpdateCountryGroupRequest body) {
            this.body = body;
            return this;
        }

        public UpdateCountryGroup build() {
            return new UpdateCountryGroup(this.customBasePath, this.countryGroupCode, this.namespace, this.body);
        }

        public String toString() {
            return "UpdateCountryGroup.UpdateCountryGroupBuilder(customBasePath=" + this.customBasePath + ", countryGroupCode=" + this.countryGroupCode + ", namespace=" + this.namespace + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

