/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.basic.operations.user_profile;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.basic.models.UserProfileCreate;
import net.accelbyte.sdk.api.basic.models.UserProfileInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicCreateUserProfile
extends Operation {
    private String path = "/basic/v1/public/namespaces/{namespace}/users/{userId}/profiles";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private UserProfileCreate body;

    @Deprecated
    public PublicCreateUserProfile(String customBasePath, String namespace, String userId, UserProfileCreate body) {
        this.namespace = namespace;
        this.userId = userId;
        this.body = body;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public UserProfileCreate getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public UserProfileInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 201) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new UserProfileInfo().createFromJson(json);
    }

    public static PublicCreateUserProfileBuilder builder() {
        return new PublicCreateUserProfileBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public UserProfileCreate getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setBody(UserProfileCreate body) {
        this.body = body;
    }

    public static class PublicCreateUserProfileBuilder {
        private String customBasePath;
        private String namespace;
        private String userId;
        private UserProfileCreate body;

        PublicCreateUserProfileBuilder() {
        }

        public PublicCreateUserProfileBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public PublicCreateUserProfileBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicCreateUserProfileBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public PublicCreateUserProfileBuilder body(UserProfileCreate body) {
            this.body = body;
            return this;
        }

        public PublicCreateUserProfile build() {
            return new PublicCreateUserProfile(this.customBasePath, this.namespace, this.userId, this.body);
        }

        public String toString() {
            return "PublicCreateUserProfile.PublicCreateUserProfileBuilder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", userId=" + this.userId + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

