/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.basic.operations.user_profile;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.basic.models.UserProfileAdmin;
import net.accelbyte.sdk.api.basic.models.UserProfilePrivateInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class UpdateUserProfile
extends Operation {
    private String path = "/basic/v1/admin/namespaces/{namespace}/users/{userId}/profiles";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private UserProfileAdmin body;

    @Deprecated
    public UpdateUserProfile(String customBasePath, String namespace, String userId, UserProfileAdmin body) {
        this.namespace = namespace;
        this.userId = userId;
        this.body = body;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public UserProfileAdmin getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public UserProfilePrivateInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new UserProfilePrivateInfo().createFromJson(json);
    }

    public static UpdateUserProfileBuilder builder() {
        return new UpdateUserProfileBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public UserProfileAdmin getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setBody(UserProfileAdmin body) {
        this.body = body;
    }

    public static class UpdateUserProfileBuilder {
        private String customBasePath;
        private String namespace;
        private String userId;
        private UserProfileAdmin body;

        UpdateUserProfileBuilder() {
        }

        public UpdateUserProfileBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public UpdateUserProfileBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public UpdateUserProfileBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public UpdateUserProfileBuilder body(UserProfileAdmin body) {
            this.body = body;
            return this;
        }

        public UpdateUserProfile build() {
            return new UpdateUserProfile(this.customBasePath, this.namespace, this.userId, this.body);
        }

        public String toString() {
            return "UpdateUserProfile.UpdateUserProfileBuilder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", userId=" + this.userId + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

