/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.basic.wrappers;

import net.accelbyte.sdk.api.basic.models.ConfigInfo;
import net.accelbyte.sdk.api.basic.operations.config.CreateConfig;
import net.accelbyte.sdk.api.basic.operations.config.DeleteConfig;
import net.accelbyte.sdk.api.basic.operations.config.GetConfig;
import net.accelbyte.sdk.api.basic.operations.config.GetPublisherConfig;
import net.accelbyte.sdk.api.basic.operations.config.UpdateConfig;
import net.accelbyte.sdk.core.HttpResponse;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.RequestRunner;

public class Config {
    private RequestRunner sdk;
    private String customBasePath = "";

    public Config(RequestRunner sdk) {
        this.sdk = sdk;
        String configCustomBasePath = sdk.getSdkConfiguration().getConfigRepository().getCustomServiceBasePath("basic");
        if (!configCustomBasePath.equals("")) {
            this.customBasePath = configCustomBasePath;
        }
    }

    public Config(RequestRunner sdk, String customBasePath) {
        this.sdk = sdk;
        this.customBasePath = customBasePath;
    }

    public ConfigInfo createConfig(CreateConfig input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public ConfigInfo getConfig(GetConfig input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public void deleteConfig(DeleteConfig input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        input.handleEmptyResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public ConfigInfo updateConfig(UpdateConfig input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public ConfigInfo getPublisherConfig(GetPublisherConfig input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }
}

