/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.basic.wrappers;

import net.accelbyte.sdk.api.basic.models.FileUploadUrlInfo;
import net.accelbyte.sdk.api.basic.operations.file_upload.GeneratedUploadUrl;
import net.accelbyte.sdk.api.basic.operations.file_upload.GeneratedUserUploadContentUrl;
import net.accelbyte.sdk.api.basic.operations.file_upload.PublicGeneratedUploadUrl;
import net.accelbyte.sdk.api.basic.operations.file_upload.PublicGeneratedUserUploadContentUrl;
import net.accelbyte.sdk.core.HttpResponse;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.RequestRunner;

public class FileUpload {
    private RequestRunner sdk;
    private String customBasePath = "";

    public FileUpload(RequestRunner sdk) {
        this.sdk = sdk;
        String configCustomBasePath = sdk.getSdkConfiguration().getConfigRepository().getCustomServiceBasePath("basic");
        if (!configCustomBasePath.equals("")) {
            this.customBasePath = configCustomBasePath;
        }
    }

    public FileUpload(RequestRunner sdk, String customBasePath) {
        this.sdk = sdk;
        this.customBasePath = customBasePath;
    }

    public FileUploadUrlInfo generatedUploadUrl(GeneratedUploadUrl input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public FileUploadUrlInfo generatedUserUploadContentUrl(GeneratedUserUploadContentUrl input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public FileUploadUrlInfo publicGeneratedUploadUrl(PublicGeneratedUploadUrl input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public FileUploadUrlInfo publicGeneratedUserUploadContentUrl(PublicGeneratedUserUploadContentUrl input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }
}

