/*
 * Decompiled with CFR 0.152.
 */
package net.akehurst.transform.binary.basic;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.akehurst.transform.binary.api.BinaryRule;
import net.akehurst.transform.binary.api.BinaryRuleNotFoundException;
import net.akehurst.transform.binary.api.BinaryTransformer;
import net.akehurst.transform.binary.api.TransformException;

public class BinaryTransformerBasic
implements BinaryTransformer {
    private final List<Class<? extends BinaryRule<?, ?>>> ruleTypes = new ArrayList();
    private final Map<Class<? extends BinaryRule<?, ?>>, Map<Object, Object>> mappingsLeft2Right = new HashMap();
    private final Map<Class<? extends BinaryRule<?, ?>>, Map<Object, Object>> mappingsRight2Left = new HashMap();

    @Override
    public void clear() {
        this.mappingsLeft2Right.clear();
        this.mappingsRight2Left.clear();
    }

    @Override
    public List<Class<? extends BinaryRule<?, ?>>> getRuleTypes() {
        return this.ruleTypes;
    }

    @Override
    public void registerRule(Class<? extends BinaryRule<?, ?>> ruleType) {
        this.getRuleTypes().add(ruleType);
    }

    private List<BinaryRule> getRules(Class<? extends BinaryRule> ruleType) {
        ArrayList<BinaryRule> rules = new ArrayList<BinaryRule>();
        for (Class<BinaryRule<?, ?>> rt : this.getRuleTypes()) {
            if (!ruleType.isAssignableFrom(rt) || Modifier.isAbstract(rt.getModifiers())) continue;
            try {
                Constructor<BinaryRule<?, ?>> cons = rt.getConstructor(new Class[0]);
                BinaryRule<?, ?> r = cons.newInstance(new Object[0]);
                rules.add(r);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rules;
    }

    private <L, R> void recordMaping(Class<? extends BinaryRule<L, R>> rule, L left, R right) {
        this.getRuleMappingsLeft2Right(rule).put(left, right);
        this.getRuleMappingsRight2Left(rule).put(right, left);
    }

    @Override
    public <L, R> boolean isAMatch(Class<? extends BinaryRule<L, R>> ruleClass, L left, R right) {
        List<BinaryRule> rules = this.getRules(ruleClass);
        if (rules.isEmpty()) {
            throw new BinaryRuleNotFoundException("No relation " + ruleClass + " found in transformer " + this);
        }
        int exceptionCount = 0;
        for (BinaryRule rule : rules) {
            boolean b = false;
            try {
                b = rule.isValidForLeft2Right(left) && rule.isValidForRight2Left(right);
            }
            catch (ClassCastException e) {
                ++exceptionCount;
            }
            if (b) {
                return rule.isAMatch(left, right, this);
            }
            if (exceptionCount != rules.size()) continue;
            throw new BinaryRuleNotFoundException("No relation " + ruleClass + " found that is appicable to " + left);
        }
        return false;
    }

    @Override
    public <L, R> boolean isAllAMatch(Class<? extends BinaryRule<L, R>> ruleClass, List<L> left, List<R> right) {
        if (null == left && null == right) {
            return true;
        }
        if (null == left || null == right) {
            return false;
        }
        if (left.isEmpty() && right.isEmpty()) {
            return true;
        }
        if (left.size() != right.size()) {
            return false;
        }
        for (int i = 0; i < left.size(); ++i) {
            R r;
            L l = left.get(i);
            boolean elementMatch = this.isAMatch(ruleClass, l, r = right.get(i));
            if (elementMatch) continue;
            return false;
        }
        return true;
    }

    private <L, R> Map<L, R> getRuleMappingsLeft2Right(Class<? extends BinaryRule<L, R>> rule) {
        Map<Object, Object> ruleMappings = this.mappingsLeft2Right.get(rule);
        if (ruleMappings == null) {
            ruleMappings = new HashMap<Object, Object>();
            this.mappingsLeft2Right.put(rule, ruleMappings);
        }
        return ruleMappings;
    }

    private <L, R> R getExistingTargetForLeft2Right(Class<? extends BinaryRule<L, R>> rule, L left) {
        return this.getRuleMappingsLeft2Right(rule).get(left);
    }

    private <L, R> R applyRuleLeft2Right(BinaryRule<L, R> r, L left) {
        Class<?> ruleType = r.getClass();
        R right = this.getExistingTargetForLeft2Right(ruleType, left);
        if (right == null) {
            right = r.constructLeft2Right(left, this);
            this.recordMaping(ruleType, left, right);
            r.updateLeft2Right(left, right, this);
        }
        return right;
    }

    @Override
    public <L, R> R transformLeft2Right(Class<? extends BinaryRule<L, R>> ruleClass, L left) {
        if (null == left) {
            return null;
        }
        List<BinaryRule> rules = this.getRules(ruleClass);
        if (rules.isEmpty()) {
            throw new BinaryRuleNotFoundException("No relation " + ruleClass + " found in transformer " + this);
        }
        int exceptionCount = 0;
        for (BinaryRule rule : rules) {
            boolean b = false;
            try {
                b = rule.isValidForLeft2Right(left);
            }
            catch (ClassCastException e) {
                ++exceptionCount;
            }
            if (b) {
                return this.applyRuleLeft2Right(rule, left);
            }
            if (exceptionCount != rules.size()) continue;
            throw new BinaryRuleNotFoundException("No relation " + ruleClass + " found that is appicable to " + left);
        }
        throw new BinaryRuleNotFoundException("No relation " + ruleClass + " found that is appicable to " + left);
    }

    @Override
    public <L, R> List<? extends R> transformAllLeft2Right(Class<? extends BinaryRule<L, R>> ruleType, List<? extends L> leftObjects) {
        if (null == leftObjects) {
            return null;
        }
        ArrayList<R> rightObjects = new ArrayList<R>();
        for (L left : leftObjects) {
            R o = this.transformLeft2Right(ruleType, left);
            rightObjects.add(o);
        }
        return rightObjects;
    }

    @Override
    public <L, R> Set<? extends R> transformAllLeft2Right(Class<? extends BinaryRule<L, R>> ruleClass, Set<? extends L> leftObjects) {
        if (null == leftObjects) {
            return null;
        }
        HashSet<R> rightObjects = new HashSet<R>();
        for (L left : leftObjects) {
            R o = this.transformLeft2Right(ruleClass, left);
            rightObjects.add(o);
        }
        return rightObjects;
    }

    @Override
    public <L, R> void updateLeft2Right(Class<? extends BinaryRule<L, R>> ruleClass, L left, R right) {
        if (null == left || null == right) {
            throw new TransformException("Cannot update from or to a null object", null);
        }
        List<BinaryRule> rules = this.getRules(ruleClass);
        if (rules.isEmpty()) {
            throw new BinaryRuleNotFoundException("No relation " + ruleClass + " found in transformer " + this);
        }
        int exceptionCount = 0;
        for (BinaryRule rule : rules) {
            boolean b = false;
            try {
                b = rule.isValidForLeft2Right(left);
            }
            catch (ClassCastException e) {
                ++exceptionCount;
            }
            if (b) {
                Class<?> ruleType = rule.getClass();
                this.recordMaping(ruleType, left, right);
                rule.updateLeft2Right(left, right, this);
            }
            if (exceptionCount != rules.size()) continue;
            throw new BinaryRuleNotFoundException("No relation " + ruleClass + " found that is appicable to " + left);
        }
    }

    @Override
    public <L, R> void updateAllLeft2Right(Class<? extends BinaryRule<L, R>> ruleClass, List<? extends L> leftList, List<? extends R> rightList) {
        int i;
        if (null == leftList || null == rightList) {
            throw new TransformException("Cannot update from or to a null collection", null);
        }
        ArrayList<R> newRightList = new ArrayList<R>();
        for (L left : leftList) {
            R right = this.findMatchLeft2Right(ruleClass, left, rightList);
            if (null == right) {
                right = this.transformLeft2Right(ruleClass, left);
            } else {
                this.updateLeft2Right(ruleClass, left, right);
            }
            newRightList.add(right);
        }
        for (i = 0; i < newRightList.size(); ++i) {
            Object nr = newRightList.get(i);
            if (i < rightList.size()) {
                rightList.set(i, nr);
                continue;
            }
            rightList.add(nr);
        }
        while (i < rightList.size()) {
            rightList.remove(i);
        }
    }

    @Override
    public <L, R> void updateAllLeft2Right(Class<? extends BinaryRule<L, R>> ruleClass, Set<? extends L> leftSet, Set<? extends R> rightSet) {
        if (null == leftSet || null == rightSet) {
            throw new TransformException("Cannot update from or to a null collection", null);
        }
        HashSet<R> newRightSet = new HashSet<R>();
        for (L left : leftSet) {
            Object right = this.findMatchLeft2Right(ruleClass, left, rightSet);
            if (null == right) {
                right = this.transformLeft2Right(ruleClass, left);
            } else {
                this.updateLeft2Right(ruleClass, left, right);
            }
            newRightSet.add(right);
        }
        HashSet<R> toDelete = new HashSet<R>();
        for (R oldRight : rightSet) {
            if (newRightSet.contains(oldRight)) continue;
            toDelete.add(oldRight);
        }
        rightSet.removeAll(toDelete);
        for (Object right : newRightSet) {
            if (rightSet.contains(right)) continue;
            rightSet.add(right);
        }
    }

    private <L, R> R findMatchLeft2Right(Class<? extends BinaryRule<L, R>> ruleClass, L left, Collection<? extends R> rightList) {
        for (R right : rightList) {
            if (!this.isAMatch(ruleClass, left, right)) continue;
            return right;
        }
        return null;
    }

    private <L, R> Map<R, L> getRuleMappingsRight2Left(Class<? extends BinaryRule<L, R>> rule) {
        Map<Object, Object> ruleMappings = this.mappingsRight2Left.get(rule);
        if (ruleMappings == null) {
            ruleMappings = new HashMap<Object, Object>();
            this.mappingsRight2Left.put(rule, ruleMappings);
        }
        return ruleMappings;
    }

    private <L, R> L getExistingTargetForRight2Left(Class<? extends BinaryRule<L, R>> rule, R right) {
        return this.getRuleMappingsRight2Left(rule).get(right);
    }

    private <L, R> L applyRuleRight2Left(BinaryRule<L, R> r, R right) {
        Class<?> ruleType = r.getClass();
        L left = this.getExistingTargetForRight2Left(ruleType, right);
        if (left == null) {
            left = r.constructRight2Left(right, this);
            this.recordMaping(ruleType, left, right);
            r.updateRight2Left(left, right, this);
        }
        return left;
    }

    @Override
    public <L, R> L transformRight2Left(Class<? extends BinaryRule<L, R>> ruleClass, R right) {
        if (null == right) {
            return null;
        }
        List<BinaryRule> rules = this.getRules(ruleClass);
        if (rules.isEmpty()) {
            throw new BinaryRuleNotFoundException("No relation " + ruleClass + " found in transformer " + this);
        }
        int exceptionCount = 0;
        for (BinaryRule rule : rules) {
            boolean b = false;
            try {
                b = rule.isValidForRight2Left(right);
            }
            catch (ClassCastException e) {
                ++exceptionCount;
            }
            if (b) {
                return this.applyRuleRight2Left(rule, right);
            }
            if (exceptionCount != rules.size()) continue;
            throw new BinaryRuleNotFoundException("No relation " + ruleClass + " found that is appicable to " + right);
        }
        throw new BinaryRuleNotFoundException("No relation " + ruleClass + " found that is appicable to " + right);
    }

    @Override
    public <L, R> List<? extends L> transformAllRight2Left(Class<? extends BinaryRule<L, R>> ruleType, List<? extends R> rightObjects) {
        if (null == rightObjects) {
            return null;
        }
        ArrayList<L> leftObjects = new ArrayList<L>();
        for (R right : rightObjects) {
            L left = this.transformRight2Left(ruleType, right);
            leftObjects.add(left);
        }
        return leftObjects;
    }

    @Override
    public <L, R> Set<? extends L> transformAllRight2Left(Class<? extends BinaryRule<L, R>> ruleClass, Set<? extends R> rightObjects) {
        if (null == rightObjects) {
            return null;
        }
        HashSet<L> leftObjects = new HashSet<L>();
        for (R right : rightObjects) {
            L left = this.transformRight2Left(ruleClass, right);
            leftObjects.add(left);
        }
        return leftObjects;
    }

    @Override
    public <L, R> void updateRight2Left(Class<? extends BinaryRule<L, R>> ruleClass, L left, R right) {
        if (null == left || null == right) {
            throw new TransformException("Cannot update from or to a null object", null);
        }
        List<BinaryRule> rules = this.getRules(ruleClass);
        if (rules.isEmpty()) {
            throw new BinaryRuleNotFoundException("No relation " + ruleClass + " found in transformer " + this);
        }
        int exceptionCount = 0;
        for (BinaryRule rule : rules) {
            boolean b = false;
            try {
                b = rule.isValidForRight2Left(right);
            }
            catch (ClassCastException e) {
                ++exceptionCount;
            }
            if (b) {
                Class<?> ruleType = rule.getClass();
                this.recordMaping(ruleType, left, right);
                rule.updateRight2Left(left, right, this);
            }
            if (exceptionCount != rules.size()) continue;
            throw new BinaryRuleNotFoundException("No relation " + ruleClass + " found that is appicable to " + right);
        }
    }

    @Override
    public <L, R> void updateAllRight2Left(Class<? extends BinaryRule<L, R>> ruleClass, List<? extends L> leftList, List<? extends R> rightList) {
        int i;
        if (null == leftList || null == rightList) {
            throw new TransformException("Cannot update from or to a null collection", null);
        }
        ArrayList<L> newLeftList = new ArrayList<L>();
        for (R right : rightList) {
            L left = this.findMatchRight2Left(ruleClass, right, leftList);
            if (null == left) {
                left = this.transformRight2Left(ruleClass, right);
            } else {
                this.updateRight2Left(ruleClass, left, right);
            }
            newLeftList.add(left);
        }
        for (i = 0; i < newLeftList.size(); ++i) {
            Object newLeft = newLeftList.get(i);
            if (i < leftList.size()) {
                leftList.set(i, newLeft);
                continue;
            }
            leftList.add(newLeft);
        }
        while (i < leftList.size()) {
            leftList.remove(i);
        }
    }

    @Override
    public <L, R> void updateAllRight2Left(Class<? extends BinaryRule<L, R>> ruleClass, Set<? extends L> leftSet, Set<? extends R> rightSet) {
        if (null == leftSet || null == rightSet) {
            throw new TransformException("Cannot update from or to a null collection", null);
        }
        HashSet<L> newLeftSet = new HashSet<L>();
        for (R right : rightSet) {
            Object left = this.findMatchRight2Left(ruleClass, right, leftSet);
            if (null == left) {
                left = this.transformRight2Left(ruleClass, right);
            } else {
                this.updateRight2Left(ruleClass, left, right);
            }
            newLeftSet.add(left);
        }
        HashSet<L> toDelete = new HashSet<L>();
        for (L oldLeft : leftSet) {
            if (newLeftSet.contains(oldLeft)) continue;
            toDelete.add(oldLeft);
        }
        leftSet.removeAll(toDelete);
        for (Object left : newLeftSet) {
            if (leftSet.contains(left)) continue;
            leftSet.add(left);
        }
    }

    private <L, R> L findMatchRight2Left(Class<? extends BinaryRule<L, R>> ruleClass, R right, Collection<? extends L> leftCol) {
        for (L left : leftCol) {
            if (!this.isAMatch(ruleClass, left, right)) continue;
            return left;
        }
        return null;
    }
}

