/*
 * Decompiled with CFR 0.152.
 */
package net.akehurst.transform.binary.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.akehurst.transform.binary.api.BinaryRule;
import net.akehurst.transform.binary.api.BinaryRuleNotFoundException;
import net.akehurst.transform.binary.api.BinaryTransformer;
import net.akehurst.transform.binary.api.TransformException;

public class PrimitiveObject2PrimitiveObject
implements BinaryRule<Object, Object> {
    private static final Set<Class<?>> PRIMITIVES = new HashSet<Class>(Arrays.asList(Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class, String.class));

    private static boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive() || PRIMITIVES.contains(clazz);
    }

    @Override
    public boolean isValidForLeft2Right(Object left) {
        return PrimitiveObject2PrimitiveObject.isPrimitive(left.getClass());
    }

    @Override
    public boolean isValidForRight2Left(Object right) {
        return PrimitiveObject2PrimitiveObject.isPrimitive(right.getClass());
    }

    @Override
    public boolean isAMatch(Object left, Object right, BinaryTransformer transformer) throws BinaryRuleNotFoundException {
        return Objects.equals(left, right);
    }

    @Override
    public Object constructLeft2Right(Object left, BinaryTransformer transformer) throws TransformException, BinaryRuleNotFoundException {
        return left;
    }

    @Override
    public Object constructRight2Left(Object right, BinaryTransformer transformer) throws TransformException, BinaryRuleNotFoundException {
        return right;
    }

    @Override
    public void updateLeft2Right(Object left, Object right, BinaryTransformer transformer) throws TransformException, BinaryRuleNotFoundException {
    }

    @Override
    public void updateRight2Left(Object left, Object right, BinaryTransformer transformer) throws TransformException, BinaryRuleNotFoundException {
    }
}

