/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.codecrete.usb.USBDevice;
import net.codecrete.usb.USBDeviceFilter;
import net.codecrete.usb.common.USBDeviceRegistry;
import net.codecrete.usb.linux.LinuxUSBDeviceRegistry;
import net.codecrete.usb.macos.MacosUSBDeviceRegistry;
import net.codecrete.usb.windows.WindowsUSBDeviceRegistry;

public class USB {
    private static USBDeviceRegistry _instance = null;

    private static USBDeviceRegistry createInstance() {
        USBDeviceRegistry impl;
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        if (osName.equals("Mac OS X") && (osArch.equals("x86_64") || osArch.equals("aarch64"))) {
            impl = new MacosUSBDeviceRegistry();
        } else if (osName.startsWith("Windows") && osArch.equals("amd64")) {
            impl = new WindowsUSBDeviceRegistry();
        } else if (osName.equals("Linux") && (osArch.equals("amd64") || osArch.equals("aarch64"))) {
            impl = new LinuxUSBDeviceRegistry();
        } else {
            throw new UnsupportedOperationException(String.format("JavaCanDoUsb is not implemented for architecture %s/%s", osName, osArch));
        }
        return impl;
    }

    private static synchronized USBDeviceRegistry instance() {
        if (_instance == null) {
            _instance = USB.createInstance();
            _instance.start();
        }
        return _instance;
    }

    private USB() {
    }

    public static List<USBDevice> getAllDevices() {
        return USB.instance().getAllDevices();
    }

    public static List<USBDevice> getDevices(USBDeviceFilter filter) {
        return USB.instance().getAllDevices().stream().filter(filter::matches).collect(Collectors.toList());
    }

    public static List<USBDevice> getDevices(List<USBDeviceFilter> filters) {
        return USB.instance().getAllDevices().stream().filter(dev -> USBDeviceFilter.matchesAny(dev, filters)).collect(Collectors.toList());
    }

    public static USBDevice getDevice(USBDeviceFilter filter) {
        return USB.instance().getAllDevices().stream().filter(filter::matches).findFirst().orElse(null);
    }

    public static USBDevice getDevice(List<USBDeviceFilter> filters) {
        return USB.instance().getAllDevices().stream().filter(dev -> USBDeviceFilter.matchesAny(dev, filters)).findFirst().orElse(null);
    }

    public static void setOnDeviceConnected(Consumer<USBDevice> handler) {
        USB.instance().setOnDeviceConnected(handler);
    }

    public static void setOnDeviceDisconnected(Consumer<USBDevice> handler) {
        USB.instance().setOnDeviceDisconnected(handler);
    }
}

