/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb;

import java.util.List;
import net.codecrete.usb.USBDevice;

public class USBDeviceFilter {
    private Integer vendorId_;
    private Integer productId_;
    private Integer classCode_;
    private Integer subclassCode_;
    private Integer protocolCode_;
    private String serialNumber_;

    public USBDeviceFilter() {
    }

    public USBDeviceFilter(int vendorId, int productId) {
        this.vendorId_ = vendorId;
        this.productId_ = productId;
    }

    public USBDeviceFilter(int vendorId, int productId, String serialNumber) {
        this.vendorId_ = vendorId;
        this.productId_ = productId;
        this.serialNumber_ = serialNumber;
    }

    public Integer vendorId() {
        return this.vendorId_;
    }

    public void setVendorId(Integer vendorId) {
        this.vendorId_ = vendorId;
    }

    public Integer productId() {
        return this.productId_;
    }

    public void setProductId(Integer productId) {
        this.productId_ = productId;
    }

    public Integer classCode() {
        return this.classCode_;
    }

    public void setClassCode(Integer classCode) {
        this.classCode_ = classCode;
    }

    public Integer subclassCode() {
        return this.subclassCode_;
    }

    public void setSubclassCode(Integer subclassCode) {
        this.subclassCode_ = subclassCode;
    }

    public Integer protocolCode() {
        return this.protocolCode_;
    }

    public void setProtocolCode_(Integer protocolCode) {
        this.protocolCode_ = protocolCode;
    }

    public String serialNumber() {
        return this.serialNumber_;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber_ = serialNumber;
    }

    public boolean matches(USBDevice device) {
        if (this.vendorId_ != null && device.vendorId() != this.vendorId_.intValue()) {
            return false;
        }
        if (this.productId_ != null && device.productId() != this.productId_.intValue()) {
            return false;
        }
        if (this.serialNumber_ != null && !this.serialNumber_.equals(device.serialNumber())) {
            return false;
        }
        if (this.classCode_ != null && device.classCode() != this.classCode_.intValue()) {
            return false;
        }
        if (this.subclassCode_ != null && device.subclassCode() != this.subclassCode_.intValue()) {
            return false;
        }
        return this.protocolCode_ == null || device.protocolCode() == this.protocolCode_.intValue();
    }

    public static boolean matchesAny(USBDevice device, List<USBDeviceFilter> filters) {
        return filters.stream().anyMatch(filter -> filter.matches(device));
    }
}

