/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.common;

import java.util.ArrayList;
import java.util.List;
import net.codecrete.usb.USBInterface;
import net.codecrete.usb.common.CompositeFunction;
import net.codecrete.usb.common.USBInterfaceImpl;

public class Configuration {
    private final List<CompositeFunction> functions_;
    private final List<USBInterface> interfaces_;
    private final int configValue_;
    private final int attributes_;
    private final int maxPower_;

    public Configuration(int configValue, int attributes, int maxPower) {
        this.configValue_ = configValue;
        this.attributes_ = attributes;
        this.maxPower_ = maxPower;
        this.functions_ = new ArrayList<CompositeFunction>();
        this.interfaces_ = new ArrayList<USBInterface>();
    }

    public int configValue() {
        return this.configValue_;
    }

    public int attributes() {
        return this.attributes_;
    }

    public int maxPower() {
        return this.maxPower_;
    }

    public List<USBInterface> interfaces() {
        return this.interfaces_;
    }

    public List<CompositeFunction> functions() {
        return this.functions_;
    }

    public void addInterface(USBInterface intf) {
        this.interfaces_.add(intf);
    }

    public USBInterfaceImpl findInterfaceByNumber(int number) {
        return this.interfaces_.stream().filter(intf -> intf.number() == number).findFirst().orElse(null);
    }

    public void addFunction(CompositeFunction function) {
        this.functions_.add(function);
    }

    public CompositeFunction findFunction(int interfaceNumber) {
        return this.functions_.stream().filter(f -> interfaceNumber >= f.firstInterfaceNumber() && interfaceNumber < f.firstInterfaceNumber() + f.numInterfaces()).findFirst().orElse(null);
    }
}

