/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.common;

import java.io.IOException;
import java.io.InputStream;
import net.codecrete.usb.USBDevice;

public class EndpointInputStream
extends InputStream {
    private USBDevice device_;
    private final int endpointNumber_;
    private byte[] packet_;
    private int readOffset_;

    EndpointInputStream(USBDevice device, int endpointNumber) {
        this.device_ = device;
        this.endpointNumber_ = endpointNumber;
    }

    @Override
    public int read() throws IOException {
        if (this.device_ == null) {
            throw new IOException("Bulk endpoint input stream has been closed");
        }
        if (this.available() == 0) {
            this.receiveMoreData();
        }
        int b = this.packet_[this.readOffset_] & 0xFF;
        ++this.readOffset_;
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.device_ == null) {
            throw new IOException("Bulk endpoint input stream has been closed");
        }
        if (this.available() == 0) {
            this.receiveMoreData();
        }
        int n = Math.min(len, this.packet_.length - this.readOffset_);
        System.arraycopy(this.packet_, this.readOffset_, b, off, n);
        this.readOffset_ += n;
        return n;
    }

    @Override
    public int available() throws IOException {
        return (this.packet_ != null ? this.packet_.length : 0) - this.readOffset_;
    }

    private void receiveMoreData() throws IOException {
        if (this.device_ == null) {
            throw new IOException("Bulk endpoint input stream has been closed");
        }
        this.readOffset_ = 0;
        do {
            this.packet_ = this.device_.transferIn(this.endpointNumber_);
        } while (this.packet_.length == 0);
    }

    @Override
    public void close() throws IOException {
        this.device_ = null;
        this.packet_ = null;
    }
}

