/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.common;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import net.codecrete.usb.USBDevice;

public class EndpointOutputStream
extends OutputStream {
    private USBDevice device_;
    private final int endpointNumber_;
    private byte[] buffer_;
    private int bufferedBytes_;

    EndpointOutputStream(USBDevice device, int endpointNumber, int packetSize) {
        this.device_ = device;
        this.endpointNumber_ = endpointNumber;
        this.buffer_ = new byte[packetSize];
    }

    @Override
    public void write(int b) throws IOException {
        if (this.device_ == null) {
            throw new IOException("Bulk endpoint output stream has been closed");
        }
        this.buffer_[this.bufferedBytes_] = (byte)b;
        ++this.bufferedBytes_;
        if (this.bufferedBytes_ == this.buffer_.length) {
            this.flush();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.device_ == null) {
            throw new IOException("Bulk endpoint output stream has been closed");
        }
        while (len > 0) {
            int chunkSize = Math.min(len, this.buffer_.length - this.bufferedBytes_);
            System.arraycopy(b, off, this.buffer_, this.bufferedBytes_, chunkSize);
            this.bufferedBytes_ += chunkSize;
            off += chunkSize;
            len -= chunkSize;
            if (this.bufferedBytes_ != this.buffer_.length) continue;
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.device_ == null) {
            throw new IOException("Bulk endpoint output stream has been closed");
        }
        if (this.bufferedBytes_ == 0) {
            return;
        }
        byte[] data = this.bufferedBytes_ < this.buffer_.length ? Arrays.copyOfRange(this.buffer_, 0, this.bufferedBytes_) : this.buffer_;
        this.device_.transferOut(this.endpointNumber_, data);
        this.bufferedBytes_ = 0;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.buffer_ = null;
        this.device_ = null;
    }
}

