/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.common;

import java.lang.foreign.MemoryAddress;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import java.util.function.Consumer;

public class ForeignMemory {
    public static void addCloseAction(MemorySegment segment, Consumer<MemorySegment> action) {
        long size = segment.byteSize();
        MemoryAddress address = segment.address();
        Runnable closeAction = () -> {
            try (MemorySession closingSession = MemorySession.openConfined();){
                MemorySegment dup = MemorySegment.ofAddress((MemoryAddress)address, (long)size, (MemorySession)closingSession);
                action.accept(dup);
            }
        };
        segment.session().addCloseAction(closeAction);
    }
}

