/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import net.codecrete.usb.USBDevice;
import net.codecrete.usb.USBException;
import net.codecrete.usb.common.USBDeviceImpl;

public abstract class USBDeviceRegistry {
    private volatile List<USBDevice> devices;
    private volatile Throwable failureCause;
    protected Consumer<USBDevice> onDeviceConnectedHandler;
    protected Consumer<USBDevice> onDeviceDisconnectedHandler;
    private final Lock lock = new ReentrantLock();
    private final Condition enumerationComplete = this.lock.newCondition();

    public void start() {
        this.startDeviceMonitor(this::monitorDevices);
    }

    protected abstract void monitorDevices();

    public List<USBDevice> getAllDevices() {
        return Collections.unmodifiableList(this.devices);
    }

    public void setOnDeviceConnected(Consumer<USBDevice> handler) {
        this.onDeviceConnectedHandler = handler;
    }

    public void setOnDeviceDisconnected(Consumer<USBDevice> handler) {
        this.onDeviceDisconnectedHandler = handler;
    }

    protected void emitOnDeviceConnected(USBDevice device) {
        if (this.onDeviceConnectedHandler != null) {
            this.onDeviceConnectedHandler.accept(device);
        }
    }

    protected void emitOnDeviceDisconnected(USBDevice device) {
        if (this.onDeviceDisconnectedHandler != null) {
            this.onDeviceDisconnectedHandler.accept(device);
        }
    }

    protected void startDeviceMonitor(Runnable monitorTask) {
        Thread t = new Thread(monitorTask, "USB device monitor");
        t.setDaemon(true);
        t.start();
        this.lock.lock();
        try {
            while (this.devices == null && this.failureCause == null) {
                this.enumerationComplete.awaitUninterruptibly();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.failureCause != null) {
            throw new USBException("Initial device enumeration has failed", this.failureCause);
        }
    }

    private void signalEnumerationComplete() {
        this.lock.lock();
        try {
            this.enumerationComplete.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void enumerationFailed(Throwable e) {
        this.failureCause = e;
        this.signalEnumerationComplete();
    }

    protected void setInitialDeviceList(List<USBDevice> deviceList) {
        this.devices = deviceList;
        this.signalEnumerationComplete();
    }

    protected void addDevice(USBDevice device) {
        if (this.findDeviceIndex(this.devices, ((USBDeviceImpl)device).getUniqueId()) >= 0) {
            return;
        }
        ArrayList<USBDevice> newDeviceList = new ArrayList<USBDevice>(this.devices.size() + 1);
        newDeviceList.addAll(this.devices);
        newDeviceList.add(device);
        this.devices = newDeviceList;
        this.emitOnDeviceConnected(device);
    }

    protected void closeAndRemoveDevice(Object deviceId) {
        USBDevice device = this.findDevice(deviceId);
        if (device == null) {
            return;
        }
        try {
            device.close();
        }
        catch (Throwable e) {
            System.err.println("Info: [JavaDoesUSB] failed to close USB device - ignoring exception");
            e.printStackTrace(System.err);
        }
        this.removeDevice(deviceId);
    }

    protected void removeDevice(Object deviceId) {
        int index = this.findDeviceIndex(this.devices, deviceId);
        if (index < 0) {
            return;
        }
        USBDevice device = this.devices.get(index);
        ArrayList<USBDevice> newDeviceList = new ArrayList<USBDevice>(this.devices);
        newDeviceList.remove(index);
        this.devices = newDeviceList;
        this.emitOnDeviceDisconnected(device);
    }

    protected int findDeviceIndex(List<USBDevice> deviceList, Object deviceId) {
        for (int i = 0; i < deviceList.size(); ++i) {
            USBDeviceImpl dev = (USBDeviceImpl)deviceList.get(i);
            if (!deviceId.equals(dev.getUniqueId())) continue;
            return i;
        }
        return -1;
    }

    protected USBDevice findDevice(Object deviceId) {
        int index = this.findDeviceIndex(this.devices, deviceId);
        if (index < 0) {
            return null;
        }
        return this.devices.get(index);
    }
}

