/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.linux;

import java.io.IOException;
import java.lang.foreign.Addressable;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import java.lang.foreign.ValueLayout;
import java.nio.file.Files;
import java.nio.file.Path;
import net.codecrete.usb.USBAlternateInterface;
import net.codecrete.usb.USBControlTransfer;
import net.codecrete.usb.USBDirection;
import net.codecrete.usb.USBException;
import net.codecrete.usb.USBInterface;
import net.codecrete.usb.USBTimeoutException;
import net.codecrete.usb.USBTransferType;
import net.codecrete.usb.common.USBDeviceImpl;
import net.codecrete.usb.common.USBInterfaceImpl;
import net.codecrete.usb.linux.IO;
import net.codecrete.usb.linux.LinuxUSBException;
import net.codecrete.usb.linux.gen.errno.errno;
import net.codecrete.usb.linux.gen.fcntl.fcntl;
import net.codecrete.usb.linux.gen.ioctl.ioctl;
import net.codecrete.usb.linux.gen.unistd.unistd;
import net.codecrete.usb.linux.gen.usbdevice_fs.usbdevfs_bulktransfer;
import net.codecrete.usb.linux.gen.usbdevice_fs.usbdevfs_ctrltransfer;
import net.codecrete.usb.linux.gen.usbdevice_fs.usbdevfs_setinterface;
import net.codecrete.usb.usbstandard.DeviceDescriptor;

public class LinuxUSBDevice
extends USBDeviceImpl {
    private int fd = -1;

    LinuxUSBDevice(Object id, int vendorId, int productId) {
        super(id, vendorId, productId);
        this.loadDescription((String)id);
    }

    private void loadDescription(String path) {
        byte[] descriptors;
        try {
            descriptors = Files.readAllBytes(Path.of(path, new String[0]));
        }
        catch (IOException e) {
            throw new USBException("Cannot read configuration descriptor", e);
        }
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment descriptorsSegment = MemorySegment.ofArray(descriptors);
            MemorySegment deviceDesc = session.allocate((MemoryLayout)DeviceDescriptor.LAYOUT);
            deviceDesc.copyFrom(descriptorsSegment.asSlice(0L, DeviceDescriptor.LAYOUT.byteSize()));
            this.setFromDeviceDescriptor(deviceDesc);
            MemorySegment configDesc = session.allocateArray((MemoryLayout)ValueLayout.JAVA_BYTE, (long)(descriptors.length - 18));
            configDesc.copyFrom(descriptorsSegment.asSlice(DeviceDescriptor.LAYOUT.byteSize()));
            this.setConfigurationDescriptor(configDesc);
        }
    }

    @Override
    public boolean isOpen() {
        return this.fd != -1;
    }

    @Override
    public void open() {
        if (this.isOpen()) {
            LinuxUSBException.throwException("the device is already open", new Object[0]);
        }
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment pathUtf8 = session.allocateUtf8String(this.id_.toString());
            this.fd = fcntl.open((Addressable)pathUtf8, fcntl.O_RDWR() | fcntl.O_CLOEXEC(), new Object[0]);
            if (this.fd == -1) {
                LinuxUSBException.throwLastError("Cannot open USB device", new Object[0]);
            }
        }
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        for (USBInterface intf : this.interfaces_) {
            ((USBInterfaceImpl)intf).setClaimed(false);
        }
        unistd.close(this.fd);
        this.fd = -1;
    }

    @Override
    public void claimInterface(int interfaceNumber) {
        this.checkIsOpen();
        USBInterfaceImpl intf = this.getInterface(interfaceNumber);
        if (intf == null) {
            LinuxUSBException.throwException("Invalid interface number: %d", interfaceNumber);
        }
        if (intf.isClaimed()) {
            LinuxUSBException.throwException("Interface %d has already been claimed", interfaceNumber);
        }
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment intfNumSegment = session.allocate(ValueLayout.JAVA_INT, interfaceNumber);
            int ret = ioctl.ioctl(this.fd, -2147199729L, intfNumSegment.address());
            if (ret != 0) {
                LinuxUSBException.throwLastError("Cannot claim USB interface", new Object[0]);
            }
            this.setClaimed(interfaceNumber, true);
        }
    }

    @Override
    public void selectAlternateSetting(int interfaceNumber, int alternateNumber) {
        USBAlternateInterface altSetting;
        this.checkIsOpen();
        USBInterfaceImpl intf = this.getInterface(interfaceNumber);
        if (intf == null) {
            LinuxUSBException.throwException("Invalid interface number: %d", interfaceNumber);
        }
        if (!intf.isClaimed()) {
            LinuxUSBException.throwException("Interface %d has not been claimed", interfaceNumber);
        }
        if ((altSetting = intf.getAlternate(alternateNumber)) == null) {
            LinuxUSBException.throwException("Interface %d does not have an alternate interface setting %d", interfaceNumber, alternateNumber);
        }
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment setIntfSegment = session.allocate(usbdevfs_setinterface.$LAYOUT());
            usbdevfs_setinterface.interface_$set(setIntfSegment, interfaceNumber);
            usbdevfs_setinterface.altsetting$set(setIntfSegment, alternateNumber);
            int ret = ioctl.ioctl(this.fd, -2146937596L, setIntfSegment.address());
            if (ret != 0) {
                LinuxUSBException.throwLastError("Failed to set alternate interface", new Object[0]);
            }
        }
        intf.setAlternate(altSetting);
    }

    @Override
    public void releaseInterface(int interfaceNumber) {
        this.checkIsOpen();
        USBInterfaceImpl intf = this.getInterface(interfaceNumber);
        if (intf == null) {
            LinuxUSBException.throwException("Invalid interface number: %d", interfaceNumber);
        }
        if (!intf.isClaimed()) {
            LinuxUSBException.throwException("Interface %d has not been claimed", interfaceNumber);
        }
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment intfNumSegment = session.allocate(ValueLayout.JAVA_INT, interfaceNumber);
            int ret = ioctl.ioctl(this.fd, -2147199728L, intfNumSegment.address());
            if (ret != 0) {
                LinuxUSBException.throwLastError("Cannot release USB interface", new Object[0]);
            }
            this.setClaimed(interfaceNumber, false);
        }
    }

    private MemorySegment createCtrlTransfer(MemorySession session, USBDirection direction, USBControlTransfer setup, MemorySegment data) {
        MemorySegment ctrlTransfer = session.allocate(usbdevfs_ctrltransfer.$LAYOUT());
        int bmRequest = (direction == USBDirection.IN ? 128 : 0) | setup.requestType().ordinal() << 5 | setup.recipient().ordinal();
        usbdevfs_ctrltransfer.bRequestType$set(ctrlTransfer, (byte)bmRequest);
        usbdevfs_ctrltransfer.bRequest$set(ctrlTransfer, (byte)setup.request());
        usbdevfs_ctrltransfer.wValue$set(ctrlTransfer, (short)setup.value());
        usbdevfs_ctrltransfer.wIndex$set(ctrlTransfer, (short)setup.index());
        usbdevfs_ctrltransfer.wLength$set(ctrlTransfer, (short)data.byteSize());
        usbdevfs_ctrltransfer.data$set(ctrlTransfer, data.address());
        return ctrlTransfer;
    }

    @Override
    public byte[] controlTransferIn(USBControlTransfer setup, int length) {
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment data = session.allocate((long)length);
            MemorySegment ctrlTransfer = this.createCtrlTransfer(session, USBDirection.IN, setup, data);
            int res = ioctl.ioctl(this.fd, -1072147200L, ctrlTransfer.address());
            if (res < 0) {
                LinuxUSBException.throwLastError("Control IN transfer failed", new Object[0]);
            }
            byte[] byArray = data.asSlice(0L, res).toArray(ValueLayout.JAVA_BYTE);
            return byArray;
        }
    }

    @Override
    public void controlTransferOut(USBControlTransfer setup, byte[] data) {
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment ctrlTransfer;
            int res;
            int dataLength = data != null ? data.length : 0;
            MemorySegment buffer = session.allocate((long)dataLength);
            if (dataLength != 0) {
                buffer.copyFrom(MemorySegment.ofArray(data));
            }
            if ((res = ioctl.ioctl(this.fd, -1072147200L, (ctrlTransfer = this.createCtrlTransfer(session, USBDirection.OUT, setup, buffer)).address())) < 0) {
                LinuxUSBException.throwLastError("Control OUT transfer failed", new Object[0]);
            }
        }
    }

    private MemorySegment createBulkTransfer(MemorySession session, byte endpointAddress, MemorySegment data, int timeout) {
        MemorySegment transfer = session.allocate(usbdevfs_bulktransfer.$LAYOUT());
        usbdevfs_bulktransfer.ep$set(transfer, 0xFF & endpointAddress);
        usbdevfs_bulktransfer.len$set(transfer, (int)data.byteSize());
        usbdevfs_bulktransfer.data$set(transfer, data.address());
        usbdevfs_bulktransfer.timeout$set(transfer, timeout);
        return transfer;
    }

    @Override
    public void transferOut(int endpointNumber, byte[] data, int timeout) {
        byte endpointAddress = this.getEndpointAddress(endpointNumber, USBDirection.OUT, USBTransferType.BULK, USBTransferType.INTERRUPT);
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment buffer = session.allocate((long)data.length);
            buffer.copyFrom(MemorySegment.ofArray(data));
            MemorySegment transfer = this.createBulkTransfer(session, endpointAddress, buffer, timeout);
            int res = ioctl.ioctl(this.fd, -1072147198L, transfer.address());
            if (res < 0) {
                int err = IO.getErrno();
                if (err == errno.ETIMEDOUT()) {
                    throw new USBTimeoutException("Transfer out aborted due to timeout");
                }
                if (err == 2) {
                    throw new USBTimeoutException("Transfer in aborted due to timeout");
                }
                LinuxUSBException.throwException(err, "USB OUT transfer on endpoint %d failed", endpointNumber);
            }
        }
    }

    @Override
    public byte[] transferIn(int endpointNumber, int timeout) {
        USBDeviceImpl.EndpointInfo endpoint = this.getEndpoint(endpointNumber, USBDirection.IN, USBTransferType.BULK, USBTransferType.INTERRUPT);
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment buffer = session.allocate((long)endpoint.packetSize());
            MemorySegment transfer = this.createBulkTransfer(session, endpoint.endpointAddress(), buffer, timeout);
            int res = ioctl.ioctl(this.fd, -1072147198L, transfer.address());
            if (res < 0) {
                int err = IO.getErrno();
                if (err == errno.ETIMEDOUT()) {
                    throw new USBTimeoutException("Transfer in aborted due to timeout");
                }
                if (err == 2) {
                    throw new USBTimeoutException("Transfer in aborted due to timeout");
                }
                LinuxUSBException.throwException(err, "USB IN transfer on endpoint %d failed", endpointNumber);
            }
            byte[] byArray = buffer.asSlice(0L, res).toArray(ValueLayout.JAVA_BYTE);
            return byArray;
        }
    }

    @Override
    public void clearHalt(USBDirection direction, int endpointNumber) {
        byte endpointAddress = this.getEndpointAddress(endpointNumber, direction, USBTransferType.BULK, USBTransferType.INTERRUPT);
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment endpointAddrSegment = session.allocate(ValueLayout.JAVA_INT, endpointAddress & 0xFF);
            int res = ioctl.ioctl(this.fd, -2147199723L, endpointAddrSegment.address());
            if (res < 0) {
                LinuxUSBException.throwLastError("Clearing halt failed", new Object[0]);
            }
        }
    }
}

