/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.macos;

import java.lang.foreign.Addressable;
import java.lang.foreign.MemoryAddress;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import java.lang.foreign.ValueLayout;
import net.codecrete.usb.macos.gen.corefoundation.CFRange;
import net.codecrete.usb.macos.gen.corefoundation.CoreFoundation;

public class CoreFoundationHelper {
    public static String stringFromCFStringRef(MemoryAddress string2) {
        String string3;
        block8: {
            MemorySession session = MemorySession.openConfined();
            try {
                long strLen = CoreFoundation.CFStringGetLength((Addressable)string2);
                MemorySegment buffer = session.allocateArray((MemoryLayout)ValueLayout.JAVA_CHAR, strLen);
                MemorySegment range = session.allocate(CFRange.$LAYOUT());
                CFRange.location$set(range, 0L);
                CFRange.length$set(range, strLen);
                CoreFoundation.CFStringGetCharacters((Addressable)string2, range, (Addressable)buffer);
                string3 = new String(buffer.toArray(ValueLayout.JAVA_CHAR));
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            session.close();
        }
        return string3;
    }

    public static MemoryAddress createCFStringRef(String string2) {
        try (MemorySession session = MemorySession.openConfined();){
            char[] charArray = string2.toCharArray();
            MemorySegment chars = session.allocateArray((MemoryLayout)ValueLayout.JAVA_CHAR, (long)charArray.length);
            chars.copyFrom(MemorySegment.ofArray(charArray));
            MemoryAddress memoryAddress = CoreFoundation.CFStringCreateWithCharacters((Addressable)MemoryAddress.NULL, (Addressable)chars, string2.length());
            return memoryAddress;
        }
    }
}

