/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.macos;

import java.lang.foreign.MemoryAddress;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import java.lang.foreign.ValueLayout;
import net.codecrete.usb.macos.gen.iokit.IOUSBDeviceInterface;
import net.codecrete.usb.macos.gen.iokit.IOUSBInterfaceInterface;
import net.codecrete.usb.macos.gen.iokit.IOUSBInterfaceStruct942;

public class IoKitUSB {
    private static MemorySegment getVtable(MemoryAddress self, MemorySession session) {
        MemorySegment object = MemorySegment.ofAddress((MemoryAddress)self, (long)ValueLayout.ADDRESS.byteSize(), (MemorySession)session);
        MemoryAddress vtableAddr = object.get((ValueLayout.OfAddress)ValueLayout.ADDRESS, 0L);
        return MemorySegment.ofAddress((MemoryAddress)vtableAddr, (long)800L, (MemorySession)session);
    }

    public static int QueryInterface(MemoryAddress self, MemorySegment iid, MemoryAddress ppv) {
        try (MemorySession session = MemorySession.openConfined();){
            int n = IOUSBDeviceInterface.QueryInterface(IoKitUSB.getVtable(self, session), session).apply(self, iid, ppv);
            return n;
        }
    }

    public static int AddRef(MemoryAddress self) {
        try (MemorySession session = MemorySession.openConfined();){
            int n = IOUSBDeviceInterface.AddRef(IoKitUSB.getVtable(self, session), session).apply(self);
            return n;
        }
    }

    public static int Release(MemoryAddress self) {
        try (MemorySession session = MemorySession.openConfined();){
            int n = IOUSBDeviceInterface.Release(IoKitUSB.getVtable(self, session), session).apply(self);
            return n;
        }
    }

    public static int USBDeviceOpen(MemoryAddress self) {
        try (MemorySession session = MemorySession.openConfined();){
            int n = IOUSBDeviceInterface.USBDeviceOpen(IoKitUSB.getVtable(self, session), session).apply(self);
            return n;
        }
    }

    public static int USBDeviceClose(MemoryAddress self) {
        try (MemorySession session = MemorySession.openConfined();){
            int n = IOUSBDeviceInterface.USBDeviceClose(IoKitUSB.getVtable(self, session), session).apply(self);
            return n;
        }
    }

    public static int GetConfigurationDescriptorPtr(MemoryAddress self, byte configIndex, MemoryAddress descHolder) {
        try (MemorySession session = MemorySession.openConfined();){
            int n = IOUSBDeviceInterface.GetConfigurationDescriptorPtr(IoKitUSB.getVtable(self, session), session).apply(self, configIndex, descHolder);
            return n;
        }
    }

    public static int SetConfiguration(MemoryAddress self, byte configValue) {
        try (MemorySession session = MemorySession.openConfined();){
            int n = IOUSBDeviceInterface.SetConfiguration(IoKitUSB.getVtable(self, session), session).apply(self, configValue);
            return n;
        }
    }

    public static int CreateInterfaceIterator(MemoryAddress self, MemoryAddress req, MemoryAddress iter) {
        try (MemorySession session = MemorySession.openConfined();){
            int n = IOUSBDeviceInterface.CreateInterfaceIterator(IoKitUSB.getVtable(self, session), session).apply(self, req, iter);
            return n;
        }
    }

    public static int DeviceRequest(MemoryAddress self, MemoryAddress deviceRequest) {
        try (MemorySession session = MemorySession.openConfined();){
            int n = IOUSBDeviceInterface.DeviceRequest(IoKitUSB.getVtable(self, session), session).apply(self, deviceRequest);
            return n;
        }
    }

    public static int USBInterfaceOpen(MemoryAddress self) {
        try (MemorySession session = MemorySession.openConfined();){
            int n = IOUSBInterfaceInterface.USBInterfaceOpen(IoKitUSB.getVtable(self, session), session).apply(self);
            return n;
        }
    }

    public static int USBInterfaceClose(MemoryAddress self) {
        try (MemorySession session = MemorySession.openConfined();){
            int n = IOUSBInterfaceInterface.USBInterfaceClose(IoKitUSB.getVtable(self, session), session).apply(self);
            return n;
        }
    }

    public static int GetInterfaceNumber(MemoryAddress self, MemoryAddress intfNumberHolder) {
        try (MemorySession session = MemorySession.openConfined();){
            int n = IOUSBInterfaceInterface.GetInterfaceNumber(IoKitUSB.getVtable(self, session), session).apply(self, intfNumberHolder);
            return n;
        }
    }

    public static int GetNumEndpoints(MemoryAddress self, MemoryAddress intfNumEndpointsHolder) {
        try (MemorySession session = MemorySession.openConfined();){
            int n = IOUSBInterfaceInterface.GetNumEndpoints(IoKitUSB.getVtable(self, session), session).apply(self, intfNumEndpointsHolder);
            return n;
        }
    }

    public static int GetPipeProperties(MemoryAddress self, byte pipeRef, MemoryAddress directionHolder, MemoryAddress numberHolder, MemoryAddress transferTypeHolder, MemoryAddress maxPacketSizeHolder, MemoryAddress intervalHolder) {
        try (MemorySession session = MemorySession.openConfined();){
            int n = IOUSBInterfaceInterface.GetPipeProperties(IoKitUSB.getVtable(self, session), session).apply(self, pipeRef, directionHolder, numberHolder, transferTypeHolder, maxPacketSizeHolder, intervalHolder);
            return n;
        }
    }

    public static int ReadPipe(MemoryAddress self, byte pipeRef, MemoryAddress buf, MemoryAddress sizeHolder) {
        try (MemorySession session = MemorySession.openConfined();){
            int n = IOUSBInterfaceInterface.ReadPipe(IoKitUSB.getVtable(self, session), session).apply(self, pipeRef, buf, sizeHolder);
            return n;
        }
    }

    public static int ReadPipeTO(MemoryAddress self, byte pipeRef, MemoryAddress buf, MemoryAddress sizeHolder, int noDataTimeout, int completionTimeout) {
        try (MemorySession session = MemorySession.openConfined();){
            int n = IOUSBInterfaceInterface.ReadPipeTO(IoKitUSB.getVtable(self, session), session).apply(self, pipeRef, buf, sizeHolder, noDataTimeout, completionTimeout);
            return n;
        }
    }

    public static int WritePipe(MemoryAddress self, byte pipeRef, MemoryAddress buf, int size) {
        try (MemorySession session = MemorySession.openConfined();){
            int n = IOUSBInterfaceInterface.WritePipe(IoKitUSB.getVtable(self, session), session).apply(self, pipeRef, buf, size);
            return n;
        }
    }

    public static int WritePipeTO(MemoryAddress self, byte pipeRef, MemoryAddress buf, int size, int noDataTimeout, int completionTimeout) {
        try (MemorySession session = MemorySession.openConfined();){
            int n = IOUSBInterfaceInterface.WritePipeTO(IoKitUSB.getVtable(self, session), session).apply(self, pipeRef, buf, size, noDataTimeout, completionTimeout);
            return n;
        }
    }

    public static int AbortPipe(MemoryAddress self, byte pipeRef) {
        try (MemorySession session = MemorySession.openConfined();){
            int n = IOUSBInterfaceInterface.AbortPipe(IoKitUSB.getVtable(self, session), session).apply(self, pipeRef);
            return n;
        }
    }

    public static int SetAlternateInterface(MemoryAddress self, byte alternateSetting) {
        try (MemorySession session = MemorySession.openConfined();){
            int n = IOUSBInterfaceInterface.SetAlternateInterface(IoKitUSB.getVtable(self, session), session).apply(self, alternateSetting);
            return n;
        }
    }

    public static int ClearPipeStallBothEnds(MemoryAddress self, byte pipeRef) {
        try (MemorySession session = MemorySession.openConfined();){
            int n = IOUSBInterfaceStruct942.ClearPipeStallBothEnds(IoKitUSB.getVtable(self, session), session).apply(self, pipeRef);
            return n;
        }
    }
}

