/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.macos;

import java.lang.foreign.MemoryAddress;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import java.lang.foreign.ValueLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.codecrete.usb.USBAlternateInterface;
import net.codecrete.usb.USBControlTransfer;
import net.codecrete.usb.USBDirection;
import net.codecrete.usb.USBTimeoutException;
import net.codecrete.usb.USBTransferType;
import net.codecrete.usb.common.Configuration;
import net.codecrete.usb.common.USBDeviceImpl;
import net.codecrete.usb.common.USBInterfaceImpl;
import net.codecrete.usb.macos.IoKitUSB;
import net.codecrete.usb.macos.MacosUSBException;
import net.codecrete.usb.macos.TransferTimeout;
import net.codecrete.usb.macos.gen.iokit.IOKit;
import net.codecrete.usb.macos.gen.iokit.IOUSBDevRequest;
import net.codecrete.usb.usbstandard.ConfigurationDescriptor;

public class MacosUSBDevice
extends USBDeviceImpl {
    private final MemoryAddress device;
    private int configurationValue;
    private List<InterfaceInfo> claimedInterfaces;
    private Map<Byte, EndpointInfo> endpoints;

    MacosUSBDevice(MemoryAddress device, Object id, int vendorId, int productId) {
        super(id, vendorId, productId);
        this.device = device;
        this.loadDescription();
        IoKitUSB.AddRef(device);
    }

    @Override
    public boolean isOpen() {
        return this.claimedInterfaces != null;
    }

    @Override
    public void open() {
        int ret;
        if (this.isOpen()) {
            MacosUSBException.throwException("the device is already open", new Object[0]);
        }
        if ((ret = IoKitUSB.USBDeviceOpen(this.device)) != 0) {
            MacosUSBException.throwException(ret, "unable to open USB device", new Object[0]);
        }
        if ((ret = IoKitUSB.SetConfiguration(this.device, (byte)this.configurationValue)) != 0) {
            MacosUSBException.throwException(ret, "failed to set configuration", new Object[0]);
        }
        this.claimedInterfaces = new ArrayList<InterfaceInfo>();
        this.updateEndpointList();
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        for (InterfaceInfo interfaceInfo : this.claimedInterfaces) {
            IoKitUSB.USBInterfaceClose(interfaceInfo.asAddress());
            IoKitUSB.Release(interfaceInfo.asAddress());
            this.setClaimed(interfaceInfo.interfaceNumber, false);
        }
        this.claimedInterfaces = null;
        this.endpoints = null;
        IoKitUSB.USBDeviceClose(this.device);
    }

    void closeFully() {
        this.close();
        IoKitUSB.Release(this.device);
    }

    private void loadDescription() {
        try (MemorySession session = MemorySession.openConfined();){
            this.configurationValue = 0;
            MemorySegment descPtrHolder = session.allocate((MemoryLayout)ValueLayout.ADDRESS);
            int ret = IoKitUSB.GetConfigurationDescriptorPtr(this.device, (byte)0, descPtrHolder.address());
            if (ret != 0) {
                MacosUSBException.throwException(ret, "failed to query first configuration", new Object[0]);
            }
            ConfigurationDescriptor configDescHeader = new ConfigurationDescriptor(MemorySegment.ofAddress((MemoryAddress)descPtrHolder.get((ValueLayout.OfAddress)ValueLayout.ADDRESS, 0L), (long)ConfigurationDescriptor.LAYOUT.byteSize(), (MemorySession)session));
            int totalLength = configDescHeader.totalLength();
            MemorySegment configDesc = MemorySegment.ofAddress((MemoryAddress)descPtrHolder.get((ValueLayout.OfAddress)ValueLayout.ADDRESS, 0L), (long)totalLength, (MemorySession)session);
            Configuration configuration = this.setConfigurationDescriptor(configDesc);
            this.configurationValue = 0xFF & configuration.configValue();
        }
    }

    /*
     * Exception decompiling
     */
    private InterfaceInfo findInterface(int interfaceNumber) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void claimInterface(int interfaceNumber) {
        this.checkIsOpen();
        InterfaceInfo interfaceInfo = this.findInterface(interfaceNumber);
        try {
            int ret = IoKitUSB.USBInterfaceOpen(interfaceInfo.asAddress());
            if (ret != 0) {
                MacosUSBException.throwException(ret, "Failed to claim interface", new Object[0]);
            }
            this.setClaimed(interfaceNumber, true);
        }
        catch (Throwable t) {
            IoKitUSB.Release(interfaceInfo.asAddress());
            throw t;
        }
        this.claimedInterfaces.add(interfaceInfo);
        this.updateEndpointList();
    }

    @Override
    public void selectAlternateSetting(int interfaceNumber, int alternateNumber) {
        InterfaceInfo intfInfo;
        int ret;
        USBAlternateInterface altSetting;
        USBInterfaceImpl intf = this.getInterface(interfaceNumber);
        if (intf == null) {
            MacosUSBException.throwException("Interface %d does not exist", interfaceNumber);
        }
        if (!intf.isClaimed()) {
            MacosUSBException.throwException("Interface %d has not been claimed", interfaceNumber);
        }
        if ((altSetting = intf.getAlternate(alternateNumber)) == null) {
            MacosUSBException.throwException("Interface %d does not have an alternate interface setting %d", interfaceNumber, alternateNumber);
        }
        if ((ret = IoKitUSB.SetAlternateInterface((intfInfo = this.claimedInterfaces.stream().filter(interf -> interf.interfaceNumber() == interfaceNumber).findFirst().get()).asAddress(), (byte)alternateNumber)) != 0) {
            MacosUSBException.throwException(ret, "Failed to set alternate interface", new Object[0]);
        }
        intf.setAlternate(altSetting);
        this.updateEndpointList();
    }

    @Override
    public void releaseInterface(int interfaceNumber) {
        InterfaceInfo interfaceInfo;
        int ret;
        this.checkIsOpen();
        Optional<InterfaceInfo> interfaceInfoOptional = this.claimedInterfaces.stream().filter(info -> info.interfaceNumber == interfaceNumber).findFirst();
        if (interfaceInfoOptional.isEmpty()) {
            MacosUSBException.throwException("Invalid interface number: %d", interfaceNumber);
        }
        if ((ret = IoKitUSB.USBInterfaceClose((interfaceInfo = interfaceInfoOptional.get()).asAddress())) != 0) {
            MacosUSBException.throwException(ret, "Failed to release interface", new Object[0]);
        }
        this.claimedInterfaces.remove(interfaceInfo);
        IoKitUSB.Release(interfaceInfo.asAddress());
        this.setClaimed(interfaceNumber, false);
        this.updateEndpointList();
    }

    private void updateEndpointList() {
        this.endpoints = new HashMap<Byte, EndpointInfo>();
        for (InterfaceInfo interfaceInfo : this.claimedInterfaces) {
            MemorySession session = MemorySession.openConfined();
            try {
                MemoryAddress intf = interfaceInfo.asAddress();
                MemorySegment numEndpointsHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_BYTE);
                int ret = IoKitUSB.GetNumEndpoints(intf, numEndpointsHolder.address());
                if (ret != 0) {
                    MacosUSBException.throwException(ret, "Failed to get number of endpoints", new Object[0]);
                }
                int numEndpoints = numEndpointsHolder.get(ValueLayout.JAVA_BYTE, 0L) & 0xFF;
                for (int pipeIndex = 1; pipeIndex <= numEndpoints; ++pipeIndex) {
                    MemorySegment directionHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_BYTE);
                    MemorySegment numberHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_BYTE);
                    MemorySegment transferTypeHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_BYTE);
                    MemorySegment maxPacketSizeHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_SHORT);
                    MemorySegment intervalHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_BYTE);
                    ret = IoKitUSB.GetPipeProperties(intf, (byte)pipeIndex, directionHolder.address(), numberHolder.address(), transferTypeHolder.address(), maxPacketSizeHolder.address(), intervalHolder.address());
                    if (ret != 0) {
                        MacosUSBException.throwException(ret, "Failed to get pipe properties", new Object[0]);
                    }
                    int endpointNumber = numberHolder.get(ValueLayout.JAVA_BYTE, 0L) & 0xFF;
                    int direction = directionHolder.get(ValueLayout.JAVA_BYTE, 0L) & 0xFF;
                    byte endpointAddress = (byte)(endpointNumber | direction << 7);
                    byte transferType = transferTypeHolder.get(ValueLayout.JAVA_BYTE, 0L);
                    int maxPacketSize = maxPacketSizeHolder.get(ValueLayout.JAVA_SHORT, 0L) & 0xFFFF;
                    EndpointInfo endpointInfo = new EndpointInfo(interfaceInfo.addr, (byte)pipeIndex, MacosUSBDevice.getTransferType(transferType), maxPacketSize);
                    this.endpoints.put(endpointAddress, endpointInfo);
                }
            }
            finally {
                if (session == null) continue;
                session.close();
            }
        }
    }

    private EndpointInfo getEndpointInfo(int endpointNumber, USBDirection direction, USBTransferType transferType1, USBTransferType transferType2) {
        byte endpointAddress;
        EndpointInfo endpointInfo;
        if (this.endpoints != null && (endpointInfo = this.endpoints.get(endpointAddress = (byte)(endpointNumber | (direction == USBDirection.IN ? 128 : 0)))) != null && (endpointInfo.transferType == transferType1 || endpointInfo.transferType == transferType2)) {
            return endpointInfo;
        }
        String transferTypeDesc = transferType2 == null ? transferType1.name() : String.format("%s or %s", transferType1.name(), transferType2.name());
        MacosUSBException.throwException("Endpoint number %d does not exist, is not part of a claimed interface  or is not valid for %s transfer in %s direction", endpointNumber, transferTypeDesc, direction.name());
        throw new AssertionError((Object)"not reached");
    }

    private static MemorySegment createDeviceRequest(MemorySession session, USBDirection direction, USBControlTransfer setup, MemorySegment data) {
        MemorySegment deviceRequest = session.allocate(IOUSBDevRequest.$LAYOUT());
        int bmRequestType = (direction == USBDirection.IN ? 128 : 0) | setup.requestType().ordinal() << 5 | setup.recipient().ordinal();
        IOUSBDevRequest.bmRequestType$set(deviceRequest, (byte)bmRequestType);
        IOUSBDevRequest.bRequest$set(deviceRequest, (byte)setup.request());
        IOUSBDevRequest.wValue$set(deviceRequest, (short)setup.value());
        IOUSBDevRequest.wIndex$set(deviceRequest, (short)setup.index());
        IOUSBDevRequest.wLength$set(deviceRequest, (short)data.byteSize());
        IOUSBDevRequest.pData$set(deviceRequest, data.address());
        return deviceRequest;
    }

    @Override
    public byte[] controlTransferIn(USBControlTransfer setup, int length) {
        this.checkIsOpen();
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment data = session.allocate((long)length);
            MemorySegment deviceRequest = MacosUSBDevice.createDeviceRequest(session, USBDirection.IN, setup, data);
            int ret = IoKitUSB.DeviceRequest(this.device, deviceRequest.address());
            if (ret != 0) {
                MacosUSBException.throwException(ret, "Control IN transfer failed", new Object[0]);
            }
            int lenDone = IOUSBDevRequest.wLenDone$get(deviceRequest);
            byte[] byArray = data.asSlice(0L, lenDone).toArray(ValueLayout.JAVA_BYTE);
            return byArray;
        }
    }

    @Override
    public void controlTransferOut(USBControlTransfer setup, byte[] data) {
        this.checkIsOpen();
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment deviceRequest;
            int ret;
            int dataLength = data != null ? data.length : 0;
            MemorySegment dataSegment = session.allocate((long)dataLength);
            if (dataLength > 0) {
                dataSegment.copyFrom(MemorySegment.ofArray(data));
            }
            if ((ret = IoKitUSB.DeviceRequest(this.device, (deviceRequest = MacosUSBDevice.createDeviceRequest(session, USBDirection.OUT, setup, dataSegment)).address())) != 0) {
                MacosUSBException.throwException(ret, "Control IN transfer failed", new Object[0]);
            }
        }
    }

    @Override
    public void transferOut(int endpointNumber, byte[] data, int timeout) {
        EndpointInfo endpointInfo = this.getEndpointInfo(endpointNumber, USBDirection.OUT, USBTransferType.BULK, USBTransferType.INTERRUPT);
        try (MemorySession session = MemorySession.openConfined();){
            int ret;
            MemorySegment nativeData = session.allocateArray((MemoryLayout)ValueLayout.JAVA_BYTE, (long)data.length);
            nativeData.copyFrom(MemorySegment.ofArray(data));
            if (timeout <= 0) {
                ret = IoKitUSB.WritePipe(endpointInfo.interfaceAddress(), endpointInfo.pipeIndex, nativeData.address(), data.length);
            } else if (endpointInfo.transferType == USBTransferType.BULK) {
                ret = IoKitUSB.WritePipeTO(endpointInfo.interfaceAddress(), endpointInfo.pipeIndex, nativeData.address(), data.length, timeout, timeout);
                if (ret == IOKit.kIOUSBTransactionTimeout()) {
                    throw new USBTimeoutException("Transfer out aborted due to timeout");
                }
            } else {
                TransferTimeout transferTimeout = new TransferTimeout(endpointInfo, timeout);
                ret = IoKitUSB.WritePipe(endpointInfo.interfaceAddress(), endpointInfo.pipeIndex, nativeData.address(), data.length);
                if (ret == IOKit.kIOReturnAborted()) {
                    throw new USBTimeoutException("Transfer out aborted due to timeout");
                }
                transferTimeout.markCompleted();
            }
            if (ret != 0) {
                MacosUSBException.throwException(ret, "Sending data to endpoint %d failed", endpointNumber);
            }
        }
    }

    @Override
    public byte[] transferIn(int endpointNumber, int timeout) {
        EndpointInfo endpoint = this.getEndpointInfo(endpointNumber, USBDirection.IN, USBTransferType.BULK, USBTransferType.INTERRUPT);
        try (MemorySession session = MemorySession.openConfined();){
            int ret;
            MemorySegment nativeData = session.allocateArray((MemoryLayout)ValueLayout.JAVA_BYTE, (long)endpoint.packetSize());
            MemorySegment sizeHolder = session.allocate(ValueLayout.JAVA_INT, endpoint.packetSize());
            if (timeout <= 0) {
                ret = IoKitUSB.ReadPipe(endpoint.interfaceAddress(), endpoint.pipeIndex, nativeData.address(), sizeHolder.address());
            } else if (endpoint.transferType == USBTransferType.BULK) {
                ret = IoKitUSB.ReadPipeTO(endpoint.interfaceAddress(), endpoint.pipeIndex, nativeData.address(), sizeHolder.address(), timeout, timeout);
                if (ret == IOKit.kIOUSBTransactionTimeout()) {
                    throw new USBTimeoutException("Transfer in aborted due to timeout");
                }
            } else {
                TransferTimeout transferTimeout = new TransferTimeout(endpoint, timeout);
                ret = IoKitUSB.ReadPipe(endpoint.interfaceAddress(), endpoint.pipeIndex, nativeData.address(), sizeHolder.address());
                if (ret == IOKit.kIOReturnAborted()) {
                    throw new USBTimeoutException("Transfer in aborted due to timeout");
                }
                transferTimeout.markCompleted();
            }
            if (ret != 0) {
                MacosUSBException.throwException(ret, "Receiving data from endpoint %d failed", endpointNumber);
            }
            int size = sizeHolder.get(ValueLayout.JAVA_INT, 0L);
            byte[] result = new byte[size];
            MemorySegment resultSegment = MemorySegment.ofArray(result);
            resultSegment.copyFrom(nativeData.asSlice(0L, size));
            byte[] byArray = result;
            return byArray;
        }
    }

    @Override
    public void clearHalt(USBDirection direction, int endpointNumber) {
        EndpointInfo endpointInfo = this.getEndpointInfo(endpointNumber, direction, USBTransferType.BULK, USBTransferType.INTERRUPT);
        int ret = IoKitUSB.ClearPipeStallBothEnds(endpointInfo.interfaceAddress(), endpointInfo.pipeIndex);
        if (ret != 0) {
            MacosUSBException.throwException(ret, "Clearing halt condition failed", new Object[0]);
        }
    }

    private static USBTransferType getTransferType(byte macosTransferType) {
        return switch (macosTransferType) {
            case 1 -> USBTransferType.ISOCHRONOUS;
            case 2 -> USBTransferType.BULK;
            case 3 -> USBTransferType.INTERRUPT;
            default -> null;
        };
    }

    private static /* synthetic */ void lambda$findInterface$1(int service_final) {
        IOKit.IOObjectRelease(service_final);
    }

    private static /* synthetic */ void lambda$findInterface$0(int iter) {
        IOKit.IOObjectRelease(iter);
    }

    record InterfaceInfo(long addr, int interfaceNumber) {
        MemoryAddress asAddress() {
            return MemoryAddress.ofLong((long)this.addr);
        }
    }

    record EndpointInfo(long interfaceAddr, byte pipeIndex, USBTransferType transferType, int packetSize) {
        MemoryAddress interfaceAddress() {
            return MemoryAddress.ofLong((long)this.interfaceAddr);
        }
    }
}

