/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.macos;

import java.lang.foreign.Addressable;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryAddress;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.codecrete.usb.USBDevice;
import net.codecrete.usb.common.USBDeviceRegistry;
import net.codecrete.usb.macos.IoKitHelper;
import net.codecrete.usb.macos.IoKitUSB;
import net.codecrete.usb.macos.MacosUSBDevice;
import net.codecrete.usb.macos.MacosUSBException;
import net.codecrete.usb.macos.gen.corefoundation.CoreFoundation;
import net.codecrete.usb.macos.gen.iokit.IOKit;

public class MacosUSBDeviceRegistry
extends USBDeviceRegistry {
    @Override
    protected void monitorDevices() {
        MemorySession session = MemorySession.openConfined();
        try {
            try {
                MemoryAddress notifyPort = IOKit.IONotificationPortCreate(IOKit.kIOMasterPortDefault$get());
                MemoryAddress runLoopSource = IOKit.IONotificationPortGetRunLoopSource((Addressable)notifyPort);
                MemoryAddress runLoop = CoreFoundation.CFRunLoopGetCurrent();
                CoreFoundation.CFRunLoopAddSource((Addressable)runLoop, (Addressable)runLoopSource, (Addressable)IOKit.kCFRunLoopDefaultMode$get());
                MethodHandle onDeviceConnectedMH = MethodHandles.lookup().findVirtual(MacosUSBDeviceRegistry.class, "onDevicesConnected", MethodType.methodType(Void.TYPE, MemoryAddress.class, Integer.TYPE));
                int deviceConnectedIter = this.setupNotification(session, notifyPort, IOKit.kIOFirstMatchNotification(), onDeviceConnectedMH);
                ArrayList<USBDevice> deviceList = new ArrayList<USBDevice>();
                this.iterateDevices(deviceConnectedIter, (USBDevice device) -> deviceList.add((USBDevice)device));
                this.setInitialDeviceList(deviceList);
                MethodHandle onDeviceDisconnectedMH = MethodHandles.lookup().findVirtual(MacosUSBDeviceRegistry.class, "onDevicesDisconnected", MethodType.methodType(Void.TYPE, MemoryAddress.class, Integer.TYPE));
                int deviceDisconnectedIter = this.setupNotification(session, notifyPort, IOKit.kIOTerminatedNotification(), onDeviceDisconnectedMH);
                this.onDevicesDisconnected(MemoryAddress.NULL, deviceDisconnectedIter);
            }
            catch (Throwable e) {
                this.enumerationFailed(e);
                if (session != null) {
                    session.close();
                }
                return;
            }
            CoreFoundation.CFRunLoopRun();
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private void iterateDevices(int iterator, IOKitDeviceConsumer consumer) {
        int svc;
        while ((svc = IOKit.IOIteratorNext(iterator)) != 0) {
            MemorySession session = MemorySession.openConfined();
            try {
                MemorySegment entryIdHolder;
                int ret;
                int service = svc;
                session.addCloseAction(() -> IOKit.IOObjectRelease(service));
                MemoryAddress device = IoKitHelper.getInterface(service, (Addressable)IoKitHelper.kIOUSBDeviceUserClientTypeID, IoKitHelper.kIOUSBDeviceInterfaceID100);
                if (device != null) {
                    session.addCloseAction(() -> IoKitUSB.Release(device));
                }
                if ((ret = IOKit.IORegistryEntryGetRegistryEntryID(service, (Addressable)(entryIdHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_LONG)))) != 0) {
                    MacosUSBException.throwException(ret, "IORegistryEntryGetRegistryEntryID failed", new Object[0]);
                }
                long entryId = entryIdHolder.get(ValueLayout.JAVA_LONG, 0L);
                consumer.accept(entryId, service, device);
            }
            finally {
                if (session == null) continue;
                session.close();
            }
        }
    }

    private void iterateDevices(int iterator, Consumer<USBDevice> consumer) {
        this.iterateDevices(iterator, (long entryId, int service, MemoryAddress deviceIntf) -> {
            VidPid deviceInfo = new VidPid();
            try {
                USBDevice device = this.createDevice(entryId, service, deviceIntf, deviceInfo);
                if (device != null) {
                    consumer.accept(device);
                }
            }
            catch (Throwable e) {
                System.err.printf("Info: [JavaDoesUSB] failed to retrieve information about device 0x%04x/0x%04x - ignoring device%n", deviceInfo.vid, deviceInfo.pid);
                e.printStackTrace(System.err);
            }
        });
    }

    private USBDevice createDevice(Long entryID, int service, MemoryAddress deviceIntf, VidPid info) {
        if (deviceIntf == null) {
            return null;
        }
        Integer vendorId = IoKitHelper.getPropertyInt(service, "idVendor");
        Integer productId = IoKitHelper.getPropertyInt(service, "idProduct");
        if (vendorId == null || productId == null) {
            return null;
        }
        info.vid = vendorId;
        info.pid = productId;
        MacosUSBDevice device = new MacosUSBDevice(deviceIntf, entryID, vendorId, productId);
        String manufacturer = IoKitHelper.getPropertyString(service, "kUSBVendorString");
        String product = IoKitHelper.getPropertyString(service, "kUSBProductString");
        String serial = IoKitHelper.getPropertyString(service, "kUSBSerialNumberString");
        device.setProductStrings(manufacturer, product, serial);
        Integer classCode = IoKitHelper.getPropertyInt(service, "bDeviceClass");
        Integer subclassCode = IoKitHelper.getPropertyInt(service, "bDeviceSubClass");
        Integer protocolCode = IoKitHelper.getPropertyInt(service, "bDeviceProtocol");
        device.setClassCodes(classCode != null ? classCode : 0, subclassCode != null ? subclassCode : 0, protocolCode != null ? protocolCode : 0);
        Integer usbVersion = IoKitHelper.getPropertyInt(service, "bcdUSB");
        Integer deviceVersion = IoKitHelper.getPropertyInt(service, "bcdDevice");
        device.setVersions(usbVersion, deviceVersion != null ? deviceVersion : 0);
        return device;
    }

    private int setupNotification(MemorySession session, MemoryAddress notifyPort, MemorySegment notificationType, MethodHandle callback) {
        MemorySegment deviceIterHolder;
        MemoryAddress matchingDict = IOKit.IOServiceMatching((Addressable)IOKit.kIOUSBDeviceClassName());
        MemorySegment onDeviceCallbackStub = Linker.nativeLinker().upcallStub(callback.bindTo(this), FunctionDescriptor.ofVoid(ValueLayout.ADDRESS, ValueLayout.JAVA_INT), session);
        int ret = IOKit.IOServiceAddMatchingNotification((Addressable)notifyPort, (Addressable)notificationType, (Addressable)matchingDict, (Addressable)onDeviceCallbackStub, (Addressable)MemoryAddress.NULL, (Addressable)(deviceIterHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_INT)));
        if (ret != 0) {
            MacosUSBException.throwException(ret, "IOServiceAddMatchingNotification failed", new Object[0]);
        }
        return deviceIterHolder.get(ValueLayout.JAVA_INT, 0L);
    }

    private void onDevicesConnected(MemoryAddress ignoredRefCon, int iterator) {
        this.iterateDevices(iterator, (USBDevice x$0) -> this.addDevice((USBDevice)x$0));
    }

    private void onDevicesDisconnected(MemoryAddress ignoredRefCon, int iterator) {
        this.iterateDevices(iterator, (long entryId, int service, MemoryAddress deviceIntf) -> {
            USBDevice device = this.findDevice(entryId);
            if (device == null) {
                return;
            }
            try {
                ((MacosUSBDevice)device).closeFully();
            }
            catch (Throwable e) {
                System.err.println("Info: [JavaDoesUSB] failed to close USB device - ignoring exception");
                e.printStackTrace(System.err);
            }
            this.removeDevice(entryId);
        });
    }

    @FunctionalInterface
    static interface IOKitDeviceConsumer {
        public void accept(long var1, int var3, MemoryAddress var4);
    }

    static class VidPid {
        int vid;
        int pid;

        VidPid() {
        }
    }
}

