/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.macos;

import java.lang.foreign.MemoryAddress;
import net.codecrete.usb.USBException;
import net.codecrete.usb.USBStallException;
import net.codecrete.usb.macos.gen.iokit.IOKit;
import net.codecrete.usb.macos.gen.mach.mach;

public class MacosUSBException
extends USBException {
    public MacosUSBException(String message, int errorCode) {
        super(String.format("%s. %s", message, MacosUSBException.machErrorMessage(errorCode)), errorCode);
    }

    private static String machErrorMessage(int errorCode) {
        MemoryAddress msg = mach.mach_error_string(errorCode);
        return msg.getUtf8String(0L);
    }

    static void throwException(int errorCode, String message, Object ... args) {
        String formattedMessage = String.format(message, args);
        if (errorCode == IOKit.kIOUSBPipeStalled()) {
            throw new USBStallException(formattedMessage);
        }
        throw new MacosUSBException(formattedMessage, errorCode);
    }

    static void throwException(String message, Object ... args) {
        throw new USBException(String.format(message, args));
    }
}

