/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.macos;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.codecrete.usb.macos.IoKitUSB;
import net.codecrete.usb.macos.MacosUSBDevice;
import net.codecrete.usb.macos.MacosUSBException;

class TransferTimeout {
    private final ScheduledFuture<?> future;
    private final MacosUSBDevice.EndpointInfo endpointInfo;
    private boolean completed;
    private static ScheduledExecutorService scheduledExecutorService;

    TransferTimeout(MacosUSBDevice.EndpointInfo endpointInfo, int timeout) {
        this.endpointInfo = endpointInfo;
        this.future = TransferTimeout.getScheduledExecutorService().schedule(this::abort, (long)timeout, TimeUnit.MILLISECONDS);
    }

    private synchronized void abort() {
        if (this.completed) {
            return;
        }
        int ret = IoKitUSB.AbortPipe(this.endpointInfo.interfaceAddress(), this.endpointInfo.pipeIndex());
        if (ret != 0) {
            MacosUSBException.throwException(ret, "Failed to abort USB transfer after timeout", new Object[0]);
        }
    }

    synchronized void markCompleted() {
        if (this.completed) {
            return;
        }
        this.completed = true;
        this.future.cancel(false);
    }

    static synchronized ScheduledExecutorService getScheduledExecutorService() {
        if (scheduledExecutorService == null) {
            scheduledExecutorService = Executors.newScheduledThreadPool(1);
        }
        return scheduledExecutorService;
    }
}

