/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.usbstandard;

import java.lang.foreign.GroupLayout;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.VarHandle;

public class DeviceDescriptor {
    private final MemorySegment descriptor;
    public static final GroupLayout LAYOUT = MemoryLayout.structLayout((MemoryLayout[])new MemoryLayout[]{ValueLayout.JAVA_BYTE.withName("bLength"), ValueLayout.JAVA_BYTE.withName("bDescriptorType"), ValueLayout.JAVA_SHORT.withName("bcdUSB"), ValueLayout.JAVA_BYTE.withName("bDeviceClass"), ValueLayout.JAVA_BYTE.withName("bDeviceSubClass"), ValueLayout.JAVA_BYTE.withName("bDeviceProtocol"), ValueLayout.JAVA_BYTE.withName("bMaxPacketSize0"), ValueLayout.JAVA_SHORT.withName("idVendor"), ValueLayout.JAVA_SHORT.withName("idProduct"), ValueLayout.JAVA_SHORT.withName("bcdDevice"), ValueLayout.JAVA_BYTE.withName("iManufacturer"), ValueLayout.JAVA_BYTE.withName("iProduct"), ValueLayout.JAVA_BYTE.withName("iSerialNumber"), ValueLayout.JAVA_BYTE.withName("bNumConfigurations")});
    private static final VarHandle bcdUSB$VH = LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("bcdUSB"));
    private static final VarHandle bDeviceClass$VH = LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("bDeviceClass"));
    private static final VarHandle bDeviceSubClass$VH = LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("bDeviceSubClass"));
    private static final VarHandle bDeviceProtocol$VH = LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("bDeviceProtocol"));
    private static final VarHandle idVendor$VH = LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("idVendor"));
    private static final VarHandle idProduct$VH = LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("idProduct"));
    private static final VarHandle bcdDevice$VH = LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("bcdDevice"));
    private static final VarHandle iManufacturer$VH = LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("iManufacturer"));
    private static final VarHandle iProduct$VH = LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("iProduct"));
    private static final VarHandle iSerialNumber$VH = LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("iSerialNumber"));

    public DeviceDescriptor(MemorySegment descriptor) {
        this.descriptor = descriptor;
    }

    public int usbVersion() {
        return 0xFFFF & bcdUSB$VH.get(this.descriptor);
    }

    public int deviceClass() {
        return 0xFF & bDeviceClass$VH.get(this.descriptor);
    }

    public int deviceSubClass() {
        return 0xFF & bDeviceSubClass$VH.get(this.descriptor);
    }

    public int deviceProtocol() {
        return 0xFF & bDeviceProtocol$VH.get(this.descriptor);
    }

    public int vendorID() {
        return 0xFFFF & idVendor$VH.get(this.descriptor);
    }

    public int productID() {
        return 0xFFFF & idProduct$VH.get(this.descriptor);
    }

    public int deviceVersion() {
        return 0xFFFF & bcdDevice$VH.get(this.descriptor);
    }

    public int iManufacturer() {
        return 0xFFFF & iManufacturer$VH.get(this.descriptor);
    }

    public int iProduct() {
        return 0xFFFF & iProduct$VH.get(this.descriptor);
    }

    public int iSerialNumber() {
        return 0xFFFF & iSerialNumber$VH.get(this.descriptor);
    }

    static {
        assert (LAYOUT.byteSize() == 18L);
    }
}

