/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.windows;

import java.lang.foreign.Addressable;
import java.lang.foreign.MemoryAddress;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import java.lang.foreign.ValueLayout;
import java.util.ArrayList;
import java.util.List;
import net.codecrete.usb.windows.gen.kernel32.GUID;
import net.codecrete.usb.windows.gen.stdlib.StdLib;

public class Win {
    public static boolean IsInvalidHandle(MemoryAddress handle) {
        return handle.toRawLongValue() == -1L;
    }

    public static MemorySegment createSegmentFromString(String str, MemorySession session) {
        MemorySegment segment = session.allocateArray((MemoryLayout)ValueLayout.JAVA_CHAR, (long)(str.length() + 1));
        segment.copyFrom(MemorySegment.ofArray(str.toCharArray()));
        return segment;
    }

    public static String createStringFromSegment(MemorySegment segment) {
        long strLen = StdLib.wcslen((Addressable)segment);
        return new String(segment.asSlice(0L, 2L * strLen).toArray(ValueLayout.JAVA_CHAR));
    }

    public static List<String> createStringListFromSegment(MemorySegment segment) {
        ArrayList<String> stringList = new ArrayList<String>();
        int offset = 0;
        while (segment.get(ValueLayout.JAVA_CHAR, (long)offset) != '\u0000') {
            String str = Win.createStringFromSegment(segment.asSlice(offset));
            offset += str.length() * 2 + 2;
            stringList.add(str);
        }
        return stringList;
    }

    public static MemorySegment CreateGUID(int data1, short data2, short data3, byte data4_0, byte data4_1, byte data4_2, byte data4_3, byte data4_4, byte data4_5, byte data4_6, byte data4_7) {
        MemorySegment guid = MemorySegment.allocateNative((MemoryLayout)GUID.$LAYOUT(), (MemorySession)MemorySession.global());
        Win.setGUID(guid, data1, data2, data3, data4_0, data4_1, data4_2, data4_3, data4_4, data4_5, data4_6, data4_7);
        return guid;
    }

    public static void setGUID(MemorySegment guid, int data1, short data2, short data3, byte data4_0, byte data4_1, byte data4_2, byte data4_3, byte data4_4, byte data4_5, byte data4_6, byte data4_7) {
        GUID.Data1$set(guid, data1);
        GUID.Data2$set(guid, data2);
        GUID.Data3$set(guid, data3);
        MemorySegment data4 = GUID.Data4$slice(guid);
        data4.set(ValueLayout.JAVA_BYTE, 0L, data4_0);
        data4.set(ValueLayout.JAVA_BYTE, 1L, data4_1);
        data4.set(ValueLayout.JAVA_BYTE, 2L, data4_2);
        data4.set(ValueLayout.JAVA_BYTE, 3L, data4_3);
        data4.set(ValueLayout.JAVA_BYTE, 4L, data4_4);
        data4.set(ValueLayout.JAVA_BYTE, 5L, data4_5);
        data4.set(ValueLayout.JAVA_BYTE, 6L, data4_6);
        data4.set(ValueLayout.JAVA_BYTE, 7L, data4_7);
    }
}

