/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.windows;

import java.lang.foreign.Addressable;
import java.lang.foreign.MemoryAddress;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import java.lang.foreign.ValueLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.codecrete.usb.USBAlternateInterface;
import net.codecrete.usb.USBControlTransfer;
import net.codecrete.usb.USBDirection;
import net.codecrete.usb.USBInterface;
import net.codecrete.usb.USBRecipient;
import net.codecrete.usb.USBTimeoutException;
import net.codecrete.usb.USBTransferType;
import net.codecrete.usb.common.CompositeFunction;
import net.codecrete.usb.common.Configuration;
import net.codecrete.usb.common.USBDeviceImpl;
import net.codecrete.usb.common.USBInterfaceImpl;
import net.codecrete.usb.usbstandard.SetupPacket;
import net.codecrete.usb.windows.InterfaceHandle;
import net.codecrete.usb.windows.Win;
import net.codecrete.usb.windows.WindowsUSBException;
import net.codecrete.usb.windows.gen.kernel32.Kernel32;
import net.codecrete.usb.windows.gen.winusb.WinUSB;

public class WindowsUSBDevice
extends USBDeviceImpl {
    private List<InterfaceHandle> interfaceHandles_;
    private boolean isOpen_;

    WindowsUSBDevice(String devicePath, Map<Integer, String> children, int vendorId, int productId, MemorySegment configDesc) {
        super(devicePath, vendorId, productId);
        this.readDescription(configDesc, devicePath, children);
    }

    private void readDescription(MemorySegment configDesc, String devicePath, Map<Integer, String> children) {
        Configuration configuration = this.setConfigurationDescriptor(configDesc);
        this.interfaceHandles_ = new ArrayList<InterfaceHandle>();
        for (USBInterface intf : configuration.interfaces()) {
            int interfaceNumber = intf.number();
            CompositeFunction function = configuration.findFunction(interfaceNumber);
            InterfaceHandle intfHandle = new InterfaceHandle();
            intfHandle.interfaceNumber = interfaceNumber;
            if (function == null) {
                intfHandle.firstInterfaceNumber = interfaceNumber;
                intfHandle.devicePath = devicePath;
                devicePath = null;
            } else if (function.firstInterfaceNumber() == interfaceNumber) {
                intfHandle.firstInterfaceNumber = interfaceNumber;
                if (children != null) {
                    intfHandle.devicePath = children.get(interfaceNumber);
                } else {
                    intfHandle.devicePath = devicePath;
                    devicePath = null;
                }
            } else {
                intfHandle.firstInterfaceNumber = function.firstInterfaceNumber();
            }
            this.interfaceHandles_.add(intfHandle);
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen_;
    }

    @Override
    public void open() {
        if (this.isOpen()) {
            WindowsUSBException.throwException("the device is already open", new Object[0]);
        }
        this.isOpen_ = true;
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        for (USBInterface intf : this.interfaces_) {
            if (!intf.isClaimed()) continue;
            this.releaseInterface(intf.number());
        }
        this.isOpen_ = false;
    }

    @Override
    public void claimInterface(int interfaceNumber) {
        this.checkIsOpen();
        InterfaceHandle intfHandle = this.getInterfaceHandle(interfaceNumber);
        if (intfHandle.interfaceHandle != null) {
            WindowsUSBException.throwException("Interface %d has already been claimed", interfaceNumber);
        }
        InterfaceHandle firstIntfHandle = intfHandle;
        if (intfHandle.firstInterfaceNumber != interfaceNumber) {
            firstIntfHandle = this.getInterfaceHandle(intfHandle.firstInterfaceNumber);
        }
        if (firstIntfHandle.devicePath == null) {
            WindowsUSBException.throwException("Interface number %d cannot be claimed (non WinUSB device?)", interfaceNumber);
        }
        try (MemorySession session = MemorySession.openConfined();){
            MemoryAddress deviceHandle;
            if (firstIntfHandle.deviceHandle == null) {
                MemorySegment pathSegment = Win.createSegmentFromString(firstIntfHandle.devicePath, session);
                deviceHandle = Kernel32.CreateFileW((Addressable)pathSegment, Kernel32.GENERIC_WRITE() | Kernel32.GENERIC_READ(), Kernel32.FILE_SHARE_WRITE() | Kernel32.FILE_SHARE_READ(), (Addressable)MemoryAddress.NULL, Kernel32.OPEN_EXISTING(), Kernel32.FILE_ATTRIBUTE_NORMAL() | Kernel32.FILE_FLAG_OVERLAPPED(), (Addressable)MemoryAddress.NULL);
                if (Win.IsInvalidHandle(deviceHandle)) {
                    WindowsUSBException.throwLastError("Cannot open USB device %s", firstIntfHandle.devicePath);
                }
            } else {
                deviceHandle = firstIntfHandle.deviceHandle;
            }
            try {
                MemorySegment interfaceHandleHolder = session.allocate((MemoryLayout)ValueLayout.ADDRESS);
                if (WinUSB.WinUsb_Initialize((Addressable)deviceHandle, (Addressable)interfaceHandleHolder) == 0) {
                    WindowsUSBException.throwLastError("Cannot open WinUSB device", new Object[0]);
                }
                MemoryAddress interfaceHandle = interfaceHandleHolder.get((ValueLayout.OfAddress)ValueLayout.ADDRESS, 0L);
                firstIntfHandle.deviceHandle = deviceHandle;
                ++firstIntfHandle.deviceOpenCount;
                intfHandle.interfaceHandle = interfaceHandle;
            }
            catch (Throwable e) {
                Kernel32.CloseHandle((Addressable)deviceHandle);
                throw e;
            }
        }
        this.setClaimed(interfaceNumber, true);
    }

    @Override
    public void selectAlternateSetting(int interfaceNumber, int alternateNumber) {
        USBInterfaceImpl intf;
        USBAlternateInterface altSetting;
        this.checkIsOpen();
        InterfaceHandle intfHandle = this.getInterfaceHandle(interfaceNumber);
        if (intfHandle.interfaceHandle == null) {
            WindowsUSBException.throwException("Interface %d has not been claimed", interfaceNumber);
        }
        if ((altSetting = (intf = this.getInterface(interfaceNumber)).getAlternate(alternateNumber)) == null) {
            WindowsUSBException.throwException("Interface %d does not have an alternate interface setting %d", interfaceNumber, alternateNumber);
        }
        if (WinUSB.WinUsb_SetCurrentAlternateSetting((Addressable)intfHandle.interfaceHandle, (byte)alternateNumber) == 0) {
            WindowsUSBException.throwLastError("Failed to set alternate interface", new Object[0]);
        }
        intf.setAlternate(altSetting);
    }

    @Override
    public void releaseInterface(int interfaceNumber) {
        this.checkIsOpen();
        InterfaceHandle intfHandle = this.getInterfaceHandle(interfaceNumber);
        if (intfHandle.interfaceHandle == null) {
            WindowsUSBException.throwException("Interface %d has not been claimed", interfaceNumber);
        }
        InterfaceHandle firstIntfHandle = intfHandle;
        if (intfHandle.firstInterfaceNumber != interfaceNumber) {
            firstIntfHandle = this.getInterfaceHandle(intfHandle.firstInterfaceNumber);
        }
        WinUSB.WinUsb_Free((Addressable)intfHandle.interfaceHandle);
        intfHandle.interfaceHandle = null;
        --firstIntfHandle.deviceOpenCount;
        if (firstIntfHandle.deviceOpenCount == 0) {
            Kernel32.CloseHandle((Addressable)firstIntfHandle.deviceHandle);
            firstIntfHandle.deviceHandle = null;
        }
        this.setClaimed(interfaceNumber, false);
    }

    private MemorySegment createSetupPacket(MemorySession session, USBDirection direction, USBControlTransfer setup, MemorySegment data) {
        SetupPacket setupPacket = new SetupPacket(session);
        int bmRequest = (direction == USBDirection.IN ? 128 : 0) | setup.requestType().ordinal() << 5 | setup.recipient().ordinal();
        setupPacket.setRequestType(bmRequest);
        setupPacket.setRequest(setup.request());
        setupPacket.setValue(setup.value());
        setupPacket.setIndex(setup.index());
        setupPacket.setLength(data != null ? (int)data.byteSize() : 0);
        return setupPacket.segment();
    }

    @Override
    public byte[] controlTransferIn(USBControlTransfer setup, int length) {
        this.checkIsOpen();
        InterfaceHandle intfHandle = this.findControlTransferInterface(setup);
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment buffer = session.allocate((long)length);
            MemorySegment setupPacket = this.createSetupPacket(session, USBDirection.IN, setup, buffer);
            MemorySegment lengthHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_INT);
            if (WinUSB.WinUsb_ControlTransfer((Addressable)intfHandle.interfaceHandle, setupPacket, (Addressable)buffer, (int)buffer.byteSize(), (Addressable)lengthHolder, (Addressable)MemoryAddress.NULL) == 0) {
                WindowsUSBException.throwLastError("Control transfer IN failed", new Object[0]);
            }
            int rxLength = lengthHolder.get(ValueLayout.JAVA_INT, 0L);
            byte[] byArray = buffer.asSlice(0L, rxLength).toArray(ValueLayout.JAVA_BYTE);
            return byArray;
        }
    }

    @Override
    public void controlTransferOut(USBControlTransfer setup, byte[] data) {
        this.checkIsOpen();
        InterfaceHandle intfHandle = this.findControlTransferInterface(setup);
        try (MemorySession session = MemorySession.openConfined();){
            int dataLength = data != null ? data.length : 0;
            MemorySegment buffer = session.allocate((long)dataLength);
            if (dataLength != 0) {
                buffer.copyFrom(MemorySegment.ofArray(data));
            }
            MemorySegment setupPacket = this.createSetupPacket(session, USBDirection.OUT, setup, buffer);
            MemorySegment lengthHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_INT);
            if (WinUSB.WinUsb_ControlTransfer((Addressable)intfHandle.interfaceHandle, setupPacket, (Addressable)buffer, (int)buffer.byteSize(), (Addressable)lengthHolder, (Addressable)MemoryAddress.NULL) == 0) {
                WindowsUSBException.throwLastError("Control transfer OUT failed", new Object[0]);
            }
        }
    }

    @Override
    public void transferOut(int endpointNumber, byte[] data, int timeout) {
        this.checkIsOpen();
        USBDeviceImpl.EndpointInfo endpoint = this.getEndpoint(endpointNumber, USBDirection.OUT, USBTransferType.BULK, USBTransferType.INTERRUPT);
        InterfaceHandle intfHandle = this.getInterfaceHandle(endpoint.interfaceNumber());
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment timeoutHolder = session.allocate(ValueLayout.JAVA_INT, timeout);
            if (WinUSB.WinUsb_SetPipePolicy((Addressable)intfHandle.interfaceHandle, endpoint.endpointAddress(), WinUSB.PIPE_TRANSFER_TIMEOUT(), (int)timeoutHolder.byteSize(), (Addressable)timeoutHolder) == 0) {
                WindowsUSBException.throwLastError("Setting timeout failed", new Object[0]);
            }
            MemorySegment buffer = session.allocate((long)data.length);
            buffer.copyFrom(MemorySegment.ofArray(data));
            MemorySegment lengthHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_INT);
            if (WinUSB.WinUsb_WritePipe((Addressable)intfHandle.interfaceHandle, endpoint.endpointAddress(), (Addressable)buffer, (int)buffer.byteSize(), (Addressable)lengthHolder, (Addressable)MemoryAddress.NULL) == 0) {
                int err = Kernel32.GetLastError();
                if (err == Kernel32.ERROR_SEM_TIMEOUT()) {
                    throw new USBTimeoutException("Transfer out aborted due to timeout");
                }
                WindowsUSBException.throwException(err, "Bulk/interrupt transfer OUT failed", new Object[0]);
            }
        }
    }

    @Override
    public byte[] transferIn(int endpointNumber, int timeout) {
        USBDeviceImpl.EndpointInfo endpoint = this.getEndpoint(endpointNumber, USBDirection.IN, USBTransferType.BULK, USBTransferType.INTERRUPT);
        InterfaceHandle intfHandle = this.getInterfaceHandle(endpoint.interfaceNumber());
        try (MemorySession session = MemorySession.openConfined();){
            MemorySegment timeoutHolder = session.allocate(ValueLayout.JAVA_INT, timeout);
            if (WinUSB.WinUsb_SetPipePolicy((Addressable)intfHandle.interfaceHandle, endpoint.endpointAddress(), WinUSB.PIPE_TRANSFER_TIMEOUT(), (int)timeoutHolder.byteSize(), (Addressable)timeoutHolder) == 0) {
                WindowsUSBException.throwLastError("Setting timeout failed", new Object[0]);
            }
            MemorySegment buffer = session.allocate((long)endpoint.packetSize());
            MemorySegment lengthHolder = session.allocate((MemoryLayout)ValueLayout.JAVA_INT);
            if (WinUSB.WinUsb_ReadPipe((Addressable)intfHandle.interfaceHandle, endpoint.endpointAddress(), (Addressable)buffer, (int)buffer.byteSize(), (Addressable)lengthHolder, (Addressable)MemoryAddress.NULL) == 0) {
                int err = Kernel32.GetLastError();
                if (err == Kernel32.ERROR_SEM_TIMEOUT()) {
                    throw new USBTimeoutException("Transfer in aborted due to timeout");
                }
                WindowsUSBException.throwException(err, "Bulk/interrupt transfer IN failed", new Object[0]);
            }
            int len = lengthHolder.get(ValueLayout.JAVA_INT, 0L);
            byte[] byArray = buffer.asSlice(0L, len).toArray(ValueLayout.JAVA_BYTE);
            return byArray;
        }
    }

    @Override
    public void clearHalt(USBDirection direction, int endpointNumber) {
        USBDeviceImpl.EndpointInfo endpoint = this.getEndpoint(endpointNumber, direction, USBTransferType.BULK, USBTransferType.INTERRUPT);
        InterfaceHandle intfHandle = this.getInterfaceHandle(endpoint.interfaceNumber());
        if (WinUSB.WinUsb_ResetPipe((Addressable)intfHandle.interfaceHandle, endpoint.endpointAddress()) == 0) {
            WindowsUSBException.throwLastError("Clearing halt failed", new Object[0]);
        }
    }

    private InterfaceHandle getInterfaceHandle(int interfaceNumber) {
        for (InterfaceHandle intfHandle : this.interfaceHandles_) {
            if (intfHandle.interfaceNumber != interfaceNumber) continue;
            return intfHandle;
        }
        WindowsUSBException.throwException("Invalid interface number: %s", interfaceNumber);
        throw new AssertionError((Object)"not reached");
    }

    private InterfaceHandle findControlTransferInterface(USBControlTransfer setup) {
        int interfaceNumber = -1;
        if (setup.recipient() == USBRecipient.INTERFACE) {
            interfaceNumber = setup.index() & 0xFF;
        } else if (setup.recipient() == USBRecipient.ENDPOINT) {
            USBDirection direction;
            int endpointNumber = setup.index() & 0x7F;
            USBDirection uSBDirection = direction = (setup.index() & 0x80) != 0 ? USBDirection.IN : USBDirection.OUT;
            if (endpointNumber != 0 && (interfaceNumber = this.getInterfaceNumber(direction, endpointNumber)) == -1) {
                WindowsUSBException.throwException("Invalid endpoint number %d or interface not claimed", endpointNumber);
            }
        }
        if (interfaceNumber >= 0) {
            InterfaceHandle intfHandle = this.getInterfaceHandle(interfaceNumber);
            if (intfHandle.interfaceHandle == null) {
                WindowsUSBException.throwException("Interface number %d has not been claimed", interfaceNumber);
            }
            return intfHandle;
        }
        for (InterfaceHandle intfHandle : this.interfaceHandles_) {
            if (intfHandle.interfaceHandle == null) continue;
            return intfHandle;
        }
        WindowsUSBException.throwException("Control transfer failed as no interface has been claimed", new Object[0]);
        throw new AssertionError((Object)"not reached");
    }
}

