/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.linux;

import java.lang.foreign.Arena;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.StructLayout;
import java.lang.invoke.VarHandle;
import net.codecrete.usb.linux.gen.string.string;

class Linux {
    static final Linker.Option ERRNO_STATE = Linker.Option.captureCallState("errno");
    private static final StructLayout ERRNO_STATE_LAYOUT = Linker.Option.captureStateLayout();
    private static final VarHandle callState_errno$VH = ERRNO_STATE_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("errno"));

    private Linux() {
    }

    static MemorySegment allocateErrorState(Arena arena) {
        return arena.allocate(ERRNO_STATE_LAYOUT.byteSize());
    }

    static String getErrorMessage(int err) {
        return string.strerror(err).getString(0L);
    }

    static int getErrno(MemorySegment errorState) {
        return callState_errno$VH.get(errorState, 0);
    }
}

