/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.macos.gen.corefoundation;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.GroupLayout;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.PaddingLayout;
import java.lang.foreign.SegmentAllocator;
import java.lang.foreign.SequenceLayout;
import java.lang.foreign.StructLayout;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import net.codecrete.usb.macos.gen.corefoundation.CFRange;
import net.codecrete.usb.macos.gen.corefoundation.CFUUIDBytes;

public class CoreFoundation {
    static final Arena LIBRARY_ARENA = Arena.ofAuto();
    static final boolean TRACE_DOWNCALLS = Boolean.getBoolean("jextract.trace.downcalls");
    static final SymbolLookup SYMBOL_LOOKUP = SymbolLookup.libraryLookup("/System/Library/Frameworks/CoreFoundation.framework/CoreFoundation", LIBRARY_ARENA).or(SymbolLookup.loaderLookup()).or(Linker.nativeLinker().defaultLookup());
    public static final ValueLayout.OfBoolean C_BOOL = ValueLayout.JAVA_BOOLEAN;
    public static final ValueLayout.OfByte C_CHAR = ValueLayout.JAVA_BYTE;
    public static final ValueLayout.OfShort C_SHORT = ValueLayout.JAVA_SHORT;
    public static final ValueLayout.OfInt C_INT = ValueLayout.JAVA_INT;
    public static final ValueLayout.OfLong C_LONG_LONG = ValueLayout.JAVA_LONG;
    public static final ValueLayout.OfFloat C_FLOAT = ValueLayout.JAVA_FLOAT;
    public static final ValueLayout.OfDouble C_DOUBLE = ValueLayout.JAVA_DOUBLE;
    public static final AddressLayout C_POINTER = ValueLayout.ADDRESS.withTargetLayout(MemoryLayout.sequenceLayout(Long.MAX_VALUE, ValueLayout.JAVA_BYTE));
    public static final ValueLayout.OfLong C_LONG = ValueLayout.JAVA_LONG;
    private static final int kCFNumberSInt32Type = 3;

    CoreFoundation() {
    }

    static void traceDowncall(String name, Object ... args) {
        String traceArgs = Arrays.stream(args).map(Object::toString).collect(Collectors.joining(", "));
        System.out.printf("%s(%s)\n", name, traceArgs);
    }

    static MemorySegment findOrThrow(String symbol) {
        return SYMBOL_LOOKUP.find(symbol).orElseThrow(() -> new UnsatisfiedLinkError("unresolved symbol: " + symbol));
    }

    static MethodHandle upcallHandle(Class<?> fi, String name, FunctionDescriptor fdesc) {
        try {
            return MethodHandles.lookup().findVirtual(fi, name, fdesc.toMethodType());
        }
        catch (ReflectiveOperationException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static MemoryLayout align(MemoryLayout layout, long align) {
        MemoryLayout memoryLayout = layout;
        Objects.requireNonNull(memoryLayout);
        MemoryLayout memoryLayout2 = memoryLayout;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PaddingLayout.class, ValueLayout.class, GroupLayout.class, SequenceLayout.class}, (Object)memoryLayout2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                PaddingLayout p;
                yield p = (PaddingLayout)memoryLayout2;
            }
            case 1 -> {
                ValueLayout v = (ValueLayout)memoryLayout2;
                yield v.withByteAlignment(align);
            }
            case 2 -> {
                GroupLayout g = (GroupLayout)memoryLayout2;
                MemoryLayout[] alignedMembers = (MemoryLayout[])g.memberLayouts().stream().map(m -> CoreFoundation.align(m, align)).toArray(MemoryLayout[]::new);
                if (g instanceof StructLayout) {
                    yield MemoryLayout.structLayout(alignedMembers);
                }
                yield MemoryLayout.unionLayout(alignedMembers);
            }
            case 3 -> {
                SequenceLayout s = (SequenceLayout)memoryLayout2;
                yield MemoryLayout.sequenceLayout(s.elementCount(), CoreFoundation.align(s.elementLayout(), align));
            }
        };
    }

    public static FunctionDescriptor CFGetTypeID$descriptor() {
        return CFGetTypeID.DESC;
    }

    public static MethodHandle CFGetTypeID$handle() {
        return CFGetTypeID.HANDLE;
    }

    public static long CFGetTypeID(MemorySegment cf) {
        MethodHandle mh$ = CFGetTypeID.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                CoreFoundation.traceDowncall("CFGetTypeID", cf);
            }
            return mh$.invokeExact(cf);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor CFRelease$descriptor() {
        return CFRelease.DESC;
    }

    public static MethodHandle CFRelease$handle() {
        return CFRelease.HANDLE;
    }

    public static void CFRelease(MemorySegment cf) {
        MethodHandle mh$ = CFRelease.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                CoreFoundation.traceDowncall("CFRelease", cf);
            }
            mh$.invokeExact(cf);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor CFDataCreate$descriptor() {
        return CFDataCreate.DESC;
    }

    public static MethodHandle CFDataCreate$handle() {
        return CFDataCreate.HANDLE;
    }

    public static MemorySegment CFDataCreate(MemorySegment allocator, MemorySegment bytes, long length) {
        MethodHandle mh$ = CFDataCreate.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                CoreFoundation.traceDowncall("CFDataCreate", allocator, bytes, length);
            }
            return mh$.invokeExact(allocator, bytes, length);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor CFDataGetBytePtr$descriptor() {
        return CFDataGetBytePtr.DESC;
    }

    public static MethodHandle CFDataGetBytePtr$handle() {
        return CFDataGetBytePtr.HANDLE;
    }

    public static MemorySegment CFDataGetBytePtr(MemorySegment theData) {
        MethodHandle mh$ = CFDataGetBytePtr.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                CoreFoundation.traceDowncall("CFDataGetBytePtr", theData);
            }
            return mh$.invokeExact(theData);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor CFStringGetTypeID$descriptor() {
        return CFStringGetTypeID.DESC;
    }

    public static MethodHandle CFStringGetTypeID$handle() {
        return CFStringGetTypeID.HANDLE;
    }

    public static long CFStringGetTypeID() {
        MethodHandle mh$ = CFStringGetTypeID.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                CoreFoundation.traceDowncall("CFStringGetTypeID", new Object[0]);
            }
            return mh$.invokeExact();
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor CFStringCreateWithCharacters$descriptor() {
        return CFStringCreateWithCharacters.DESC;
    }

    public static MethodHandle CFStringCreateWithCharacters$handle() {
        return CFStringCreateWithCharacters.HANDLE;
    }

    public static MemorySegment CFStringCreateWithCharacters(MemorySegment alloc, MemorySegment chars, long numChars) {
        MethodHandle mh$ = CFStringCreateWithCharacters.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                CoreFoundation.traceDowncall("CFStringCreateWithCharacters", alloc, chars, numChars);
            }
            return mh$.invokeExact(alloc, chars, numChars);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor CFStringGetLength$descriptor() {
        return CFStringGetLength.DESC;
    }

    public static MethodHandle CFStringGetLength$handle() {
        return CFStringGetLength.HANDLE;
    }

    public static long CFStringGetLength(MemorySegment theString) {
        MethodHandle mh$ = CFStringGetLength.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                CoreFoundation.traceDowncall("CFStringGetLength", theString);
            }
            return mh$.invokeExact(theString);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor CFStringGetCharacters$descriptor() {
        return CFStringGetCharacters.DESC;
    }

    public static MethodHandle CFStringGetCharacters$handle() {
        return CFStringGetCharacters.HANDLE;
    }

    public static void CFStringGetCharacters(MemorySegment theString, MemorySegment range, MemorySegment buffer) {
        MethodHandle mh$ = CFStringGetCharacters.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                CoreFoundation.traceDowncall("CFStringGetCharacters", theString, range, buffer);
            }
            mh$.invokeExact(theString, range, buffer);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static int kCFNumberSInt32Type() {
        return 3;
    }

    public static FunctionDescriptor CFNumberGetTypeID$descriptor() {
        return CFNumberGetTypeID.DESC;
    }

    public static MethodHandle CFNumberGetTypeID$handle() {
        return CFNumberGetTypeID.HANDLE;
    }

    public static long CFNumberGetTypeID() {
        MethodHandle mh$ = CFNumberGetTypeID.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                CoreFoundation.traceDowncall("CFNumberGetTypeID", new Object[0]);
            }
            return mh$.invokeExact();
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor CFNumberGetValue$descriptor() {
        return CFNumberGetValue.DESC;
    }

    public static MethodHandle CFNumberGetValue$handle() {
        return CFNumberGetValue.HANDLE;
    }

    public static byte CFNumberGetValue(MemorySegment number, long theType, MemorySegment valuePtr) {
        MethodHandle mh$ = CFNumberGetValue.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                CoreFoundation.traceDowncall("CFNumberGetValue", number, theType, valuePtr);
            }
            return mh$.invokeExact(number, theType, valuePtr);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor CFRunLoopGetCurrent$descriptor() {
        return CFRunLoopGetCurrent.DESC;
    }

    public static MethodHandle CFRunLoopGetCurrent$handle() {
        return CFRunLoopGetCurrent.HANDLE;
    }

    public static MemorySegment CFRunLoopGetCurrent() {
        MethodHandle mh$ = CFRunLoopGetCurrent.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                CoreFoundation.traceDowncall("CFRunLoopGetCurrent", new Object[0]);
            }
            return mh$.invokeExact();
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor CFRunLoopRun$descriptor() {
        return CFRunLoopRun.DESC;
    }

    public static MethodHandle CFRunLoopRun$handle() {
        return CFRunLoopRun.HANDLE;
    }

    public static void CFRunLoopRun() {
        MethodHandle mh$ = CFRunLoopRun.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                CoreFoundation.traceDowncall("CFRunLoopRun", new Object[0]);
            }
            mh$.invokeExact();
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor CFRunLoopAddSource$descriptor() {
        return CFRunLoopAddSource.DESC;
    }

    public static MethodHandle CFRunLoopAddSource$handle() {
        return CFRunLoopAddSource.HANDLE;
    }

    public static void CFRunLoopAddSource(MemorySegment rl, MemorySegment source, MemorySegment mode) {
        MethodHandle mh$ = CFRunLoopAddSource.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                CoreFoundation.traceDowncall("CFRunLoopAddSource", rl, source, mode);
            }
            mh$.invokeExact(rl, source, mode);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor CFRunLoopRemoveSource$descriptor() {
        return CFRunLoopRemoveSource.DESC;
    }

    public static MethodHandle CFRunLoopRemoveSource$handle() {
        return CFRunLoopRemoveSource.HANDLE;
    }

    public static void CFRunLoopRemoveSource(MemorySegment rl, MemorySegment source, MemorySegment mode) {
        MethodHandle mh$ = CFRunLoopRemoveSource.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                CoreFoundation.traceDowncall("CFRunLoopRemoveSource", rl, source, mode);
            }
            mh$.invokeExact(rl, source, mode);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor CFUUIDGetUUIDBytes$descriptor() {
        return CFUUIDGetUUIDBytes.DESC;
    }

    public static MethodHandle CFUUIDGetUUIDBytes$handle() {
        return CFUUIDGetUUIDBytes.HANDLE;
    }

    public static MemorySegment CFUUIDGetUUIDBytes(SegmentAllocator allocator, MemorySegment uuid) {
        MethodHandle mh$ = CFUUIDGetUUIDBytes.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                CoreFoundation.traceDowncall("CFUUIDGetUUIDBytes", allocator, uuid);
            }
            return mh$.invokeExact(allocator, uuid);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor CFUUIDCreateFromUUIDBytes$descriptor() {
        return CFUUIDCreateFromUUIDBytes.DESC;
    }

    public static MethodHandle CFUUIDCreateFromUUIDBytes$handle() {
        return CFUUIDCreateFromUUIDBytes.HANDLE;
    }

    public static MemorySegment CFUUIDCreateFromUUIDBytes(MemorySegment alloc, MemorySegment bytes) {
        MethodHandle mh$ = CFUUIDCreateFromUUIDBytes.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                CoreFoundation.traceDowncall("CFUUIDCreateFromUUIDBytes", alloc, bytes);
            }
            return mh$.invokeExact(alloc, bytes);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor CFMessagePortCreateLocal$descriptor() {
        return CFMessagePortCreateLocal.DESC;
    }

    public static MethodHandle CFMessagePortCreateLocal$handle() {
        return CFMessagePortCreateLocal.HANDLE;
    }

    public static MemorySegment CFMessagePortCreateLocal(MemorySegment allocator, MemorySegment name, MemorySegment callout2, MemorySegment context, MemorySegment shouldFreeInfo) {
        MethodHandle mh$ = CFMessagePortCreateLocal.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                CoreFoundation.traceDowncall("CFMessagePortCreateLocal", allocator, name, callout2, context, shouldFreeInfo);
            }
            return mh$.invokeExact(allocator, name, callout2, context, shouldFreeInfo);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor CFMessagePortCreateRemote$descriptor() {
        return CFMessagePortCreateRemote.DESC;
    }

    public static MethodHandle CFMessagePortCreateRemote$handle() {
        return CFMessagePortCreateRemote.HANDLE;
    }

    public static MemorySegment CFMessagePortCreateRemote(MemorySegment allocator, MemorySegment name) {
        MethodHandle mh$ = CFMessagePortCreateRemote.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                CoreFoundation.traceDowncall("CFMessagePortCreateRemote", allocator, name);
            }
            return mh$.invokeExact(allocator, name);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor CFMessagePortSendRequest$descriptor() {
        return CFMessagePortSendRequest.DESC;
    }

    public static MethodHandle CFMessagePortSendRequest$handle() {
        return CFMessagePortSendRequest.HANDLE;
    }

    public static int CFMessagePortSendRequest(MemorySegment remote, int msgid, MemorySegment data, double sendTimeout, double rcvTimeout, MemorySegment replyMode, MemorySegment returnData) {
        MethodHandle mh$ = CFMessagePortSendRequest.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                CoreFoundation.traceDowncall("CFMessagePortSendRequest", remote, msgid, data, sendTimeout, rcvTimeout, replyMode, returnData);
            }
            return mh$.invokeExact(remote, msgid, data, sendTimeout, rcvTimeout, replyMode, returnData);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor CFMessagePortCreateRunLoopSource$descriptor() {
        return CFMessagePortCreateRunLoopSource.DESC;
    }

    public static MethodHandle CFMessagePortCreateRunLoopSource$handle() {
        return CFMessagePortCreateRunLoopSource.HANDLE;
    }

    public static MemorySegment CFMessagePortCreateRunLoopSource(MemorySegment allocator, MemorySegment local, long order) {
        MethodHandle mh$ = CFMessagePortCreateRunLoopSource.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                CoreFoundation.traceDowncall("CFMessagePortCreateRunLoopSource", allocator, local, order);
            }
            return mh$.invokeExact(allocator, local, order);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    private static class CFGetTypeID {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_LONG, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(CoreFoundation.findOrThrow("CFGetTypeID"), DESC, new Linker.Option[0]);

        private CFGetTypeID() {
        }
    }

    private static class CFRelease {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(CoreFoundation.findOrThrow("CFRelease"), DESC, new Linker.Option[0]);

        private CFRelease() {
        }
    }

    private static class CFDataCreate {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_POINTER, C_LONG);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(CoreFoundation.findOrThrow("CFDataCreate"), DESC, new Linker.Option[0]);

        private CFDataCreate() {
        }
    }

    private static class CFDataGetBytePtr {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(CoreFoundation.findOrThrow("CFDataGetBytePtr"), DESC, new Linker.Option[0]);

        private CFDataGetBytePtr() {
        }
    }

    private static class CFStringGetTypeID {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_LONG, new MemoryLayout[0]);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(CoreFoundation.findOrThrow("CFStringGetTypeID"), DESC, new Linker.Option[0]);

        private CFStringGetTypeID() {
        }
    }

    private static class CFStringCreateWithCharacters {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_POINTER, C_LONG);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(CoreFoundation.findOrThrow("CFStringCreateWithCharacters"), DESC, new Linker.Option[0]);

        private CFStringCreateWithCharacters() {
        }
    }

    private static class CFStringGetLength {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_LONG, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(CoreFoundation.findOrThrow("CFStringGetLength"), DESC, new Linker.Option[0]);

        private CFStringGetLength() {
        }
    }

    private static class CFStringGetCharacters {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, CFRange.layout(), C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(CoreFoundation.findOrThrow("CFStringGetCharacters"), DESC, new Linker.Option[0]);

        private CFStringGetCharacters() {
        }
    }

    private static class CFNumberGetTypeID {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_LONG, new MemoryLayout[0]);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(CoreFoundation.findOrThrow("CFNumberGetTypeID"), DESC, new Linker.Option[0]);

        private CFNumberGetTypeID() {
        }
    }

    private static class CFNumberGetValue {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_CHAR, C_POINTER, C_LONG, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(CoreFoundation.findOrThrow("CFNumberGetValue"), DESC, new Linker.Option[0]);

        private CFNumberGetValue() {
        }
    }

    private static class CFRunLoopGetCurrent {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, new MemoryLayout[0]);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(CoreFoundation.findOrThrow("CFRunLoopGetCurrent"), DESC, new Linker.Option[0]);

        private CFRunLoopGetCurrent() {
        }
    }

    private static class CFRunLoopRun {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(new MemoryLayout[0]);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(CoreFoundation.findOrThrow("CFRunLoopRun"), DESC, new Linker.Option[0]);

        private CFRunLoopRun() {
        }
    }

    private static class CFRunLoopAddSource {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(CoreFoundation.findOrThrow("CFRunLoopAddSource"), DESC, new Linker.Option[0]);

        private CFRunLoopAddSource() {
        }
    }

    private static class CFRunLoopRemoveSource {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(CoreFoundation.findOrThrow("CFRunLoopRemoveSource"), DESC, new Linker.Option[0]);

        private CFRunLoopRemoveSource() {
        }
    }

    private static class CFUUIDGetUUIDBytes {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(CFUUIDBytes.layout(), C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(CoreFoundation.findOrThrow("CFUUIDGetUUIDBytes"), DESC, new Linker.Option[0]);

        private CFUUIDGetUUIDBytes() {
        }
    }

    private static class CFUUIDCreateFromUUIDBytes {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, CFUUIDBytes.layout());
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(CoreFoundation.findOrThrow("CFUUIDCreateFromUUIDBytes"), DESC, new Linker.Option[0]);

        private CFUUIDCreateFromUUIDBytes() {
        }
    }

    private static class CFMessagePortCreateLocal {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_POINTER, C_POINTER, C_POINTER, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(CoreFoundation.findOrThrow("CFMessagePortCreateLocal"), DESC, new Linker.Option[0]);

        private CFMessagePortCreateLocal() {
        }
    }

    private static class CFMessagePortCreateRemote {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(CoreFoundation.findOrThrow("CFMessagePortCreateRemote"), DESC, new Linker.Option[0]);

        private CFMessagePortCreateRemote() {
        }
    }

    private static class CFMessagePortSendRequest {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_INT, C_POINTER, C_DOUBLE, C_DOUBLE, C_POINTER, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(CoreFoundation.findOrThrow("CFMessagePortSendRequest"), DESC, new Linker.Option[0]);

        private CFMessagePortSendRequest() {
        }
    }

    private static class CFMessagePortCreateRunLoopSource {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_POINTER, C_LONG);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(CoreFoundation.findOrThrow("CFMessagePortCreateRunLoopSource"), DESC, new Linker.Option[0]);

        private CFMessagePortCreateRunLoopSource() {
        }
    }
}

