/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.windows.gen.setupapi;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.GroupLayout;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.PaddingLayout;
import java.lang.foreign.SequenceLayout;
import java.lang.foreign.StructLayout;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class SetupAPI {
    static final Arena LIBRARY_ARENA = Arena.ofAuto();
    static final boolean TRACE_DOWNCALLS = Boolean.getBoolean("jextract.trace.downcalls");
    static final SymbolLookup SYMBOL_LOOKUP = SymbolLookup.libraryLookup(System.mapLibraryName("SetupAPI"), LIBRARY_ARENA).or(SymbolLookup.loaderLookup()).or(Linker.nativeLinker().defaultLookup());
    public static final ValueLayout.OfBoolean C_BOOL = ValueLayout.JAVA_BOOLEAN;
    public static final ValueLayout.OfByte C_CHAR = ValueLayout.JAVA_BYTE;
    public static final ValueLayout.OfShort C_SHORT = ValueLayout.JAVA_SHORT;
    public static final ValueLayout.OfInt C_INT = ValueLayout.JAVA_INT;
    public static final ValueLayout.OfLong C_LONG_LONG = ValueLayout.JAVA_LONG;
    public static final ValueLayout.OfFloat C_FLOAT = ValueLayout.JAVA_FLOAT;
    public static final ValueLayout.OfDouble C_DOUBLE = ValueLayout.JAVA_DOUBLE;
    public static final AddressLayout C_POINTER = ValueLayout.ADDRESS.withTargetLayout(MemoryLayout.sequenceLayout(Long.MAX_VALUE, ValueLayout.JAVA_BYTE));
    public static final ValueLayout.OfInt C_LONG = ValueLayout.JAVA_INT;
    public static final ValueLayout.OfDouble C_LONG_DOUBLE = ValueLayout.JAVA_DOUBLE;
    private static final int DEVPROP_TYPEMOD_LIST = 8192;
    private static final int DEVPROP_TYPE_UINT32 = 7;
    private static final int DEVPROP_TYPE_STRING = 18;
    private static final int DICS_FLAG_GLOBAL = 1;
    private static final int DIGCF_PRESENT = 2;
    private static final int DIGCF_DEVICEINTERFACE = 16;
    private static final int DIREG_DEV = 1;

    SetupAPI() {
    }

    static void traceDowncall(String name, Object ... args) {
        String traceArgs = Arrays.stream(args).map(Object::toString).collect(Collectors.joining(", "));
        System.out.printf("%s(%s)\n", name, traceArgs);
    }

    static MemorySegment findOrThrow(String symbol) {
        return SYMBOL_LOOKUP.find(symbol).orElseThrow(() -> new UnsatisfiedLinkError("unresolved symbol: " + symbol));
    }

    static MethodHandle upcallHandle(Class<?> fi, String name, FunctionDescriptor fdesc) {
        try {
            return MethodHandles.lookup().findVirtual(fi, name, fdesc.toMethodType());
        }
        catch (ReflectiveOperationException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static MemoryLayout align(MemoryLayout layout, long align) {
        MemoryLayout memoryLayout = layout;
        Objects.requireNonNull(memoryLayout);
        MemoryLayout memoryLayout2 = memoryLayout;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PaddingLayout.class, ValueLayout.class, GroupLayout.class, SequenceLayout.class}, (Object)memoryLayout2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                PaddingLayout p;
                yield p = (PaddingLayout)memoryLayout2;
            }
            case 1 -> {
                ValueLayout v = (ValueLayout)memoryLayout2;
                yield v.withByteAlignment(align);
            }
            case 2 -> {
                GroupLayout g = (GroupLayout)memoryLayout2;
                MemoryLayout[] alignedMembers = (MemoryLayout[])g.memberLayouts().stream().map(m -> SetupAPI.align(m, align)).toArray(MemoryLayout[]::new);
                if (g instanceof StructLayout) {
                    yield MemoryLayout.structLayout(alignedMembers);
                }
                yield MemoryLayout.unionLayout(alignedMembers);
            }
            case 3 -> {
                SequenceLayout s = (SequenceLayout)memoryLayout2;
                yield MemoryLayout.sequenceLayout(s.elementCount(), SetupAPI.align(s.elementLayout(), align));
            }
        };
    }

    public static int DEVPROP_TYPEMOD_LIST() {
        return 8192;
    }

    public static int DEVPROP_TYPE_UINT32() {
        return 7;
    }

    public static int DEVPROP_TYPE_STRING() {
        return 18;
    }

    public static int DICS_FLAG_GLOBAL() {
        return 1;
    }

    public static int DIGCF_PRESENT() {
        return 2;
    }

    public static int DIGCF_DEVICEINTERFACE() {
        return 16;
    }

    public static int DIREG_DEV() {
        return 1;
    }

    public static FunctionDescriptor SetupDiDestroyDeviceInfoList$descriptor() {
        return SetupDiDestroyDeviceInfoList.DESC;
    }

    public static MethodHandle SetupDiDestroyDeviceInfoList$handle() {
        return SetupDiDestroyDeviceInfoList.HANDLE;
    }

    public static int SetupDiDestroyDeviceInfoList(MemorySegment DeviceInfoSet2) {
        MethodHandle mh$ = SetupDiDestroyDeviceInfoList.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                SetupAPI.traceDowncall("SetupDiDestroyDeviceInfoList", DeviceInfoSet2);
            }
            return mh$.invokeExact(DeviceInfoSet2);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor SetupDiDeleteDeviceInterfaceData$descriptor() {
        return SetupDiDeleteDeviceInterfaceData.DESC;
    }

    public static MethodHandle SetupDiDeleteDeviceInterfaceData$handle() {
        return SetupDiDeleteDeviceInterfaceData.HANDLE;
    }

    public static int SetupDiDeleteDeviceInterfaceData(MemorySegment DeviceInfoSet2, MemorySegment DeviceInterfaceData) {
        MethodHandle mh$ = SetupDiDeleteDeviceInterfaceData.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                SetupAPI.traceDowncall("SetupDiDeleteDeviceInterfaceData", DeviceInfoSet2, DeviceInterfaceData);
            }
            return mh$.invokeExact(DeviceInfoSet2, DeviceInterfaceData);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    private static class SetupDiDestroyDeviceInfoList {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(SetupAPI.findOrThrow("SetupDiDestroyDeviceInfoList"), DESC, new Linker.Option[0]);

        private SetupDiDestroyDeviceInfoList() {
        }
    }

    private static class SetupDiDeleteDeviceInterfaceData {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(SetupAPI.findOrThrow("SetupDiDeleteDeviceInterfaceData"), DESC, new Linker.Option[0]);

        private SetupDiDeleteDeviceInterfaceData() {
        }
    }
}

