/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.common;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.ArrayList;
import net.codecrete.usb.UsbAlternateInterface;
import net.codecrete.usb.UsbDirection;
import net.codecrete.usb.UsbEndpoint;
import net.codecrete.usb.UsbException;
import net.codecrete.usb.UsbTransferType;
import net.codecrete.usb.common.CompositeFunction;
import net.codecrete.usb.common.Configuration;
import net.codecrete.usb.common.UsbAlternateInterfaceImpl;
import net.codecrete.usb.common.UsbEndpointImpl;
import net.codecrete.usb.common.UsbInterfaceImpl;
import net.codecrete.usb.usbstandard.ConfigurationDescriptor;
import net.codecrete.usb.usbstandard.EndpointDescriptor;
import net.codecrete.usb.usbstandard.InterfaceAssociationDescriptor;
import net.codecrete.usb.usbstandard.InterfaceDescriptor;

public class ConfigurationParser {
    private final MemorySegment descriptor;
    private Configuration configuration;

    public static Configuration parseConfigurationDescriptor(MemorySegment desc) {
        ConfigurationParser parser = new ConfigurationParser(desc);
        return parser.parse();
    }

    public ConfigurationParser(MemorySegment descriptor) {
        this.descriptor = descriptor;
    }

    public Configuration parse() {
        this.parseHeader();
        UsbAlternateInterfaceImpl lastAlternate = null;
        int offset = this.peekDescLength(0);
        while ((long)offset < this.descriptor.byteSize()) {
            int descLength = this.peekDescLength(offset);
            int descType = this.peekDescType(offset);
            if (descType == 4) {
                UsbInterfaceImpl intf = this.parseInterface(offset);
                UsbInterfaceImpl parent = this.configuration.findInterfaceByNumber(intf.getNumber());
                if (parent != null) {
                    parent.addAlternate(intf.getCurrentAlternate());
                } else {
                    this.configuration.addInterface(intf);
                }
                lastAlternate = (UsbAlternateInterfaceImpl)intf.getCurrentAlternate();
                CompositeFunction function = this.configuration.findFunction(intf.getNumber());
                if (function == null) {
                    function = new CompositeFunction(intf.getNumber(), 1, lastAlternate.getClassCode(), lastAlternate.getSubclassCode(), lastAlternate.getProtocolCode());
                    this.configuration.addFunction(function);
                }
            } else if (descType == 5) {
                UsbEndpointImpl endpoint = this.parseEndpoint(offset);
                if (lastAlternate != null) {
                    lastAlternate.addEndpoint(endpoint);
                }
            } else if (descType == 11) {
                this.parseIAD(offset);
            }
            offset += descLength;
        }
        return this.configuration;
    }

    private void parseHeader() {
        ConfigurationDescriptor desc = new ConfigurationDescriptor(this.descriptor);
        if (2 != desc.descriptorType()) {
            throw new UsbException("invalid USB configuration descriptor");
        }
        int totalLength = desc.totalLength();
        if (this.descriptor.byteSize() != (long)totalLength) {
            throw new UsbException("invalid USB configuration descriptor (invalid length)");
        }
        this.configuration = new Configuration(desc.configurationValue(), desc.attributes(), desc.maxPower());
    }

    private UsbInterfaceImpl parseInterface(int offset) {
        InterfaceDescriptor desc = new InterfaceDescriptor(this.descriptor, offset);
        UsbAlternateInterfaceImpl alternate = new UsbAlternateInterfaceImpl(desc.alternateSetting(), desc.interfaceClass(), desc.interfaceSubClass(), desc.interfaceProtocol(), new ArrayList<UsbEndpoint>());
        ArrayList<UsbAlternateInterface> alternates = new ArrayList<UsbAlternateInterface>();
        alternates.add(alternate);
        return new UsbInterfaceImpl(desc.interfaceNumber(), alternates);
    }

    private void parseIAD(int offset) {
        InterfaceAssociationDescriptor desc = new InterfaceAssociationDescriptor(this.descriptor, offset);
        CompositeFunction function = new CompositeFunction(desc.firstInterface(), desc.interfaceCount(), desc.functionClass(), desc.functionSubClass(), desc.functionProtocol());
        this.configuration.addFunction(function);
    }

    private UsbEndpointImpl parseEndpoint(int offset) {
        EndpointDescriptor desc = new EndpointDescriptor(this.descriptor, offset);
        int address = desc.endpointAddress();
        return new UsbEndpointImpl(ConfigurationParser.getEndpointNumber(address), ConfigurationParser.getEndpointDirection(address), ConfigurationParser.getEndpointType(desc.attributes()), desc.maxPacketSize());
    }

    private static UsbDirection getEndpointDirection(int address) {
        return (address & 0x80) != 0 ? UsbDirection.IN : UsbDirection.OUT;
    }

    private static int getEndpointNumber(int address) {
        return address & 0x7F;
    }

    private static UsbTransferType getEndpointType(int attributes) {
        return switch (attributes & 3) {
            case 1 -> UsbTransferType.ISOCHRONOUS;
            case 2 -> UsbTransferType.BULK;
            case 3 -> UsbTransferType.INTERRUPT;
            default -> null;
        };
    }

    private int peekDescLength(int offset) {
        return 0xFF & this.descriptor.get(ValueLayout.JAVA_BYTE, (long)offset);
    }

    private int peekDescType(int offset) {
        return 0xFF & this.descriptor.get(ValueLayout.JAVA_BYTE, (long)offset + 1L);
    }
}

