/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.linux;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.file.Files;
import java.nio.file.Path;
import net.codecrete.usb.UsbAlternateInterface;
import net.codecrete.usb.UsbControlTransfer;
import net.codecrete.usb.UsbDirection;
import net.codecrete.usb.UsbException;
import net.codecrete.usb.UsbInterface;
import net.codecrete.usb.UsbTransferType;
import net.codecrete.usb.common.Transfer;
import net.codecrete.usb.common.UsbDeviceImpl;
import net.codecrete.usb.common.UsbInterfaceImpl;
import net.codecrete.usb.linux.IO;
import net.codecrete.usb.linux.Linux;
import net.codecrete.usb.linux.LinuxAsyncTask;
import net.codecrete.usb.linux.LinuxEndpointInputStream;
import net.codecrete.usb.linux.LinuxEndpointOutputStream;
import net.codecrete.usb.linux.LinuxTransfer;
import net.codecrete.usb.linux.LinuxUsbException;
import net.codecrete.usb.linux.gen.fcntl.fcntl;
import net.codecrete.usb.linux.gen.unistd.unistd;
import net.codecrete.usb.linux.gen.usbdevice_fs.usbdevfs_disconnect_claim;
import net.codecrete.usb.linux.gen.usbdevice_fs.usbdevfs_ioctl;
import net.codecrete.usb.linux.gen.usbdevice_fs.usbdevfs_setinterface;
import net.codecrete.usb.linux.gen.usbdevice_fs.usbdevice_fs;
import net.codecrete.usb.usbstandard.DeviceDescriptor;
import net.codecrete.usb.usbstandard.SetupPacket;
import org.jetbrains.annotations.NotNull;

public class LinuxUsbDevice
extends UsbDeviceImpl {
    private static final MemorySegment DRIVER_NAME_USBFS = Arena.global().allocateFrom("usbfs");
    private int fd = -1;
    private final LinuxAsyncTask asyncTask = LinuxAsyncTask.INSTANCE;
    private boolean detachDrivers = false;

    LinuxUsbDevice(Object id, int vendorId, int productId) {
        super(id, vendorId, productId);
        this.loadDescription((String)id);
    }

    private void loadDescription(String path) {
        byte[] descriptors;
        try {
            descriptors = Files.readAllBytes(Path.of(path, new String[0]));
        }
        catch (IOException e) {
            throw new UsbException("reading configuration descriptor failed", e);
        }
        MemorySegment descriptorsSegment = MemorySegment.ofArray(descriptors);
        this.setFromDeviceDescriptor(descriptorsSegment.asSlice(0L, DeviceDescriptor.LAYOUT));
        this.setConfigurationDescriptor(descriptorsSegment.asSlice(DeviceDescriptor.LAYOUT.byteSize()));
    }

    @Override
    public synchronized void detachStandardDrivers() {
        this.checkIsClosed("detachStandardDrivers() must not be called while the device is open");
        this.detachDrivers = true;
    }

    @Override
    public synchronized void attachStandardDrivers() {
        this.checkIsClosed("attachStandardDrivers() must not be called while the device is open");
        this.detachDrivers = false;
    }

    @Override
    public boolean isOpened() {
        return this.fd != -1;
    }

    @Override
    public synchronized void open() {
        this.checkIsClosed("device is already open");
        try (Arena arena = Arena.ofConfined();){
            MemorySegment pathUtf8 = arena.allocateFrom(this.uniqueDeviceId.toString());
            MemorySegment errorState = Linux.allocateErrorState(arena);
            this.fd = IO.open(pathUtf8, fcntl.O_RDWR() | fcntl.O_CLOEXEC(), errorState);
            if (this.fd == -1) {
                LinuxUsbException.throwLastError(errorState, "opening USB device failed", new Object[0]);
            }
            this.asyncTask.addForAsyncIOCompletion(this);
        }
    }

    @Override
    public synchronized void close() {
        if (!this.isOpened()) {
            return;
        }
        this.asyncTask.removeFromAsyncIOCompletion(this);
        for (UsbInterface intf : this.interfaceList) {
            ((UsbInterfaceImpl)intf).setClaimed(false);
        }
        unistd.close(this.fd);
        this.fd = -1;
    }

    int fileDescriptor() {
        return this.fd;
    }

    @Override
    public synchronized void claimInterface(int interfaceNumber) {
        this.checkIsOpen();
        this.getInterfaceWithCheck(interfaceNumber, false);
        try (Arena arena = Arena.ofConfined();){
            int ret;
            MemorySegment errorState = Linux.allocateErrorState(arena);
            if (this.detachDrivers) {
                MemorySegment disconnectClaim = usbdevfs_disconnect_claim.allocate(arena);
                usbdevfs_disconnect_claim.interface_(disconnectClaim, interfaceNumber);
                usbdevfs_disconnect_claim.flags(disconnectClaim, usbdevice_fs.USBDEVFS_DISCONNECT_CLAIM_EXCEPT_DRIVER());
                usbdevfs_disconnect_claim.driver(disconnectClaim).copyFrom(DRIVER_NAME_USBFS);
                ret = IO.ioctl(this.fd, 2164806939L, disconnectClaim, errorState);
            } else {
                MemorySegment intfNumSegment = arena.allocate(ValueLayout.JAVA_INT);
                intfNumSegment.setAtIndex(ValueLayout.JAVA_INT, 0L, interfaceNumber);
                ret = IO.ioctl(this.fd, 2147767567L, intfNumSegment, errorState);
            }
            if (ret != 0) {
                LinuxUsbException.throwLastError(errorState, "claiming USB interface failed", new Object[0]);
            }
            this.setClaimed(interfaceNumber, true);
        }
    }

    @Override
    public synchronized void selectAlternateSetting(int interfaceNumber, int alternateNumber) {
        this.checkIsOpen();
        UsbInterfaceImpl intf = this.getInterfaceWithCheck(interfaceNumber, true);
        UsbAlternateInterface altSetting = intf.getAlternate(alternateNumber);
        try (Arena arena = Arena.ofConfined();){
            MemorySegment setIntfSegment = usbdevfs_setinterface.allocate(arena);
            usbdevfs_setinterface.interface_(setIntfSegment, interfaceNumber);
            usbdevfs_setinterface.altsetting(setIntfSegment, alternateNumber);
            MemorySegment errorState = Linux.allocateErrorState(arena);
            int ret = IO.ioctl(this.fd, 2148029700L, setIntfSegment, errorState);
            if (ret != 0) {
                LinuxUsbException.throwLastError(errorState, "setting alternate interface failed", new Object[0]);
            }
        }
        intf.setAlternate(altSetting);
    }

    @Override
    public synchronized void releaseInterface(int interfaceNumber) {
        this.checkIsOpen();
        this.getInterfaceWithCheck(interfaceNumber, true);
        try (Arena arena = Arena.ofConfined();){
            MemorySegment intfNumSegment = arena.allocate(ValueLayout.JAVA_INT);
            intfNumSegment.setAtIndex(ValueLayout.JAVA_INT, 0L, interfaceNumber);
            MemorySegment errorState = Linux.allocateErrorState(arena);
            int ret = IO.ioctl(this.fd, 2147767568L, intfNumSegment, errorState);
            if (ret != 0) {
                LinuxUsbException.throwLastError(errorState, "releasing USB interface failed", new Object[0]);
            }
            this.setClaimed(interfaceNumber, false);
            if (this.detachDrivers) {
                MemorySegment request = usbdevfs_ioctl.allocate(arena);
                usbdevfs_ioctl.ifno(request, interfaceNumber);
                usbdevfs_ioctl.ioctl_code(request, 21783);
                usbdevfs_ioctl.data(request, MemorySegment.NULL);
                IO.ioctl(this.fd, 3222295826L, request, errorState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void controlTransferOut(@NotNull UsbControlTransfer setup, byte[] data) {
        try (Arena arena = Arena.ofConfined();){
            int dataLength = data != null ? data.length : 0;
            LinuxTransfer transfer = this.createSyncCtrlTransfer(arena, UsbDirection.OUT, setup, dataLength);
            if (dataLength != 0) {
                transfer.data().asSlice(8L).copyFrom(MemorySegment.ofArray(data));
            }
            LinuxTransfer linuxTransfer = transfer;
            synchronized (linuxTransfer) {
                this.submitTransfer(UsbDirection.OUT, 0, transfer);
                this.waitForTransfer(transfer, 0, UsbDirection.OUT, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte @NotNull [] controlTransferIn(@NotNull UsbControlTransfer setup, int length) {
        try (Arena arena = Arena.ofConfined();){
            LinuxTransfer transfer = this.createSyncCtrlTransfer(arena, UsbDirection.IN, setup, length);
            Object object = transfer;
            synchronized (object) {
                this.submitTransfer(UsbDirection.IN, 0, transfer);
                this.waitForTransfer(transfer, 0, UsbDirection.IN, 0);
            }
            object = transfer.data().asSlice(8L, transfer.resultSize()).toArray(ValueLayout.JAVA_BYTE);
            return object;
        }
    }

    private LinuxTransfer createSyncCtrlTransfer(Arena arena, UsbDirection direction, UsbControlTransfer setup, int dataLength) {
        int bmRequest = (direction == UsbDirection.IN ? 128 : 0) | setup.requestType().ordinal() << 5 | setup.recipient().ordinal();
        MemorySegment buffer = arena.allocate(8L + (long)dataLength, 8L);
        SetupPacket setupPacket = new SetupPacket(buffer);
        setupPacket.setRequestType(bmRequest);
        setupPacket.setRequest(setup.request());
        setupPacket.setValue(setup.value());
        setupPacket.setIndex(setup.index());
        setupPacket.setLength(dataLength);
        LinuxTransfer transfer = new LinuxTransfer();
        transfer.setData(buffer);
        transfer.setDataSize((int)buffer.byteSize());
        transfer.setResultSize(-1);
        transfer.setCompletion(x$0 -> UsbDeviceImpl.onSyncTransferCompleted(x$0));
        return transfer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferOut(int endpointNumber, byte @NotNull [] data, int offset, int length, int timeout) {
        try (Arena arena = Arena.ofConfined();){
            LinuxTransfer transfer;
            MemorySegment buffer = arena.allocate(length);
            buffer.copyFrom(MemorySegment.ofArray(data).asSlice((long)offset, length));
            LinuxTransfer linuxTransfer = transfer = this.createSyncTransfer(buffer);
            synchronized (linuxTransfer) {
                this.submitTransfer(UsbDirection.OUT, endpointNumber, transfer);
                this.waitForTransfer(transfer, timeout, UsbDirection.OUT, endpointNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte @NotNull [] transferIn(int endpointNumber, int timeout) {
        UsbDeviceImpl.EndpointInfo endpoint = this.getEndpoint(UsbDirection.IN, endpointNumber, UsbTransferType.BULK, UsbTransferType.INTERRUPT);
        try (Arena arena = Arena.ofConfined();){
            MemorySegment buffer = arena.allocate(endpoint.packetSize());
            LinuxTransfer transfer = this.createSyncTransfer(buffer);
            Object object = transfer;
            synchronized (object) {
                this.submitTransfer(UsbDirection.IN, endpointNumber, transfer);
                this.waitForTransfer(transfer, timeout, UsbDirection.IN, endpointNumber);
            }
            object = buffer.asSlice(0L, transfer.resultSize()).toArray(ValueLayout.JAVA_BYTE);
            return object;
        }
    }

    private LinuxTransfer createSyncTransfer(MemorySegment data) {
        LinuxTransfer transfer = new LinuxTransfer();
        transfer.setData(data);
        transfer.setDataSize((int)data.byteSize());
        transfer.setResultSize(-1);
        transfer.setCompletion(x$0 -> UsbDeviceImpl.onSyncTransferCompleted(x$0));
        return transfer;
    }

    synchronized void submitTransfer(UsbDirection direction, int endpointNumber, LinuxTransfer transfer) {
        if (endpointNumber != 0) {
            UsbDeviceImpl.EndpointInfo endpoint = this.getEndpoint(direction, endpointNumber, UsbTransferType.BULK, UsbTransferType.INTERRUPT);
            this.asyncTask.submitTransfer(this, endpoint.endpointAddress(), endpoint.transferType(), transfer);
        } else {
            this.asyncTask.submitTransfer(this, 0, UsbTransferType.CONTROL, transfer);
        }
    }

    @Override
    protected Transfer createTransfer() {
        return new LinuxTransfer();
    }

    @Override
    protected void throwOSException(int errorCode, String message, Object ... args) {
        LinuxUsbException.throwException(errorCode, message, args);
    }

    @Override
    public void clearHalt(UsbDirection direction, int endpointNumber) {
        UsbDeviceImpl.EndpointInfo endpoint = this.getEndpoint(direction, endpointNumber, UsbTransferType.BULK, UsbTransferType.INTERRUPT);
        try (Arena arena = Arena.ofConfined();){
            MemorySegment endpointAddrSegment = arena.allocate(ValueLayout.JAVA_INT);
            endpointAddrSegment.setAtIndex(ValueLayout.JAVA_INT, 0L, endpoint.endpointAddress() & 0xFF);
            MemorySegment errorState = Linux.allocateErrorState(arena);
            int res = IO.ioctl(this.fd, 2147767573L, endpointAddrSegment, errorState);
            if (res < 0) {
                LinuxUsbException.throwLastError(errorState, "clearing halt failed", new Object[0]);
            }
        }
    }

    @Override
    public synchronized void abortTransfers(UsbDirection direction, int endpointNumber) {
        UsbDeviceImpl.EndpointInfo endpoint = this.getEndpoint(direction, endpointNumber, UsbTransferType.BULK, UsbTransferType.INTERRUPT);
        this.asyncTask.abortTransfers(this, endpoint.endpointAddress());
    }

    @Override
    @NotNull
    public synchronized InputStream openInputStream(int endpointNumber, int bufferSize) {
        this.getEndpoint(UsbDirection.IN, endpointNumber, UsbTransferType.BULK, null);
        return new LinuxEndpointInputStream(this, endpointNumber, bufferSize);
    }

    @Override
    @NotNull
    public synchronized OutputStream openOutputStream(int endpointNumber, int bufferSize) {
        this.getEndpoint(UsbDirection.OUT, endpointNumber, UsbTransferType.BULK, null);
        return new LinuxEndpointOutputStream(this, endpointNumber, bufferSize);
    }
}

