/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.macos;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import net.codecrete.usb.UsbException;
import net.codecrete.usb.macos.CoreFoundationHelper;
import net.codecrete.usb.macos.MacosTransfer;
import net.codecrete.usb.macos.gen.corefoundation.CoreFoundation;
import net.codecrete.usb.macos.gen.iokit.IOKit;

class MacosAsyncTask {
    static final MacosAsyncTask INSTANCE = new MacosAsyncTask();
    private final ReentrantLock asyncIoLock = new ReentrantLock();
    private final Condition asyncIoReady = this.asyncIoLock.newCondition();
    private TaskState state = TaskState.NOT_STARTED;
    private MemorySegment asyncIoRunLoop;
    private MemorySegment completionUpcallStub;
    private MemorySegment messagePort;
    private long lastTransferId;
    private final Map<Long, MacosTransfer> transfersById = new HashMap<Long, MacosTransfer>();

    MacosAsyncTask() {
    }

    void addEventSource(MemorySegment source) {
        try {
            this.asyncIoLock.lock();
            if (this.state != TaskState.RUNNING) {
                if (this.state == TaskState.NOT_STARTED) {
                    this.startAsyncIOThread();
                }
                this.waitForRunLoopReady();
            }
            CoreFoundation.CFRunLoopAddSource(this.asyncIoRunLoop, source, IOKit.kCFRunLoopDefaultMode());
        }
        finally {
            this.asyncIoLock.unlock();
        }
    }

    private void waitForRunLoopReady() {
        while (this.state != TaskState.RUNNING) {
            this.asyncIoReady.awaitUninterruptibly();
        }
    }

    void removeEventSource(MemorySegment source) {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment eventSourceRef = arena.allocate(ValueLayout.JAVA_LONG, 1L);
            eventSourceRef.set(ValueLayout.JAVA_LONG, 0L, source.address());
            MemorySegment dataRef = CoreFoundation.CFDataCreate(MemorySegment.NULL, eventSourceRef, eventSourceRef.byteSize());
            CoreFoundation.CFMessagePortSendRequest(this.messagePort, 0, dataRef, 0.0, 0.0, MemorySegment.NULL, MemorySegment.NULL);
            CoreFoundation.CFRelease(dataRef);
        }
    }

    private void startAsyncIOThread() {
        MemorySegment messagePortSource;
        try {
            this.state = TaskState.STARTING;
            FunctionDescriptor completionHandlerFuncDesc = FunctionDescriptor.ofVoid(ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS);
            MethodHandle asyncIOCompletedMH = MethodHandles.lookup().findVirtual(MacosAsyncTask.class, "asyncIOCompleted", MethodType.methodType(Void.TYPE, MemorySegment.class, Integer.TYPE, MemorySegment.class));
            MethodHandle methodHandle = asyncIOCompletedMH.bindTo(this);
            this.completionUpcallStub = Linker.nativeLinker().upcallStub(methodHandle, completionHandlerFuncDesc, Arena.global(), new Linker.Option[0]);
            FunctionDescriptor messagePortCallbackFuncDec = FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS);
            MethodHandle messagePortCallbackMH = MethodHandles.lookup().findVirtual(MacosAsyncTask.class, "messagePortCallback", MethodType.methodType(MemorySegment.class, MemorySegment.class, Integer.TYPE, MemorySegment.class, MemorySegment.class));
            MethodHandle messagePortCallbackHandle = messagePortCallbackMH.bindTo(this);
            MemorySegment messagePortCallbackStub = Linker.nativeLinker().upcallStub(messagePortCallbackHandle, messagePortCallbackFuncDec, Arena.global(), new Linker.Option[0]);
            long pid = ProcessHandle.current().pid();
            MemorySegment portName = CoreFoundationHelper.createCFStringRef("net.codecrete.usb.macos.eventsource." + pid, Arena.global());
            MemorySegment localPort = CoreFoundation.CFMessagePortCreateLocal(MemorySegment.NULL, portName, messagePortCallbackStub, MemorySegment.NULL, MemorySegment.NULL);
            messagePortSource = CoreFoundation.CFMessagePortCreateRunLoopSource(MemorySegment.NULL, localPort, 0L);
            this.messagePort = CoreFoundation.CFMessagePortCreateRemote(MemorySegment.NULL, portName);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new UsbException("internal error (creating method handle)", e);
        }
        Thread thread = new Thread(() -> this.asyncIOCompletionTask(messagePortSource), "USB async IO");
        thread.setDaemon(true);
        thread.start();
    }

    private void asyncIOCompletionTask(MemorySegment firstSource) {
        try {
            this.asyncIoLock.lock();
            this.asyncIoRunLoop = CoreFoundation.CFRunLoopGetCurrent();
            CoreFoundation.CFRunLoopAddSource(this.asyncIoRunLoop, firstSource, IOKit.kCFRunLoopDefaultMode());
            this.state = TaskState.RUNNING;
            this.asyncIoReady.signalAll();
        }
        finally {
            this.asyncIoLock.unlock();
        }
        CoreFoundation.CFRunLoopRun();
    }

    synchronized void prepareForSubmission(MacosTransfer transfer) {
        ++this.lastTransferId;
        transfer.setId(this.lastTransferId);
        transfer.setResultSize(-1);
        this.transfersById.put(this.lastTransferId, transfer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncIOCompleted(MemorySegment refcon, int result, MemorySegment arg0) {
        MacosTransfer transfer;
        MacosAsyncTask macosAsyncTask = this;
        synchronized (macosAsyncTask) {
            transfer = this.transfersById.remove(refcon.address());
        }
        transfer.setResultCode(result);
        transfer.setResultSize((int)arg0.address());
        transfer.completion().completed(transfer);
    }

    private MemorySegment messagePortCallback(MemorySegment local, int msgid, MemorySegment data, MemorySegment info) {
        MemorySegment runloopSourceRefPtr = CoreFoundation.CFDataGetBytePtr(data);
        MemorySegment runloopSourceRef = MemorySegment.ofAddress(runloopSourceRefPtr.get(ValueLayout.JAVA_LONG_UNALIGNED, 0L));
        CoreFoundation.CFRunLoopRemoveSource(this.asyncIoRunLoop, runloopSourceRef, IOKit.kCFRunLoopDefaultMode());
        return MemorySegment.NULL;
    }

    MemorySegment nativeCompletionCallback() {
        return this.completionUpcallStub;
    }

    static enum TaskState {
        NOT_STARTED,
        STARTING,
        RUNNING;

    }
}

