/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.usbstandard;

import java.lang.foreign.GroupLayout;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;

public class EndpointDescriptor {
    private final MemorySegment descriptor;
    public static final GroupLayout LAYOUT = MemoryLayout.structLayout(ValueLayout.JAVA_BYTE.withName("bLength"), ValueLayout.JAVA_BYTE.withName("bDescriptorType"), ValueLayout.JAVA_BYTE.withName("bEndpointAddress"), ValueLayout.JAVA_BYTE.withName("bmAttributes"), ValueLayout.JAVA_SHORT_UNALIGNED.withName("wMaxPacketSize"), ValueLayout.JAVA_BYTE.withName("bInterval"));
    private static final long bEndpointAddress$OFFSET = 2L;
    private static final long bmAttributes$OFFSET = 3L;
    private static final long wMaxPacketSize$OFFSET = 4L;
    private static final long bInterval$OFFSET = 6L;

    public EndpointDescriptor(MemorySegment descriptor) {
        this.descriptor = descriptor;
    }

    public EndpointDescriptor(MemorySegment segment, long offset) {
        this(segment.asSlice(offset, LAYOUT.byteSize()));
    }

    public int endpointAddress() {
        return 0xFF & this.descriptor.get(ValueLayout.JAVA_BYTE, 2L);
    }

    public int attributes() {
        return 0xFF & this.descriptor.get(ValueLayout.JAVA_BYTE, 3L);
    }

    public int maxPacketSize() {
        return 0xFFFF & this.descriptor.get(ValueLayout.JAVA_SHORT_UNALIGNED, 4L);
    }

    public int interval() {
        return 0xFF & this.descriptor.get(ValueLayout.JAVA_BYTE, 6L);
    }

    static {
        assert (LAYOUT.byteSize() == 7L);
    }
}

