/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.usbstandard;

import java.lang.foreign.Arena;
import java.lang.foreign.GroupLayout;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;

public class SetupPacket {
    private final MemorySegment descriptor;
    public static final GroupLayout LAYOUT = MemoryLayout.structLayout(ValueLayout.JAVA_BYTE.withName("bmRequestType"), ValueLayout.JAVA_BYTE.withName("bRequest"), ValueLayout.JAVA_SHORT.withName("wValue"), ValueLayout.JAVA_SHORT.withName("wIndex"), ValueLayout.JAVA_SHORT.withName("wLength"));
    private static final long bmRequestType$OFFSET = 0L;
    private static final long bRequest$OFFSET = 1L;
    private static final long wValue$OFFSET = 2L;
    private static final long wIndex$OFFSET = 4L;
    private static final long wLength$OFFSET = 6L;

    public SetupPacket(MemorySegment descriptor) {
        this.descriptor = descriptor;
    }

    public SetupPacket(Arena arena) {
        this.descriptor = arena.allocate(LAYOUT);
    }

    public MemorySegment segment() {
        return this.descriptor;
    }

    public int requestType() {
        return 0xFF & this.descriptor.get(ValueLayout.JAVA_BYTE, 0L);
    }

    public void setRequestType(int requestType) {
        this.descriptor.set(ValueLayout.JAVA_BYTE, 0L, (byte)requestType);
    }

    public int request() {
        return 0xFF & this.descriptor.get(ValueLayout.JAVA_BYTE, 1L);
    }

    public void setRequest(int request) {
        this.descriptor.set(ValueLayout.JAVA_BYTE, 1L, (byte)request);
    }

    public int value() {
        return 0xFFFF & this.descriptor.get(ValueLayout.JAVA_SHORT, 2L);
    }

    public void setValue(int value) {
        this.descriptor.set(ValueLayout.JAVA_SHORT, 2L, (short)value);
    }

    public int index() {
        return 0xFFFF & this.descriptor.get(ValueLayout.JAVA_SHORT, 4L);
    }

    public void setIndex(int index) {
        this.descriptor.set(ValueLayout.JAVA_SHORT, 4L, (short)index);
    }

    public int length() {
        return 0xFFFF & this.descriptor.get(ValueLayout.JAVA_SHORT, 6L);
    }

    public void setLength(int length) {
        this.descriptor.set(ValueLayout.JAVA_SHORT, 6L, (short)length);
    }

    static {
        assert (LAYOUT.byteSize() == 8L);
    }
}

