/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui.editor;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.Comparator;
import javax.swing.CellRendererPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import net.coderazzi.filters.IParser;
import net.coderazzi.filters.artifacts.RowFilter;
import net.coderazzi.filters.gui.CustomChoice;
import net.coderazzi.filters.gui.Look;
import net.coderazzi.filters.gui.editor.FilterEditor;
import net.coderazzi.filters.gui.editor.PopupComponent;

public class EditorComponent
extends JTextField {
    private static final long serialVersionUID = -2196080442586435546L;
    private Controller controller;
    private boolean focus;
    FilterEditor filterEditor;
    PopupComponent popupComponent;

    public EditorComponent(FilterEditor editor, PopupComponent popupComponent) {
        super(15);
        this.filterEditor = editor;
        this.popupComponent = popupComponent;
        this.controller = new EditableTextController();
    }

    public void setUI(TextUI ui) {
        super.setUI(ui);
        this.setBorder(null);
    }

    protected void paintComponent(Graphics g) {
        this.controller.paintComponent(g);
    }

    public void updateLook() {
        this.controller.updateLook();
    }

    public RowFilter getFilter() {
        return this.controller.getFilter();
    }

    public Object getContent() {
        return this.controller.getContent();
    }

    public void setContent(Object content, boolean escapeIt) {
        this.controller.setContent(content, escapeIt);
    }

    public void updateParser() {
        if (this.controller instanceof TextController) {
            ((TextController)this.controller).setParser(this.filterEditor.getParser());
        }
    }

    public boolean isEditableContent() {
        return this.controller instanceof EditableTextController;
    }

    public void setTextMode(boolean editable) {
        if (this.controller != null) {
            if (editable && this.controller instanceof EditableTextController) {
                return;
            }
            if (!editable && this.controller instanceof NonEditableTextController) {
                return;
            }
            this.controller.detach();
        }
        this.controller = editable ? new EditableTextController() : new NonEditableTextController();
        this.updateParser();
    }

    public void setRenderMode() {
        if (this.controller != null) {
            if (this.controller instanceof RenderedController) {
                return;
            }
            this.controller.detach();
        }
        this.controller = new RenderedController();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.controller != null) {
            this.setCaretPosition(0);
            this.moveCaretPosition(0);
            this.updateLook();
            this.setFocusable(enabled);
        }
    }

    public boolean isValidContent() {
        return this.controller.isValidContent();
    }

    public RowFilter checkFilterUpdate(boolean forceUpdate) {
        return this.controller.checkFilterUpdate(forceUpdate);
    }

    public void focusMoved(boolean gained) {
        this.focus = gained;
        this.controller.focusMoved(gained);
    }

    boolean isFocused() {
        return this.focus;
    }

    Look prepareComponentLook(CustomChoice cc) {
        return this.popupComponent.getFilterRenderer().prepareComponentLook(this, this.isFocused(), cc);
    }

    void superPaintComponent(Graphics g) {
        super.paintComponent(g);
    }

    private class NonEditableTextController
    extends TextController {
        boolean onSetText;

        NonEditableTextController() {
            ((AbstractDocument)EditorComponent.this.getDocument()).setDocumentFilter(new ControllerDocumentFilter());
        }

        public boolean requiresTextEscaping() {
            return true;
        }

        public void detach() {
            super.detach();
            ((AbstractDocument)EditorComponent.this.getDocument()).setDocumentFilter(null);
        }

        public void setContent(Object content, boolean escapeIt) {
            String text = content instanceof CustomChoice ? ((CustomChoice)content).toString() : (content instanceof String ? (String)content : null);
            this.onSetText = true;
            EditorComponent.this.setText(text);
            this.onSetText = false;
            this.activateCustomDecoration();
        }

        class ControllerDocumentFilter
        extends DocumentFilter {
            ControllerDocumentFilter() {
            }

            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) {
            }

            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                String buffer = EditorComponent.this.getText();
                String newContentBegin = buffer.substring(0, offset) + text;
                String newContent = newContentBegin + buffer.substring(offset + length);
                String proposal = NonEditableTextController.this.getProposalOnEdition(newContent, true);
                if (proposal == null) {
                    proposal = NonEditableTextController.this.getProposalOnEdition(newContentBegin, true);
                    if (proposal != null) {
                        newContent = newContentBegin;
                    } else {
                        proposal = NonEditableTextController.this.getProposalOnEdition(newContent, false);
                        if (proposal != null && (proposal.length() < newContentBegin.length() || 0 != EditorComponent.this.popupComponent.getStringComparator().compare(newContentBegin, proposal.substring(0, newContentBegin.length())))) {
                            proposal = null;
                        }
                        if (proposal == null) {
                            return;
                        }
                        newContent = proposal;
                    }
                }
                int caret = NonEditableTextController.this.onSetText ? 0 : 1 + Math.min(EditorComponent.this.getCaret().getDot(), EditorComponent.this.getCaret().getMark());
                super.replace(fb, 0, buffer.length(), proposal, attrs);
                EditorComponent.this.setCaretPosition(proposal.length());
                EditorComponent.this.moveCaretPosition(caret);
                NonEditableTextController.this.deactivateCustomDecoration();
            }

            public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                int caret = EditorComponent.this.getCaret().getDot();
                int mark = EditorComponent.this.getCaret().getMark();
                String buffer = EditorComponent.this.getText();
                String newContent = buffer.substring(0, offset) + buffer.substring(offset + length);
                Comparator<String> comparator = EditorComponent.this.popupComponent.getStringComparator();
                String proposal = NonEditableTextController.this.getProposalOnEdition(newContent, true);
                if (proposal == null || comparator.compare(newContent, proposal) != 0) {
                    proposal = NonEditableTextController.this.getProposalOnEdition(newContent, false);
                    if (proposal == null) {
                        return;
                    }
                    if (PopupComponent.Match.getMatchingLength(proposal, newContent, comparator) <= PopupComponent.Match.getMatchingLength(buffer, newContent, comparator)) {
                        proposal = buffer;
                    }
                }
                super.replace(fb, 0, buffer.length(), proposal, null);
                AWTEvent ev = EventQueue.getCurrentEvent();
                if (ev instanceof KeyEvent && ((KeyEvent)ev).getKeyCode() == 8) {
                    if (caret > mark) {
                        caret = mark;
                    } else if (buffer == proposal) {
                        --caret;
                    } else if (caret == mark) {
                        caret = offset;
                    }
                }
                EditorComponent.this.setCaretPosition(proposal.length());
                EditorComponent.this.moveCaretPosition(caret);
                NonEditableTextController.this.deactivateCustomDecoration();
            }
        }
    }

    private class EditableTextController
    extends TextController
    implements DocumentListener {
        EditableTextController() {
            EditorComponent.this.getDocument().addDocumentListener(this);
        }

        public boolean requiresTextEscaping() {
            return false;
        }

        public void detach() {
            super.detach();
            EditorComponent.this.getDocument().removeDocumentListener(this);
        }

        public void setContent(Object content, boolean escapeIt) {
            String text;
            if (content instanceof CustomChoice) {
                text = ((CustomChoice)content).toString();
            } else if (content instanceof String) {
                text = (String)content;
                if (escapeIt) {
                    text = this.textParser.escape(text);
                }
            } else {
                text = null;
            }
            EditorComponent.this.setText(text);
            this.activateCustomDecoration();
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void removeUpdate(DocumentEvent e) {
            this.deactivateCustomDecoration();
            this.setError(false);
            this.getProposalOnEdition(EditorComponent.this.getText(), false);
        }

        public void insertUpdate(DocumentEvent e) {
            this.deactivateCustomDecoration();
            this.setError(false);
            this.getProposalOnEdition(EditorComponent.this.getText(), false);
        }
    }

    private abstract class TextController
    implements Controller,
    CaretListener {
        protected IParser textParser;
        private Object content;
        private RowFilter filter;
        private boolean error;
        private boolean useCustomDecoration;

        TextController() {
            EditorComponent.this.setEditable(true);
            EditorComponent.this.setText(CustomChoice.MATCH_ALL.toString());
            EditorComponent.this.addCaretListener(this);
        }

        public void setParser(IParser textParser) {
            this.textParser = textParser;
            if (EditorComponent.this.isEnabled()) {
                this.checkFilterUpdate(true);
            }
        }

        public void paintComponent(Graphics g) {
            EditorComponent.this.superPaintComponent(g);
            if (this.useCustomDecoration && this.content instanceof CustomChoice) {
                EditorComponent.this.filterEditor.getLook().getCustomChoiceDecorator().decorateComponent((CustomChoice)this.content, EditorComponent.this.filterEditor, EditorComponent.this.isFocused(), EditorComponent.this, g);
            }
        }

        public void detach() {
            EditorComponent.this.removeCaretListener(this);
        }

        public Object getContent() {
            this.checkFilterUpdate(false);
            return this.content;
        }

        public boolean isValidContent() {
            return !this.error;
        }

        public RowFilter getFilter() {
            return this.filter;
        }

        public RowFilter checkFilterUpdate(boolean forceUpdate) {
            String text = EditorComponent.this.getText().trim();
            if (forceUpdate) {
                this.updateFilter(text);
            } else if (this.content instanceof CustomChoice) {
                if (!((CustomChoice)this.content).toString().equals(text)) {
                    this.updateFilter(text);
                }
            } else if (!text.equals(this.content)) {
                this.updateFilter(text);
            }
            return this.filter;
        }

        public void updateLook() {
            Color foreground;
            CustomChoice cc = this.useCustomDecoration && this.content instanceof CustomChoice ? (CustomChoice)this.content : null;
            Look look = EditorComponent.this.prepareComponentLook(cc);
            if (EditorComponent.this.isEnabled() && this.error && (foreground = look.getErrorForeground()) != EditorComponent.this.getForeground()) {
                EditorComponent.this.setForeground(foreground);
            }
            Color selection = look.getTextSelection();
            if (EditorComponent.this.getSelectionColor() != selection) {
                EditorComponent.this.setSelectionColor(selection);
            }
        }

        public void focusMoved(boolean gained) {
            if (!this.activateCustomDecoration()) {
                this.updateLook();
            }
        }

        public void caretUpdate(CaretEvent e) {
            if (EditorComponent.this.isEnabled()) {
                EditorComponent.this.popupComponent.setPopupFocused(false);
                this.deactivateCustomDecoration();
            }
        }

        protected void setError(boolean error) {
            this.error = error;
            if (EditorComponent.this.isEnabled()) {
                this.updateLook();
            }
        }

        protected String getProposalOnEdition(String hint, boolean perfectMatch) {
            String ret = EditorComponent.this.popupComponent.selectBestMatch(hint, perfectMatch);
            EditorComponent.this.popupComponent.setPopupFocused(false);
            return ret;
        }

        protected boolean activateCustomDecoration() {
            boolean ret = false;
            if (!this.useCustomDecoration && this.content instanceof CustomChoice) {
                this.useCustomDecoration = true;
                this.updateLook();
                EditorComponent.this.repaint();
                ret = true;
            }
            return ret;
        }

        protected void deactivateCustomDecoration() {
            if (this.useCustomDecoration) {
                this.useCustomDecoration = false;
                this.updateLook();
                EditorComponent.this.repaint();
            }
        }

        protected abstract boolean requiresTextEscaping();

        private void updateFilter(String text) {
            CustomChoice cc;
            boolean error = false;
            CustomChoice customChoice = cc = text.length() == 0 ? CustomChoice.MATCH_ALL : EditorComponent.this.popupComponent.getCustomChoice(text);
            if (cc != null) {
                this.content = cc;
                this.activateCustomDecoration();
                this.filter = cc.getFilter(EditorComponent.this.filterEditor);
            } else {
                this.deactivateCustomDecoration();
                this.content = text;
                try {
                    if (this.requiresTextEscaping()) {
                        text = this.textParser.escape(text);
                    }
                    this.filter = this.textParser.parseText(text);
                }
                catch (ParseException pex) {
                    this.filter = null;
                    error = true;
                }
            }
            this.setError(error);
        }
    }

    private class RenderedController
    extends MouseAdapter
    implements Controller {
        RowFilter filter;
        private Object content = CustomChoice.MATCH_ALL;
        Object cachedContent;
        private CellRendererPane painter = new CellRendererPane();

        RenderedController() {
            EditorComponent.this.addMouseListener(this);
            EditorComponent.this.setEditable(false);
        }

        public void paintComponent(Graphics g) {
            Component c = EditorComponent.this.popupComponent.getFilterRenderer().getCellRendererComponent(this.content, EditorComponent.this.getWidth(), EditorComponent.this.isFocused());
            this.painter.paintComponent(g, c, EditorComponent.this, 0, 0, EditorComponent.this.getWidth(), EditorComponent.this.getHeight());
        }

        public void detach() {
            EditorComponent.this.removeMouseListener(this);
        }

        public void setContent(Object content, boolean escapeIt) {
            this.content = content == null ? CustomChoice.MATCH_ALL : content;
            EditorComponent.this.repaint();
        }

        public Object getContent() {
            return this.content;
        }

        public boolean isValidContent() {
            return true;
        }

        public RowFilter getFilter() {
            return this.filter;
        }

        public RowFilter checkFilterUpdate(boolean forceUpdate) {
            Object currentContent = this.getContent();
            if (forceUpdate || currentContent != this.cachedContent) {
                this.cachedContent = currentContent;
                this.filter = this.cachedContent instanceof CustomChoice ? ((CustomChoice)this.cachedContent).getFilter(EditorComponent.this.filterEditor) : new RowFilter(){

                    public boolean include(RowFilter.Entry entry) {
                        Object val = entry.getValue(EditorComponent.this.filterEditor.getModelIndex());
                        return val == null ? RenderedController.this.cachedContent == null : val.equals(RenderedController.this.cachedContent);
                    }
                };
            }
            return this.filter;
        }

        public void updateLook() {
            EditorComponent.this.prepareComponentLook(null);
        }

        public void focusMoved(boolean gained) {
            EditorComponent.this.repaint();
        }

        public void mouseClicked(MouseEvent e) {
            if (EditorComponent.this.isEnabled()) {
                EditorComponent.this.filterEditor.triggerPopup(EditorComponent.this.filterEditor);
            }
        }
    }

    private static interface Controller {
        public void paintComponent(Graphics var1);

        public void detach();

        public void setContent(Object var1, boolean var2);

        public Object getContent();

        public boolean isValidContent();

        public RowFilter getFilter();

        public RowFilter checkFilterUpdate(boolean var1);

        public void updateLook();

        public void focusMoved(boolean var1);
    }
}

