/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.table.TableModel;
import net.coderazzi.filters.IFilter;
import net.coderazzi.filters.artifacts.RowFilter;
import net.coderazzi.filters.gui.AutoChoices;
import net.coderazzi.filters.gui.ChoicesHandler;
import net.coderazzi.filters.gui.CustomChoice;
import net.coderazzi.filters.gui.FiltersHandler;
import net.coderazzi.filters.gui.editor.FilterEditor;

class NonAdaptiveChoicesHandler
extends ChoicesHandler {
    private boolean interrupted = true;
    private Map<IFilter, FilterEditor> filtersMap = new HashMap<IFilter, FilterEditor>();
    private ChoicesHandler.RowEntry rowEntry;

    public NonAdaptiveChoicesHandler(FiltersHandler handler) {
        super(handler);
    }

    public RowFilter getRowFilter() {
        return this.handler;
    }

    public boolean setInterrupted(boolean interrupted) {
        if (this.interrupted != interrupted) {
            this.interrupted = interrupted;
            this.setEnableTableModelEvents(!interrupted);
            if (!interrupted) {
                for (FilterEditor editor : this.handler.getEditors()) {
                    this.editorUpdated(editor);
                }
                this.initialiseFiltersInfo();
            }
        }
        return !interrupted;
    }

    public void editorUpdated(FilterEditor editor) {
        if (editor.isEnabled()) {
            this.initEditorChoices(editor);
        }
    }

    public boolean filterUpdated(IFilter iFilter, boolean retInfoRequired) {
        if (retInfoRequired) {
            if (!iFilter.isEnabled()) {
                return false;
            }
            this.rowEntry.row = this.handler.getTable().getModel().getRowCount();
            if (this.rowEntry.row > 0) {
                while (this.rowEntry.row-- > 0) {
                    if (!iFilter.include(this.rowEntry)) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    public void filterOperation(boolean start) {
        this.handler.enableNotifications(!start);
        if (!start && !this.interrupted) {
            this.initialiseFiltersInfo();
        }
    }

    public void filterEnabled(IFilter filter) {
        for (FilterEditor editor : this.handler.getEditors()) {
            if (editor.getFilter() != filter) continue;
            this.initEditorChoices(editor);
            break;
        }
        if (!this.interrupted) {
            this.setEnableTableModelEvents(true);
        }
    }

    public void allFiltersDisabled() {
        this.setEnableTableModelEvents(false);
    }

    public void tableUpdated(TableModel model, int eventType, int firstRow, int lastRow, int column) {
        if (column != -1) {
            FilterEditor editor = this.handler.getEditor(column);
            if (editor != null && editor.isEnabled()) {
                editor.addChoices(this.modelExtract(editor, model, firstRow, lastRow, new HashSet()));
            }
        } else {
            for (FilterEditor editor : this.handler.getEditors()) {
                if (!editor.isEnabled() || AutoChoices.ENABLED != editor.getAutoChoices() || eventType == -1) continue;
                editor.addChoices(this.modelExtract(editor, model, firstRow, lastRow, new HashSet()));
            }
        }
    }

    private void initEditorChoices(FilterEditor editor) {
        AutoChoices autoChoices = editor.getAutoChoices();
        if (autoChoices == AutoChoices.DISABLED) {
            editor.setChoices(editor.getCustomChoices());
        } else {
            boolean asEnum;
            TableModel model = this.handler.getTable().getModel();
            Class<?> c = model.getColumnClass(editor.getModelIndex());
            boolean bl = asEnum = c.equals(Boolean.class) || c.isEnum();
            if (asEnum && autoChoices != AutoChoices.ENUMS) {
                editor.setAutoChoices(AutoChoices.ENUMS);
            } else if (!asEnum && autoChoices == AutoChoices.ENUMS) {
                editor.setAutoChoices(AutoChoices.DISABLED);
            } else if (asEnum) {
                Set<CustomChoice> choices = editor.getCustomChoices();
                if (c.equals(Boolean.class)) {
                    choices.add((CustomChoice)((Object)Boolean.valueOf(true)));
                    choices.add((CustomChoice)((Object)Boolean.valueOf(false)));
                } else {
                    for (Object each : c.getEnumConstants()) {
                        choices.add((CustomChoice)each);
                    }
                }
                editor.setChoices(choices);
            } else {
                this.setChoicesFromModel(editor, model);
            }
        }
    }

    private void setChoicesFromModel(FilterEditor editor, TableModel model) {
        editor.setChoices(this.modelExtract(editor, model, 0, model.getRowCount() - 1, editor.getCustomChoices()));
    }

    private Set modelExtract(FilterEditor editor, TableModel model, int firstRow, int lastRow, Set fill) {
        int column = editor.getModelIndex();
        while (lastRow >= firstRow) {
            fill.add(model.getValueAt(firstRow, column));
            ++firstRow;
        }
        return fill;
    }

    private void initialiseFiltersInfo() {
        this.filtersMap.clear();
        if (this.handler.getTable() != null) {
            for (FilterEditor fe : this.handler.getEditors()) {
                this.filtersMap.put(fe.getFilter(), fe);
            }
            Collection<FilterEditor> eds = this.handler.getEditors();
            this.rowEntry = new ChoicesHandler.RowEntry(this.handler.getTable().getModel(), eds.toArray(new FilterEditor[eds.size()]));
        }
    }
}

