/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui.editor;

import java.util.Comparator;
import java.util.List;

class ChoiceMatch {
    int index = -1;
    int len;
    boolean exact;
    Object content;

    public static ChoiceMatch findExactOnContent(List list, Object match) {
        ChoiceMatch ret = new ChoiceMatch();
        ret.index = list.indexOf(match);
        if (ret.index != -1) {
            ret.exact = true;
            ret.content = match;
        }
        return ret;
    }

    public static ChoiceMatch findOnUnsortedContent(List content, int len, Comparator strComparator, String strStart, boolean fullMatch) {
        int strLen = strStart.length();
        ChoiceMatch ret = new ChoiceMatch();
        while (len-- > 0) {
            ret.content = content.get(len);
            String str = ret.content.toString();
            int matchLen = ChoiceMatch.getMatchingLength(strStart, str, strComparator);
            if ((matchLen <= 0 || matchLen < ret.len) && ret.len != 0) continue;
            ret.index = len;
            ret.len = matchLen;
            if (matchLen != strLen || str.length() != strLen) continue;
            ret.exact = true;
            return ret;
        }
        if (fullMatch) {
            ret.index = -1;
            ret.len = 0;
            ret.content = null;
        }
        return ret;
    }

    public static int getMatchingLength(String a, String b, Comparator stringComparator) {
        int max = Math.min(a.length(), b.length());
        for (int i = 0; i < max; ++i) {
            char s;
            char f = a.charAt(i);
            if (f == (s = b.charAt(i)) || stringComparator.compare(String.valueOf(f), String.valueOf(s)) == 0) continue;
            return i;
        }
        return max;
    }
}

