/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui.editor;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Format;
import java.text.ParseException;
import java.util.Comparator;
import java.util.regex.Pattern;
import javax.swing.CellRendererPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import net.coderazzi.filters.IParser;
import net.coderazzi.filters.artifacts.RowFilter;
import net.coderazzi.filters.gui.CustomChoice;
import net.coderazzi.filters.gui.Look;
import net.coderazzi.filters.gui.editor.ChoiceMatch;
import net.coderazzi.filters.gui.editor.FilterEditor;
import net.coderazzi.filters.gui.editor.IChoicesParser;
import net.coderazzi.filters.gui.editor.PopupComponent;

class EditorComponent
extends JTextField {
    private static final long serialVersionUID = -2196080442586435546L;
    private Controller controller;
    private boolean focus;
    boolean instantFiltering;
    boolean autoCompletion;
    FilterEditor filterEditor;
    PopupComponent popup;
    static final Pattern newLinePattern = Pattern.compile("[\n\r\t\f]");

    public EditorComponent(FilterEditor editor, PopupComponent popupComponent) {
        super(15);
        this.filterEditor = editor;
        this.popup = popupComponent;
        this.controller = new EditableTextController();
    }

    public void setUI(TextUI ui) {
        super.setUI(ui);
        this.setBorder(null);
    }

    protected void paintComponent(Graphics g) {
        this.controller.paintComponent(g);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.controller != null) {
            this.setCaretPosition(0);
            this.moveCaretPosition(0);
            this.updateLook();
            this.setFocusable(enabled);
        }
    }

    public void updateLook() {
        this.controller.updateLook();
    }

    public RowFilter getFilter() {
        return this.controller.getFilter();
    }

    public Object getContent() {
        return this.controller.getContent();
    }

    public void setContent(Object content) {
        this.controller.setContent(content);
    }

    public void updateParser() {
        if (this.controller instanceof TextController) {
            ((TextController)this.controller).setParser(this.filterEditor.createParser());
        }
    }

    public IChoicesParser getChoicesParser() {
        return this.controller instanceof IChoicesParser ? (IChoicesParser)((Object)this.controller) : null;
    }

    public boolean isEditableContent() {
        return this.controller instanceof EditableTextController;
    }

    public void setInstantFiltering(boolean enable) {
        this.instantFiltering = enable;
    }

    public boolean isInstantFiltering() {
        return this.instantFiltering;
    }

    public void setAutoCompletion(boolean enable) {
        this.autoCompletion = enable;
    }

    public boolean isAutoCompletion() {
        return this.autoCompletion;
    }

    public void setTextMode(boolean editable) {
        if (this.controller != null) {
            if (editable && this.controller instanceof EditableTextController) {
                return;
            }
            if (!editable && this.controller instanceof NonEditableTextController) {
                return;
            }
            this.controller.detach();
        }
        this.controller = editable ? new EditableTextController() : new NonEditableTextController();
        this.updateParser();
    }

    public void setRenderMode() {
        if (this.controller != null) {
            if (this.controller instanceof RenderedController) {
                return;
            }
            this.controller.detach();
        }
        this.controller = new RenderedController();
        this.filterEditor.filterUpdated(null);
    }

    public boolean isValidContent() {
        return this.controller.isValidContent();
    }

    public void consolidateFilter() {
        this.controller.consolidateFilter();
    }

    public void focusMoved(boolean gained) {
        this.focus = gained;
        this.controller.focusMoved(gained);
        if (gained) {
            this.setCaretPosition(0);
            this.moveCaretPosition(this.getText().length());
        }
    }

    public boolean isFocused() {
        return this.focus;
    }

    Look prepareComponentLook(CustomChoice cc) {
        return this.popup.getFilterRenderer().prepareComponentLook(this, this.isFocused(), cc);
    }

    void superPaintComponent(Graphics g) {
        super.paintComponent(g);
    }

    private class NonEditableTextController
    extends TextController {
        NonEditableTextController() {
            ((AbstractDocument)EditorComponent.this.getDocument()).setDocumentFilter(new ControllerDocumentFilter());
        }

        public void detach() {
            super.detach();
            ((AbstractDocument)EditorComponent.this.getDocument()).setDocumentFilter(null);
        }

        public String escapeChoice(String s) {
            return this.textParser.stripHtml(s);
        }

        protected String parseEscape(String text) {
            return this.textParser.escape(text);
        }

        protected void consolidateInstantFilter(String text, String content) {
            this.updateFilter(text, null, false);
        }

        class ControllerDocumentFilter
        extends DocumentFilter {
            ControllerDocumentFilter() {
            }

            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) {
            }

            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                if (!NonEditableTextController.this.userUpdate) {
                    super.replace(fb, offset, length, text, attrs);
                    return;
                }
                String buffer = EditorComponent.this.getText();
                String newContentBegin = buffer.substring(0, offset) + text;
                String newContent = newContentBegin + buffer.substring(offset + length);
                ChoiceMatch match = NonEditableTextController.this.getBestMatch(newContent);
                String proposal = null;
                if (match.exact) {
                    proposal = match.content.toString();
                } else {
                    ChoiceMatch match2 = NonEditableTextController.this.getExactMatch(newContentBegin);
                    if (match2.exact) {
                        match = match2;
                        proposal = match.content.toString();
                    } else {
                        if (match.content == null) {
                            return;
                        }
                        proposal = match.content.toString();
                        if (proposal.length() < newContentBegin.length() || 0 != EditorComponent.this.popup.getStringComparator().compare(newContentBegin, proposal.substring(0, newContentBegin.length()))) {
                            return;
                        }
                    }
                }
                int caret = 1 + Math.min(EditorComponent.this.getCaret().getDot(), EditorComponent.this.getCaret().getMark());
                super.replace(fb, 0, buffer.length(), proposal, attrs);
                int len = proposal.length();
                EditorComponent.this.setCaretPosition(len);
                EditorComponent.this.moveCaretPosition(Math.min(len, caret));
                NonEditableTextController.this.deactivateCustomDecoration();
                if (EditorComponent.this.instantFiltering) {
                    match.exact = true;
                    NonEditableTextController.this.updateFilter(proposal, match, true);
                }
            }

            public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                AWTEvent ev;
                int caret = EditorComponent.this.getCaret().getDot();
                int mark = EditorComponent.this.getCaret().getMark();
                String buffer = EditorComponent.this.getText();
                String newContent = buffer.substring(0, offset) + buffer.substring(offset + length);
                ChoiceMatch match = NonEditableTextController.this.getBestMatch(newContent);
                if (match.content == null) {
                    return;
                }
                String proposal = match.content.toString();
                Comparator<String> comparator = EditorComponent.this.popup.getStringComparator();
                if (!(match.exact && 0 == comparator.compare(newContent, proposal) || ChoiceMatch.getMatchingLength(proposal, newContent, comparator) > ChoiceMatch.getMatchingLength(buffer, newContent, comparator))) {
                    proposal = buffer;
                }
                if ((ev = EventQueue.getCurrentEvent()) instanceof KeyEvent && ((KeyEvent)ev).getKeyCode() == 8) {
                    if (caret > mark) {
                        caret = mark;
                    } else if (buffer == proposal) {
                        --caret;
                    } else if (caret == mark) {
                        caret = offset;
                    }
                }
                if (0 == caret && buffer == proposal) {
                    match.content = CustomChoice.MATCH_ALL;
                    proposal = match.content.toString();
                }
                if (buffer != proposal) {
                    super.replace(fb, 0, buffer.length(), proposal, null);
                }
                int len = proposal.length();
                EditorComponent.this.setCaretPosition(len);
                EditorComponent.this.moveCaretPosition(Math.min(len, caret));
                NonEditableTextController.this.deactivateCustomDecoration();
                if (NonEditableTextController.this.userUpdate && EditorComponent.this.instantFiltering && proposal != buffer) {
                    match.exact = true;
                    NonEditableTextController.this.updateFilter(proposal, match, true);
                }
            }
        }
    }

    private class EditableTextController
    extends TextController {
        EditableTextController() {
            ((AbstractDocument)EditorComponent.this.getDocument()).setDocumentFilter(new ControllerDocumentFilter());
        }

        public void detach() {
            super.detach();
            ((AbstractDocument)EditorComponent.this.getDocument()).setDocumentFilter(null);
        }

        public String escapeChoice(String s) {
            return this.textParser.escape(this.textParser.stripHtml(s));
        }

        protected String parseEscape(String text) {
            return text;
        }

        protected void consolidateInstantFilter(String text, String content) {
            this.setEditorText(content);
        }

        class ControllerDocumentFilter
        extends DocumentFilter {
            ControllerDocumentFilter() {
            }

            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) {
            }

            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                String now;
                int moveCaretLeft = 0;
                boolean singleCharacter = text.length() == 1;
                text = newLinePattern.matcher(text).replaceAll(" ");
                if (EditorComponent.this.autoCompletion && EditableTextController.this.userUpdate && singleCharacter && (now = EditorComponent.this.getText()).length() == offset + length) {
                    String begin = now.substring(0, offset) + text;
                    String completion = EditorComponent.this.popup.getCompletion(begin);
                    text = text + completion;
                    moveCaretLeft = completion.length();
                }
                super.replace(fb, offset, length, text, attrs);
                this.editorUpdated();
                if (moveCaretLeft > 0) {
                    int caret = EditorComponent.this.getDocument().getLength();
                    EditorComponent.this.setCaretPosition(caret);
                    EditorComponent.this.moveCaretPosition(caret - moveCaretLeft);
                }
            }

            public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                AWTEvent ev;
                if (offset > 0 && offset == EditorComponent.this.getCaretPosition() && (ev = EventQueue.getCurrentEvent()) instanceof KeyEvent && ((KeyEvent)ev).getKeyCode() == 8) {
                    ++length;
                    EditorComponent.this.setCaretPosition(--offset);
                }
                super.remove(fb, offset, length);
                this.editorUpdated();
            }

            private void editorUpdated() {
                if (EditableTextController.this.userUpdate) {
                    EditableTextController.this.deactivateCustomDecoration();
                    EditableTextController.this.setError(false);
                    String text = EditorComponent.this.getText();
                    if (EditorComponent.this.instantFiltering || EditorComponent.this.popup.isVisible()) {
                        ChoiceMatch match = EditableTextController.this.getBestMatch(text);
                        if (EditorComponent.this.instantFiltering) {
                            EditableTextController.this.updateFilter(text, match, true);
                        }
                    }
                }
            }
        }
    }

    private abstract class TextController
    implements Controller,
    CaretListener,
    IChoicesParser {
        protected IParser textParser;
        protected boolean userUpdate = true;
        private Object content;
        private RowFilter filter;
        private boolean error;
        private boolean useCustomDecoration;

        TextController() {
            EditorComponent.this.setEditable(true);
            EditorComponent.this.setText(CustomChoice.MATCH_ALL.toString());
            EditorComponent.this.addCaretListener(this);
        }

        public void setParser(IParser textParser) {
            this.textParser = textParser;
            if (EditorComponent.this.isEnabled()) {
                this.updateFilter();
            }
        }

        public void paintComponent(Graphics g) {
            EditorComponent.this.superPaintComponent(g);
            if (this.useCustomDecoration && this.content instanceof CustomChoice) {
                EditorComponent.this.filterEditor.getLook().getCustomChoiceDecorator().decorateComponent((CustomChoice)this.content, EditorComponent.this.filterEditor, EditorComponent.this.isFocused(), EditorComponent.this, g);
            }
        }

        public void detach() {
            EditorComponent.this.removeCaretListener(this);
        }

        public void setContent(Object content) {
            String text;
            ChoiceMatch match = new ChoiceMatch();
            if (content instanceof CustomChoice) {
                text = ((CustomChoice)content).toString();
                match.content = content;
            } else {
                Format fmt;
                text = content instanceof String ? (String)content : ((fmt = EditorComponent.this.filterEditor.getFormat()) == null ? content.toString() : fmt.format(content));
                match.content = text;
            }
            match.exact = true;
            this.setEditorText(text);
            this.updateFilter(text, match, false);
            this.activateCustomDecoration();
        }

        public Object getContent() {
            String ret;
            if (!EditorComponent.this.instantFiltering && !(ret = EditorComponent.this.getText()).equals(this.content.toString())) {
                return ret;
            }
            return this.content;
        }

        public boolean isValidContent() {
            return !this.error;
        }

        public void consolidateFilter() {
            String content;
            String text = EditorComponent.this.getText();
            if (!text.equals(content = this.content.toString())) {
                if (EditorComponent.this.instantFiltering) {
                    this.consolidateInstantFilter(text, content);
                } else {
                    this.updateFilter();
                }
            }
            EditorComponent.this.getCaret().setDot(EditorComponent.this.getCaret().getDot());
            this.activateCustomDecoration();
        }

        public RowFilter getFilter() {
            return this.filter;
        }

        public void updateLook() {
            Color foreground;
            CustomChoice cc = this.useCustomDecoration && this.content instanceof CustomChoice ? (CustomChoice)this.content : null;
            Look look = EditorComponent.this.prepareComponentLook(cc);
            if (EditorComponent.this.isEnabled() && this.error && (foreground = look.getErrorForeground()) != EditorComponent.this.getForeground()) {
                EditorComponent.this.setForeground(foreground);
            }
            Color selection = look.getTextSelection();
            if (EditorComponent.this.getSelectionColor() != selection) {
                EditorComponent.this.setSelectionColor(selection);
            }
        }

        public void focusMoved(boolean gained) {
            this.updateLook();
        }

        public void caretUpdate(CaretEvent e) {
            if (EditorComponent.this.isEnabled()) {
                EditorComponent.this.popup.setPopupFocused(false);
                this.deactivateCustomDecoration();
            }
        }

        protected void setError(boolean error) {
            if (this.error != error) {
                this.error = error;
                if (EditorComponent.this.isEnabled()) {
                    this.updateLook();
                }
            }
        }

        protected ChoiceMatch getBestMatch(String hint) {
            ChoiceMatch ret = EditorComponent.this.popup.selectBestMatch(hint, false);
            EditorComponent.this.popup.setPopupFocused(false);
            return ret;
        }

        protected ChoiceMatch getExactMatch(String hint) {
            ChoiceMatch ret = EditorComponent.this.popup.selectBestMatch(hint, true);
            EditorComponent.this.popup.setPopupFocused(false);
            return ret;
        }

        private boolean activateCustomDecoration() {
            boolean ret = false;
            if (!this.useCustomDecoration && this.content instanceof CustomChoice) {
                this.useCustomDecoration = true;
                this.updateLook();
                EditorComponent.this.repaint();
                ret = true;
            }
            return ret;
        }

        protected void deactivateCustomDecoration() {
            if (this.useCustomDecoration) {
                this.useCustomDecoration = false;
                this.updateLook();
                EditorComponent.this.repaint();
            }
        }

        protected void updateFilter() {
            this.updateFilter(null, null, false);
        }

        protected void updateFilter(String text, ChoiceMatch match, boolean userUpdate) {
            RowFilter currentFilter = this.filter;
            boolean error = false;
            if (text == null) {
                match = null;
                text = EditorComponent.this.getText();
            }
            if (match == null) {
                match = this.getBestMatch(text);
            }
            try {
                if (match.exact) {
                    this.content = match.content;
                    this.filter = match.content instanceof CustomChoice ? ((CustomChoice)this.content).getFilter(EditorComponent.this.filterEditor) : this.textParser.parseText(this.parseEscape(text));
                } else if (EditorComponent.this.instantFiltering && userUpdate) {
                    this.filter = this.textParser.parseText(this.parseEscape(text));
                    if (EditorComponent.this.filterEditor.attemptFilterUpdate(this.filter)) {
                        this.content = text;
                    } else {
                        IParser.InstantFilter iFilter = this.textParser.parseInstantText(this.parseEscape(text));
                        this.content = iFilter.expression;
                        this.filter = iFilter.filter;
                    }
                } else {
                    this.filter = this.textParser.parseText(this.parseEscape(text));
                    this.content = text;
                }
            }
            catch (ParseException pex) {
                this.filter = null;
                this.content = text;
                error = true;
                match = null;
            }
            this.setError(error);
            if (this.filter != currentFilter) {
                if (userUpdate) {
                    EditorComponent.this.filterEditor.attemptFilterUpdate(this.filter);
                } else {
                    EditorComponent.this.filterEditor.filterUpdated(this.filter);
                }
            }
        }

        protected void setEditorText(String text) {
            this.userUpdate = false;
            EditorComponent.this.setText(text);
            this.userUpdate = true;
        }

        protected abstract void consolidateInstantFilter(String var1, String var2);

        protected abstract String parseEscape(String var1);
    }

    private class RenderedController
    extends MouseAdapter
    implements Controller {
        private Object content = CustomChoice.MATCH_ALL;
        private CellRendererPane painter = new CellRendererPane();
        RowFilter filter;
        Object cachedContent = this.content;

        RenderedController() {
            EditorComponent.this.addMouseListener(this);
            EditorComponent.this.setEditable(false);
        }

        public void paintComponent(Graphics g) {
            Component c = EditorComponent.this.popup.getFilterRenderer().getCellRendererComponent(this.content, EditorComponent.this.getWidth(), EditorComponent.this.isFocused());
            this.painter.paintComponent(g, c, EditorComponent.this, 0, 0, EditorComponent.this.getWidth(), EditorComponent.this.getHeight());
        }

        public void detach() {
            EditorComponent.this.removeMouseListener(this);
        }

        public void setContent(Object content) {
            this.content = content;
            EditorComponent.this.repaint();
            this.consolidateFilter();
        }

        public Object getContent() {
            return this.content;
        }

        public boolean isValidContent() {
            return true;
        }

        public RowFilter getFilter() {
            return this.filter;
        }

        public void consolidateFilter() {
            Object currentContent = this.getContent();
            if (currentContent != this.cachedContent) {
                this.cachedContent = currentContent;
                this.filter = this.cachedContent instanceof CustomChoice ? ((CustomChoice)this.cachedContent).getFilter(EditorComponent.this.filterEditor) : new RowFilter(){

                    public boolean include(RowFilter.Entry entry) {
                        Object val = entry.getValue(EditorComponent.this.filterEditor.getModelIndex());
                        return val == null ? RenderedController.this.cachedContent == null : val.equals(RenderedController.this.cachedContent);
                    }
                };
                EditorComponent.this.filterEditor.filterUpdated(this.filter);
            }
        }

        public void updateLook() {
            EditorComponent.this.prepareComponentLook(null);
        }

        public void focusMoved(boolean gained) {
            EditorComponent.this.repaint();
        }

        public void mouseClicked(MouseEvent e) {
            if (EditorComponent.this.isEnabled()) {
                EditorComponent.this.filterEditor.triggerPopup(EditorComponent.this.filterEditor);
            }
        }
    }

    private static interface Controller {
        public void paintComponent(Graphics var1);

        public void detach();

        public void setContent(Object var1);

        public Object getContent();

        public boolean isValidContent();

        public RowFilter getFilter();

        public void consolidateFilter();

        public void updateLook();

        public void focusMoved(boolean var1);
    }
}

