/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.Format;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import net.coderazzi.filters.Filter;
import net.coderazzi.filters.IFilter;
import net.coderazzi.filters.IParser;
import net.coderazzi.filters.artifacts.RowFilter;
import net.coderazzi.filters.gui.AutoChoices;
import net.coderazzi.filters.gui.ChoiceRenderer;
import net.coderazzi.filters.gui.CustomChoice;
import net.coderazzi.filters.gui.FiltersHandler;
import net.coderazzi.filters.gui.IFilterEditor;
import net.coderazzi.filters.gui.IParserModel;
import net.coderazzi.filters.gui.Look;
import net.coderazzi.filters.gui.editor.EditorComponent;
import net.coderazzi.filters.gui.editor.FilterArrowButton;
import net.coderazzi.filters.gui.editor.PopupComponent;
import net.coderazzi.filters.parser.DateComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterEditor
extends JComponent
implements IFilterEditor {
    private static final long serialVersionUID = 6908400421021655278L;
    private EditorBorder border = new EditorBorder();
    private Set<CustomChoice> customChoices;
    private AutoChoices autoChoices;
    private Format format;
    private Comparator comparator;
    private Class modelClass;
    private boolean ignoreCase;
    private boolean enabledUI = true;
    FilterArrowButton downButton = new FilterArrowButton();
    EditorFilter filter = new EditorFilter();
    FiltersHandler filtersHandler;
    EditorComponent editor;
    PopupComponent popup;
    int modelIndex;

    public FilterEditor(FiltersHandler filtersHandler, int modelIndex, Class<?> modelClass, Look look) {
        this.filtersHandler = filtersHandler;
        this.modelIndex = modelIndex;
        this.modelClass = modelClass;
        this.setLayout(new BorderLayout());
        this.setBorder(this.border);
        this.popup = new PopupComponent(this){

            protected void choiceSelected(Object selection) {
                FilterEditor.this.popupSelection(selection);
            }
        };
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterEditor.this.triggerPopup(FilterEditor.this.downButton);
            }
        });
        this.add((Component)this.downButton, "East");
        this.editor = new EditorComponent(this, this.popup);
        this.setupComponent(this.editor);
        this.add((Component)this.editor, "Center");
        this.format = this.getParserModel().getFormat(modelClass);
        this.ignoreCase = this.getParserModel().isIgnoreCase();
        this.comparator = this.getParserModel().getComparator(modelClass);
        this.setLook(look);
        this.formatUpdated();
    }

    @Override
    public int getModelIndex() {
        return this.modelIndex;
    }

    public Class getModelClass() {
        return this.modelClass;
    }

    @Override
    public IFilter getFilter() {
        return this.filter;
    }

    @Override
    public void resetFilter() {
        this.popup.clearHistory();
        this.setEditorContent(CustomChoice.MATCH_ALL);
        this.requestChoices();
    }

    @Override
    public void setContent(Object content) {
        this.setEditorContent(content == null || "".equals(content) ? CustomChoice.MATCH_ALL : content);
    }

    @Override
    public Object getContent() {
        return this.editor.getContent();
    }

    @Override
    public void setAutoChoices(AutoChoices autoChoices) {
        if (autoChoices != null && autoChoices != this.autoChoices) {
            this.autoChoices = autoChoices;
            T[] enums = this.modelClass.getEnumConstants();
            if (Boolean.class == this.modelClass || enums != null && enums.length <= 8) {
                this.setEditable(this.editor.isAutoCompletion() || autoChoices == AutoChoices.DISABLED);
                this.setMaxHistory(0);
            } else {
                this.requestChoices();
            }
        }
    }

    @Override
    public AutoChoices getAutoChoices() {
        return this.autoChoices;
    }

    @Override
    public void setCustomChoices(Set<CustomChoice> choices) {
        this.customChoices = choices == null || choices.isEmpty() ? null : new HashSet<CustomChoice>(choices);
        this.requestChoices();
    }

    @Override
    public Set<CustomChoice> getCustomChoices() {
        return this.customChoices == null ? new HashSet<CustomChoice>() : new HashSet<CustomChoice>(this.customChoices);
    }

    @Override
    public void setUserInteractionEnabled(boolean enable) {
        this.enabledUI = enable;
        this.setFilterEnabled(this.filter.isEnabled());
    }

    @Override
    public boolean isUserInteractionEnabled() {
        return this.enabledUI;
    }

    @Override
    public void setEditable(boolean editable) {
        if (this.getRenderer() == null) {
            this.editor.setTextMode(editable);
            this.requestChoices();
        }
    }

    @Override
    public boolean isEditable() {
        return this.editor.isEditableContent();
    }

    @Override
    public void setIgnoreCase(boolean set) {
        if (this.ignoreCase != set) {
            this.ignoreCase = set;
            this.formatUpdated();
        }
    }

    @Override
    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public void setFormat(Format format) {
        if (this.format != format) {
            this.format = format;
            if (format != null && this.comparator instanceof DateComparator && Date.class.isAssignableFrom(this.modelClass)) {
                this.setComparator(DateComparator.getDateComparator(format));
            }
            this.formatUpdated();
        }
    }

    @Override
    public Format getFormat() {
        return this.format;
    }

    @Override
    public void setComparator(Comparator comparator) {
        if (comparator != this.comparator && comparator != null) {
            this.comparator = comparator;
            ChoiceRenderer lcr = this.getRenderer();
            if (lcr == null) {
                this.editor.updateParser();
            } else {
                this.popup.setRenderedContent(lcr, comparator);
                this.requestChoices();
            }
        }
    }

    @Override
    public Comparator getComparator() {
        return this.comparator;
    }

    @Override
    public void setAutoCompletion(boolean enable) {
        this.editor.setAutoCompletion(enable);
    }

    @Override
    public boolean isAutoCompletion() {
        return this.editor.isAutoCompletion();
    }

    @Override
    public void setInstantFiltering(boolean enable) {
        this.editor.setInstantFiltering(enable);
    }

    @Override
    public boolean isInstantFiltering() {
        return this.editor.isInstantFiltering();
    }

    @Override
    public void setMaxHistory(int size) {
        this.popup.setMaxHistory(size);
    }

    @Override
    public int getMaxHistory() {
        return this.popup.getMaxHistory();
    }

    @Override
    public void setHistory(List<Object> history) {
        this.popup.setHistory(history);
    }

    @Override
    public List<Object> getHistory() {
        return this.popup.getHistory();
    }

    @Override
    public void setRenderer(ChoiceRenderer renderer) {
        if (renderer == null) {
            this.popup.setStringContent(this.format, this.getStringComparator());
            this.editor.setTextMode(true);
        } else {
            this.popup.setRenderedContent(renderer, this.comparator);
            this.editor.setRenderMode();
        }
        this.requestChoices();
    }

    @Override
    public ChoiceRenderer getRenderer() {
        return this.popup.getFilterRenderer().getUserRenderer();
    }

    @Override
    public Look getLook() {
        return this.downButton.getLook();
    }

    public void setLook(Look look) {
        this.setBackground(look.getBackground());
        this.setForeground(look.getForeground());
        this.setFont(look.getFont());
        this.downButton.setLook(look);
        this.editor.updateLook();
        this.popup.setLook(look);
        this.border.color = look.getGridColor();
        this.repaint();
    }

    public boolean isEditing() {
        return this.editor.isFocused() && this.isEnabled();
    }

    public void setChoices(Collection<?> choices) {
        this.popup.clearChoices();
        this.addChoices(choices);
    }

    public Collection<?> getChoices() {
        return this.popup.getChoices();
    }

    public void addChoices(Collection<?> choices) {
        this.popup.addChoices(choices, this.editor.getChoicesParser());
    }

    void setFilterEnabled(boolean enabled) {
        boolean bl = enabled = enabled && this.enabledUI;
        if (enabled != this.isEnabled()) {
            super.setEnabled(enabled);
            this.downButton.setEnabled(enabled);
            this.popup.getFilterRenderer().setEnabled(enabled);
            this.editor.setEnabled(enabled);
        }
    }

    void filterUpdated(RowFilter editorFilter) {
        this.filter.editorFilterUpdated(editorFilter);
    }

    boolean attemptFilterUpdate(RowFilter editorFilter) {
        return this.filter.attemptEditorFilterUpdate(editorFilter);
    }

    IParser createParser() {
        return this.getParserModel().createParser(this);
    }

    void triggerPopup(Object source) {
        if (!this.popup.isMenuCanceledForMouseEvent(source)) {
            this.editor.requestFocus();
            if (this.showChoices()) {
                this.popup.setPopupFocused(true);
            }
        }
    }

    private void setEditorContent(Object content) {
        this.editor.setContent(content);
    }

    private void requestChoices() {
        if (this.isEnabled()) {
            this.filtersHandler.updateEditorChoices(this);
        }
    }

    private void formatUpdated() {
        if (this.getRenderer() == null) {
            this.popup.setStringContent(this.format, this.getStringComparator());
            this.editor.updateParser();
            this.requestChoices();
        }
    }

    private IParserModel getParserModel() {
        return this.filtersHandler.getParserModel();
    }

    private Comparator<String> getStringComparator() {
        return this.getParserModel().getStringComparator(this.ignoreCase);
    }

    private void setupComponent(JComponent component) {
        component.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                FilterEditor.this.popup.hide();
                FilterEditor.this.filter.consolidateFilter();
                FilterEditor.this.editor.focusMoved(false);
                FilterEditor.this.downButton.setFocused(false);
            }

            public void focusGained(FocusEvent e) {
                FilterEditor.this.downButton.setFocused(true);
                if (FilterEditor.this.isEnabled()) {
                    FilterEditor.this.editor.focusMoved(true);
                }
            }
        });
        component.setFocusable(true);
        this.setupEnterKey(component);
        this.setupEscKey(component);
        this.setupHomeKey(component);
        this.setupHomeCtrlKey(component);
        this.setupEndKey(component);
        this.setupEndCtrlKey(component);
        this.setupUpKey(component);
        this.setupUpCtrlKey(component);
        this.setupUpPageKey(component);
        this.setupDownPageKey(component);
        this.setupDownKey(component);
        this.setupDownCtrlKey(component);
    }

    void popupSelection(Object selection) {
        if (selection != null) {
            this.setEditorContent(selection);
            this.filter.consolidateFilter();
        }
    }

    boolean showChoices() {
        if (!this.popup.isVisible() && this.editor.isValid()) {
            if (!this.popup.display(this.editor)) {
                return false;
            }
            if (null == this.popup.selectBestMatch((Object)this.editor.getContent(), (boolean)false).content) {
                this.popup.selectBestMatch("", false);
            }
        }
        return true;
    }

    private void setupEnterKey(JComponent component) {
        String actionName = "FCB_ENTER";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = 6926912268574067920L;

            public void actionPerformed(ActionEvent e) {
                if (FilterEditor.this.popup.isPopupFocused()) {
                    FilterEditor.this.popupSelection(FilterEditor.this.popup.getSelection());
                } else {
                    FilterEditor.this.filter.consolidateFilter();
                }
                FilterEditor.this.popup.hide();
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), actionName);
    }

    private void setupEscKey(JComponent component) {
        String actionName = "FCB_ESC";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = -4351240441578952476L;

            public void actionPerformed(ActionEvent e) {
                FilterEditor.this.popup.hide();
                if (e.getSource() instanceof JTextField) {
                    JTextField textField = (JTextField)e.getSource();
                    textField.setCaretPosition(textField.getCaretPosition());
                }
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(27, 0), actionName);
    }

    private void setupEndKey(JComponent component) {
        String actionName = "FCB_END";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = -2777729244353281164L;

            public void actionPerformed(ActionEvent e) {
                if (!(FilterEditor.this.popup.isPopupFocused() && FilterEditor.this.popup.selectLast(false) || !(e.getSource() instanceof JTextField))) {
                    JTextField textField = (JTextField)e.getSource();
                    textField.setCaretPosition(textField.getText().length());
                }
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(35, 0), actionName);
    }

    private void setupEndCtrlKey(JComponent component) {
        String actionName = "FCB_END_CTRL";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = 1945871436968682881L;

            public void actionPerformed(ActionEvent e) {
                if (!(FilterEditor.this.popup.isPopupFocused() && FilterEditor.this.popup.selectLast(true) || !(e.getSource() instanceof JTextField))) {
                    JTextField textField = (JTextField)e.getSource();
                    textField.setCaretPosition(textField.getText().length());
                }
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(35, 2), actionName);
    }

    private void setupHomeCtrlKey(JComponent component) {
        String actionName = "FCB_HOME_CTRL";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = 3916227645612863334L;

            public void actionPerformed(ActionEvent e) {
                if (!(FilterEditor.this.popup.isPopupFocused() && FilterEditor.this.popup.selectFirst(true) || !(e.getSource() instanceof JTextField))) {
                    JTextField textField = (JTextField)e.getSource();
                    textField.setCaretPosition(0);
                }
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(36, 2), actionName);
    }

    private void setupHomeKey(JComponent component) {
        String actionName = "FCB_HOME";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = -1583258893221830664L;

            public void actionPerformed(ActionEvent e) {
                if (!(FilterEditor.this.popup.isPopupFocused() && FilterEditor.this.popup.selectFirst(false) || !(e.getSource() instanceof JTextField))) {
                    JTextField textField = (JTextField)e.getSource();
                    textField.setCaretPosition(0);
                }
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(36, 0), actionName);
    }

    private void setupDownPageKey(JComponent component) {
        String actionName = "FCB_PAGE_DOWN";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = -1187830005921916553L;

            public void actionPerformed(ActionEvent e) {
                if (FilterEditor.this.popup.isVisible()) {
                    boolean focusPopup = FilterEditor.this.popup.isPopupFocused();
                    FilterEditor.this.popup.selectDownPage();
                    FilterEditor.this.popup.setPopupFocused(focusPopup);
                } else {
                    FilterEditor.this.showChoices();
                }
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(34, 0), actionName);
    }

    private void setupUpPageKey(JComponent component) {
        String actionName = "FCB_PAGE_UP";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = 6590487133211390977L;

            public void actionPerformed(ActionEvent e) {
                if (FilterEditor.this.popup.isVisible()) {
                    boolean focusPopup = FilterEditor.this.popup.isPopupFocused();
                    FilterEditor.this.popup.selectUpPage();
                    FilterEditor.this.popup.setPopupFocused(focusPopup);
                }
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(33, 0), actionName);
    }

    private void setupUpCtrlKey(JComponent component) {
        String actionName = "FCB_UP_CTRL";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = 746565926592574009L;

            public void actionPerformed(ActionEvent e) {
                if (FilterEditor.this.popup.isPopupFocused() && !FilterEditor.this.popup.selectUp(true)) {
                    FilterEditor.this.popup.setPopupFocused(false);
                }
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(38, 2), actionName);
    }

    private void setupUpKey(JComponent component) {
        String actionName = "FCB_UP";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = 4555560696351340571L;

            public void actionPerformed(ActionEvent e) {
                if (FilterEditor.this.popup.isVisible()) {
                    if (FilterEditor.this.popup.isPopupFocused()) {
                        FilterEditor.this.popup.selectUp(false);
                    } else {
                        FilterEditor.this.popup.setPopupFocused(true);
                        if (!FilterEditor.this.popup.isPopupFocused()) {
                            FilterEditor.this.popup.hide();
                        }
                    }
                } else {
                    FilterEditor.this.showChoices();
                }
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(38, 0), actionName);
    }

    private void setupDownCtrlKey(JComponent component) {
        String actionName = "FCB_DOWN_CTRL";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = -8075976293862885060L;

            public void actionPerformed(ActionEvent e) {
                if (FilterEditor.this.popup.isVisible()) {
                    if (FilterEditor.this.popup.isPopupFocused()) {
                        FilterEditor.this.popup.selectDown(true);
                    } else {
                        FilterEditor.this.popup.setPopupFocused(true);
                    }
                } else {
                    FilterEditor.this.showChoices();
                }
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(40, 2), actionName);
    }

    private void setupDownKey(JComponent component) {
        String actionName = "FCB_DOWN";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = -4133513199725709434L;

            public void actionPerformed(ActionEvent e) {
                if (FilterEditor.this.popup.isVisible()) {
                    if (FilterEditor.this.popup.isPopupFocused()) {
                        FilterEditor.this.popup.selectDown(false);
                    } else {
                        FilterEditor.this.popup.setPopupFocused(true);
                    }
                } else {
                    FilterEditor.this.showChoices();
                }
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(40, 0), actionName);
    }

    static final class EditorBorder
    implements Border {
        Color color;

        EditorBorder() {
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(this.color);
            g.drawLine(0, height - 1, width - 1, height - 1);
            g.drawLine(width - 1, 0, width - 1, height - 1);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(0, 1, 1, 1);
        }
    }

    final class EditorFilter
    extends Filter {
        RowFilter delegateFilter;
        boolean toBeConsolidated;
        boolean reportOnConsolidation;

        EditorFilter() {
        }

        public boolean include(RowFilter.Entry entry) {
            return this.delegateFilter == null ? true : this.delegateFilter.include(entry);
        }

        public void setEnabled(boolean enable) {
            if (enable != this.isEnabled()) {
                FilterEditor.this.setFilterEnabled(enable);
                this.delegateFilter = enable ? FilterEditor.this.editor.getFilter() : null;
                super.setEnabled(enable);
            }
        }

        public void editorFilterUpdated(RowFilter filter) {
            if (this.isEnabled() && filter != this.delegateFilter) {
                this.delegateFilter = filter;
                this.reportFilterUpdatedToObservers();
                this.reportOnConsolidation = false;
                if (FilterEditor.this.editor.isFocused()) {
                    this.toBeConsolidated = true;
                }
            }
        }

        public boolean attemptEditorFilterUpdate(RowFilter filter) {
            this.delegateFilter = filter;
            boolean ret = FilterEditor.this.filtersHandler.applyEditorFilter(this);
            if (ret) {
                this.toBeConsolidated = true;
                this.reportOnConsolidation = false;
            } else {
                this.reportOnConsolidation = true;
            }
            return ret;
        }

        public void consolidateFilter() {
            if (this.isEnabled()) {
                FilterEditor.this.editor.consolidateFilter();
                if (this.reportOnConsolidation) {
                    this.reportOnConsolidation = false;
                    this.reportFilterUpdatedToObservers();
                }
                if (this.toBeConsolidated) {
                    this.toBeConsolidated = false;
                    if (FilterEditor.this.editor.isValidContent()) {
                        FilterEditor.this.popup.addHistory(FilterEditor.this.editor.getContent());
                    }
                }
            }
        }
    }
}

