/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.httpserver;

import colesico.framework.http.HttpContext;
import colesico.framework.http.HttpResponse;
import colesico.framework.httpserver.ErrorHandler;
import colesico.framework.router.UnknownRouteException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultErrorHandler
implements ErrorHandler {
    public static final String HTML_CONTENT_TYPE = "text/html; charset=utf-8";
    protected final Logger logger = LoggerFactory.getLogger(ErrorHandler.class);

    protected String toStackTrace(Exception cause) {
        if (cause == null) {
            return "";
        }
        StringWriter sw = new StringWriter(1024);
        PrintWriter pw = new PrintWriter(sw);
        cause.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    @Override
    public void handleException(Exception exception, HttpContext httpContext) {
        String rootMessage = ExceptionUtils.getRootCauseMessage((Throwable)exception);
        this.logger.error("Unexpected error: " + rootMessage);
        this.logger.error(this.toStackTrace(exception));
        StringBuilder out = new StringBuilder("<!doctype html>");
        out.append("<html>");
        out.append("<head>");
        out.append("<title>").append("Error").append("</title>");
        out.append("</head>");
        out.append("<body>");
        out.append("An unexpected error occurred at ").append(new Date().toInstant()).append(". See server log for details.");
        out.append("</body>");
        out.append("</html>");
        HttpResponse response = httpContext.getResponse();
        try {
            if (exception instanceof UnknownRouteException) {
                response.sendText(out.toString(), HTML_CONTENT_TYPE, Integer.valueOf(404));
            } else {
                response.sendText(out.toString(), HTML_CONTENT_TYPE, Integer.valueOf(500));
            }
        }
        catch (Exception ex) {
            this.logger.error("Sending error page error: " + ExceptionUtils.getRootCauseMessage((Throwable)ex));
        }
    }
}

