/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.httpserver;

import colesico.framework.http.HttpContext;
import colesico.framework.http.HttpRequest;
import colesico.framework.http.HttpResponse;
import colesico.framework.httpserver.ErrorHandler;
import colesico.framework.httpserver.HttpServer;
import colesico.framework.ioc.scope.ThreadScope;
import colesico.framework.router.Router;
import java.text.MessageFormat;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestProcessor<C> {
    protected final Logger log = LoggerFactory.getLogger(HttpServer.class);
    protected final ThreadScope threadScope;
    protected final Router router;
    protected final ErrorHandler errorHandler;

    public RequestProcessor(ThreadScope threadScope, Router router, ErrorHandler errorHandler) {
        this.threadScope = threadScope;
        this.router = router;
        this.errorHandler = errorHandler;
    }

    protected abstract HttpRequest createHttpRequest(C var1);

    protected abstract HttpResponse createHttpResponse(C var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(C context) {
        HttpRequest httpRequest = this.createHttpRequest(context);
        HttpResponse httpResponse = this.createHttpResponse(context);
        HttpContext httpContext = new HttpContext(httpRequest, httpResponse);
        this.threadScope.init();
        this.threadScope.put(HttpContext.SCOPE_KEY, (Object)httpContext);
        try {
            this.router.dispatch(httpRequest.getRequestMethod(), httpRequest.getRequestURI());
        }
        catch (Exception ex) {
            String errMsg = MessageFormat.format("Request processing error: {0}", ExceptionUtils.getRootCauseMessage((Throwable)ex));
            this.log.error(errMsg);
            try {
                this.errorHandler.handleException(ex, httpContext);
            }
            catch (Exception ex2) {
                String errMsg2 = MessageFormat.format("Handling exception error: {0}", ExceptionUtils.getRootCauseMessage((Throwable)ex2));
                this.log.error(errMsg2);
            }
        }
        finally {
            this.threadScope.destroy();
        }
    }
}

