/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.httpserver;

import colesico.framework.http.HttpContext;
import colesico.framework.http.HttpMethod;
import colesico.framework.http.HttpRequest;
import colesico.framework.http.HttpResponse;
import colesico.framework.httpserver.ErrorHandler;
import colesico.framework.httpserver.HttpServer;
import colesico.framework.ioc.scope.ThreadScope;
import colesico.framework.router.ActionResolution;
import colesico.framework.router.Router;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestProcessor<C> {
    protected final Logger log = LoggerFactory.getLogger(HttpServer.class);
    protected final ThreadScope threadScope;
    protected final Router router;
    protected final ErrorHandler errorHandler;

    public RequestProcessor(ThreadScope threadScope, Router router, ErrorHandler errorHandler) {
        this.threadScope = threadScope;
        this.router = router;
        this.errorHandler = errorHandler;
    }

    protected abstract HttpRequest createHttpRequest(C var1);

    protected abstract HttpResponse createHttpResponse(C var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActionResolution resolveAction(HttpMethod requestMethod, String requestUri, C context) {
        try {
            return this.router.resolveAction(requestMethod, requestUri);
        }
        catch (Exception e) {
            this.threadScope.init();
            try {
                HttpContext httpContext = this.initHttpContext(context);
                this.handleException(e, httpContext);
            }
            finally {
                this.threadScope.destroy();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(ActionResolution resolution, C context) {
        this.threadScope.init();
        HttpContext httpContext = this.initHttpContext(context);
        try {
            this.router.performAction(resolution);
        }
        catch (Exception e) {
            this.handleException(e, httpContext);
        }
        finally {
            this.threadScope.destroy();
        }
    }

    protected void handleException(Exception ex, HttpContext httpContext) {
        this.log.error("Request processing error: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)ex));
        try {
            this.errorHandler.handleException(ex, httpContext);
        }
        catch (Exception ex2) {
            this.log.error("Handling exception error: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)ex2));
        }
    }

    protected HttpContext initHttpContext(C context) {
        HttpRequest httpRequest = this.createHttpRequest(context);
        HttpResponse httpResponse = this.createHttpResponse(context);
        HttpContext httpContext = new HttpContext(httpRequest, httpResponse);
        this.threadScope.put(HttpContext.SCOPE_KEY, (Object)httpContext);
        return httpContext;
    }
}

