/*
 * Decompiled with CFR 0.152.
 */
package net.dzultra.jfa.punishments;

import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.dzultra.jfa.apidata.PlayerSearch;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class LiteBansScraper {
    private static final String BASE_URL = "https://www.mcfoxcraft.com/newbans/history.php?uuid=";
    private static String test = "Test";

    public static List<Punishment> fetchAllPunishments(String uuid) throws IOException, InterruptedException {
        ArrayList<Punishment> allPunishments = new ArrayList<Punishment>();
        String before = null;
        while (true) {
            Document doc;
            Elements rows;
            String url = BASE_URL + uuid;
            if (before != null) {
                url = url + "&before=" + before;
            }
            if ((rows = (doc = Jsoup.connect((String)url).userAgent("Mozilla/5.0").timeout(10000).get()).select("table tbody tr")).isEmpty()) break;
            for (Element row : rows) {
                Element link = row.selectFirst("a[href*=info.php]");
                String href = link != null ? link.attr("href") : "";
                int id = LiteBansScraper.extractId(href);
                String type = LiteBansScraper.extractType(href);
                String playerName = row.select("td:nth-child(2) span").text();
                String playerUUID = LiteBansScraper.extractUUID(row.select("td:nth-child(2) img").attr("src"));
                String moderatorName = row.select("td:nth-child(3) span").text();
                String moderatorUUID = LiteBansScraper.extractUUID(row.select("td:nth-child(3) img").attr("src"));
                String reason = row.select("td:nth-child(4)").text();
                String date = row.select("td:nth-child(5)").text();
                String expires = row.select("td:nth-child(6)").text();
                Punishment p = new Punishment(type, id, playerName, playerUUID, moderatorName, moderatorUUID, reason, date, expires);
                allPunishments.add(p);
            }
            Element nextLink = doc.selectFirst("a.litebans-pager-right.litebans-pager-active");
            if (nextLink == null) break;
            before = LiteBansScraper.extractBefore(nextLink.attr("href"));
            Thread.sleep(150L);
        }
        return allPunishments;
    }

    private static int extractId(String href) {
        try {
            String[] parts;
            for (String part : parts = href.split("&")) {
                if (!part.startsWith("id=")) continue;
                return Integer.parseInt(part.substring(3));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private static String extractType(String href) {
        try {
            String[] parts;
            for (String part : parts = href.split("&")) {
                if (!part.startsWith("type=")) continue;
                return part.substring(5);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private static String extractUUID(String src) {
        try {
            String[] parts = src.split("/");
            for (int i = 0; i < parts.length; ++i) {
                if (!parts[i].equals("avatar") || i + 1 >= parts.length) continue;
                return parts[i + 1];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private static String extractBefore(String href) {
        try {
            String[] parts;
            href = URLDecoder.decode(href, StandardCharsets.UTF_8);
            for (String part : parts = href.split("&")) {
                if (!part.startsWith("before=")) continue;
                return part.substring(7);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        String uuid = new PlayerSearch("Z_e_r_o_x").getUuid();
        List<Punishment> punishments = LiteBansScraper.fetchAllPunishments(uuid);
        System.out.println("Total punishments: " + punishments.size());
        punishments.forEach(System.out::println);
    }

    public record Punishment(String type, int id, String playerName, String playerUUID, String moderatorName, String moderatorUUID, String reason, String date, String expires) {
    }
}

