/*
 * Decompiled with CFR 0.152.
 */
package net.dzultra.jfa.types.statistics;

import java.util.concurrent.TimeUnit;

public class TimePlayedStat {
    private final float time;
    private final TimeUnit timeUnit;

    public TimePlayedStat(String string) {
        if (string.equals("N/A")) {
            this.time = 0.0f;
            this.timeUnit = TimeUnit.HOURS;
        } else {
            String[] splitString = string.split(" ");
            this.time = Float.parseFloat(splitString[0]);
            switch (splitString[1]) {
                case "hours": {
                    this.timeUnit = TimeUnit.HOURS;
                    break;
                }
                case "minutes": {
                    this.timeUnit = TimeUnit.MINUTES;
                    break;
                }
                default: {
                    this.timeUnit = null;
                }
            }
        }
    }

    public float getTime() {
        return this.time;
    }

    public TimeUnit getUnit() {
        return this.timeUnit;
    }

    public String asString() {
        return this.getTime() + " " + this.getUnit().toString().toLowerCase();
    }
}

