/*
 * Decompiled with CFR 0.152.
 */
package net.dzultra.jfa.requests;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import net.dzultra.jfa.exceptions.InvalidUUIDException;
import net.dzultra.jfa.requests.Request;
import net.dzultra.jfa.responses.PlayerSkinResponse;

public class PlayerSkinRequest
extends Request<byte[]> {
    private final String uuid;
    private final String username;
    private final boolean asHead;
    private static final String baseEndpoint = "/skin?uuid=";

    public PlayerSkinRequest(String uuid, boolean asHead) {
        super(baseEndpoint, uuid);
        if (!this.data.matches("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")) {
            throw new InvalidUUIDException(this);
        }
        this.uuid = uuid;
        this.asHead = asHead;
        this.username = null;
    }

    public PlayerSkinRequest(String data, boolean asHead, boolean asUsername) {
        super(baseEndpoint, data);
        if (!asUsername) {
            this.username = null;
            if (!data.matches("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")) {
                throw new InvalidUUIDException(this);
            }
            this.uuid = data;
        } else {
            this.username = data;
            this.uuid = this.getUuidFromUsername(this.username);
        }
        this.asHead = asHead;
    }

    @Override
    public String getBaseEndpoint() {
        return baseEndpoint;
    }

    @Override
    public String getFullEndpoint() {
        return this.getBaseEndpoint() + this.getUuid() + (this.asHead ? "&format=head" : "");
    }

    @Override
    public String getUrl() {
        return "https://www.mcfoxcraft.com/api" + this.getFullEndpoint();
    }

    public String getUuid() {
        return this.uuid;
    }

    @Override
    public PlayerSkinResponse getResponse() {
        byte[] byteArrayResponse = this.getByteArrayResponse();
        return new PlayerSkinResponse(byteArrayResponse);
    }

    protected byte[] getByteArrayResponse() {
        Optional<HttpResponse<String>> optionalStringResponse = this.getOptionalStringHttpResponse();
        String stringResponse = optionalStringResponse.map(HttpResponse::body).orElse(null);
        if (this.isValidResponse(stringResponse)) {
            System.out.println("No skin found for the given uuid.");
            return null;
        }
        Optional<HttpResponse<byte[]>> optionalByteArrayResponse = this.getOptionalByteArrayHttpResponse();
        return optionalByteArrayResponse.map(HttpResponse::body).orElse(null);
    }

    private Optional<HttpResponse<byte[]>> getOptionalByteArrayHttpResponse() {
        try {
            System.out.println("Sending PlayerSkinRequest to URL: " + this.getUrl());
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.getUrl())).GET().build();
            return Optional.of(this.getHttpClient().send(request, HttpResponse.BodyHandlers.ofByteArray()));
        }
        catch (IOException | IllegalArgumentException | InterruptedException e) {
            System.out.println("Error during PlayerSkinRequest HTTP call: " + e.getMessage());
            return Optional.empty();
        }
    }

    private Optional<HttpResponse<String>> getOptionalStringHttpResponse() {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.getUrl())).GET().build();
            return Optional.of(this.getHttpClient().send(request, HttpResponse.BodyHandlers.ofString()));
        }
        catch (IOException | IllegalArgumentException | InterruptedException e) {
            return Optional.empty();
        }
    }
}

