/*
 * Decompiled with CFR 0.152.
 */
package net.dzultra.jfa.requests;

import com.google.gson.Gson;
import net.dzultra.jfa.exceptions.InvalidUUIDException;
import net.dzultra.jfa.requests.Request;
import net.dzultra.jfa.responses.PlayerStatisticsResponse;

public class PlayerStatisticsRequest
extends Request<String> {
    private final String uuid;
    private final String username;
    private static final String baseEndpoint = "/web/player?uuid=";

    public PlayerStatisticsRequest(String uuid) {
        super(baseEndpoint, uuid);
        if (!this.data.matches("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")) {
            throw new InvalidUUIDException(this);
        }
        this.uuid = uuid;
        this.username = null;
    }

    public PlayerStatisticsRequest(String data, boolean asUsername) {
        super(baseEndpoint, data);
        if (!asUsername) {
            this.username = null;
            if (!data.matches("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")) {
                throw new InvalidUUIDException(this);
            }
            this.uuid = data;
        } else {
            this.username = data;
            this.uuid = this.getUuidFromUsername(this.username);
        }
    }

    @Override
    public String getBaseEndpoint() {
        return baseEndpoint;
    }

    @Override
    public String getFullEndpoint() {
        return this.getBaseEndpoint() + this.getUuid();
    }

    @Override
    public String getUrl() {
        return "https://www.mcfoxcraft.com/api" + this.getFullEndpoint();
    }

    public String getUuid() {
        return this.uuid;
    }

    @Override
    public PlayerStatisticsResponse getResponse() {
        Gson gson = new Gson();
        String stringResponse = this.getStringResponse();
        if (!this.isValidResponse(stringResponse)) {
            return new PlayerStatisticsResponse(null);
        }
        return (PlayerStatisticsResponse)gson.fromJson(stringResponse, PlayerStatisticsResponse.class);
    }
}

