/*
 * Decompiled with CFR 0.152.
 */
package net.dzultra.jfa.apidata;

import java.util.List;
import net.dzultra.jfa.apidata.APIDataObject;
import net.dzultra.jfa.exceptions.InvalidResponseException;
import net.dzultra.jfa.exceptions.NoExactMatchException;
import net.dzultra.jfa.requests.PlayerSearchRequest;
import net.dzultra.jfa.responses.PlayerSearchResponse;

public class PlayerSearch
extends APIDataObject<PlayerSearchRequest, PlayerSearchResponse> {
    private PlayerSearchResponse.PlayerSearchResult playerSearchResult;
    private String uuid;
    private String username;
    private String headUrl;

    public PlayerSearch(String username) {
        this(new PlayerSearchRequest(username));
    }

    public PlayerSearch(PlayerSearchRequest request) {
        super(request, request.getResponse());
        this.dataHandler();
    }

    @Override
    protected void dataHandler() {
        List<PlayerSearchResponse.PlayerSearchResult> playerSearchResults = ((PlayerSearchResponse)this.response).players();
        if (playerSearchResults == null) {
            throw new InvalidResponseException(this);
        }
        if (!this.getRequestedUsername().equals(playerSearchResults.getFirst().username())) {
            throw new NoExactMatchException(this, this.username);
        }
        this.playerSearchResult = ((PlayerSearchResponse)this.response).players().getFirst();
        this.uuid = this.getPlayerSearchResult().uuid();
        this.username = this.getPlayerSearchResult().username();
        this.headUrl = this.getPlayerSearchResult().headUrl();
    }

    @Override
    public String getName() {
        return "PlayerSearch";
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getUsername() {
        return this.username;
    }

    public String getHeadUrl() {
        return this.headUrl;
    }

    public String getRequestedUsername() {
        return ((PlayerSearchRequest)this.request).getUsername();
    }

    private PlayerSearchResponse.PlayerSearchResult getPlayerSearchResult() {
        return this.playerSearchResult;
    }
}

