/*
 * Decompiled with CFR 0.152.
 */
package net.dzultra.jfa.apidata;

import java.util.List;
import java.util.Optional;
import net.dzultra.jfa.apidata.APIDataObject;
import net.dzultra.jfa.exceptions.InvalidResponseException;
import net.dzultra.jfa.requests.ServerLeaderboardMetadataRequest;
import net.dzultra.jfa.responses.ServerLeaderboardMetadataResponse;
import net.dzultra.jfa.types.Gamemode;
import net.dzultra.jfa.types.Period;

public class ServerLeaderboardMetadata
extends APIDataObject<ServerLeaderboardMetadataRequest, ServerLeaderboardMetadataResponse> {
    private List<GameModeMap> gamemodes = null;
    private List<PeriodMap> periods = null;

    public ServerLeaderboardMetadata() {
        this(new ServerLeaderboardMetadataRequest());
    }

    private ServerLeaderboardMetadata(ServerLeaderboardMetadataRequest request) {
        super(request, request.getResponse());
        this.dataHandler();
    }

    @Override
    protected void dataHandler() {
        ServerLeaderboardMetadataResponse rawResponse = (ServerLeaderboardMetadataResponse)this.response;
        if (rawResponse.gamemodes() == null || rawResponse.periods() == null || rawResponse.initialArgs() == null) {
            throw new InvalidResponseException(this);
        }
        this.gamemodes = rawResponse.gamemodes().stream().map(list -> new GameModeMap((String)list.get(0), (String)list.get(1))).toList();
        this.periods = rawResponse.periods().stream().map(list -> new PeriodMap((String)list.get(0), (String)list.get(1))).toList();
    }

    @Override
    public String getName() {
        return "ServerLeaderboardMetaData";
    }

    public List<PeriodMap> getPeriods() {
        return this.periods;
    }

    public List<GameModeMap> getGamemodes() {
        return this.gamemodes;
    }

    public ServerLeaderboardMetadataResponse.InitialSelection getInitialSelection() {
        return ((ServerLeaderboardMetadataResponse)this.response).initialArgs();
    }

    public GameModeMap getGamemode(Gamemode gamemodeType) {
        GameModeMap gameModeMap = this.gamemodes.stream().filter(gamemode -> gamemode.serverId().equals(gamemodeType.getName())).findFirst().orElse(null);
        return Optional.ofNullable(gameModeMap).orElseThrow(() -> new InvalidResponseException(this));
    }

    public PeriodMap getPeriod(Period periodType) {
        PeriodMap periodMap = this.periods.stream().filter(period -> period.period.equals(periodType.getName())).findFirst().orElse(null);
        return Optional.ofNullable(periodMap).orElseThrow(() -> new InvalidResponseException(this));
    }

    public String initialServer() {
        return ((ServerLeaderboardMetadataResponse)this.response).initialArgs().gamemode();
    }

    public record GameModeMap(String serverId, String serverName) {
    }

    public record PeriodMap(String period, String timeline) {
    }
}

