/*
 * Decompiled with CFR 0.152.
 */
package net.dzultra.jfa.punishments;

import java.util.List;
import net.dzultra.jfa.apidata.PlayerSearch;
import net.dzultra.jfa.exceptions.PunishmentOutOfBoundsException;
import net.dzultra.jfa.punishments.LiteBansScraper;
import net.dzultra.jfa.punishments.Punishment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerPunishments {
    private final String uuid;
    private final List<Punishment> punishments;

    public PlayerPunishments(@NotNull String username) {
        this.uuid = new PlayerSearch(username).getUuid();
        this.punishments = LiteBansScraper.fetchPunishments(this.uuid);
    }

    public PlayerPunishments(@NotNull String data, boolean asUUID) {
        if (asUUID) {
            this.uuid = data;
            this.punishments = LiteBansScraper.fetchPunishments(this.uuid);
        } else {
            this.uuid = new PlayerSearch(data).getUuid();
            this.punishments = LiteBansScraper.fetchPunishments(this.uuid);
        }
    }

    @Nullable
    public String getUuid() {
        return this.uuid;
    }

    public List<Punishment> getPunishments() {
        return this.punishments;
    }

    public Punishment getPunishment(int index) {
        try {
            return this.punishments.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PunishmentOutOfBoundsException(this.punishments, index);
        }
    }
}

