/*
 * Decompiled with CFR 0.152.
 */
package net.dzultra.jfa.apidata;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.dzultra.jfa.apidata.APIDataObject;
import net.dzultra.jfa.apidata.PlayerStats;
import net.dzultra.jfa.exceptions.InvalidPlayerStatsException;
import net.dzultra.jfa.exceptions.InvalidResponseException;
import net.dzultra.jfa.requests.PlayerStatisticsRequest;
import net.dzultra.jfa.responses.PlayerStatisticsResponse;
import net.dzultra.jfa.types.Gamemode;
import net.dzultra.jfa.types.statistics.Badge;
import net.dzultra.jfa.types.statistics.DistanceTraveledStat;
import net.dzultra.jfa.types.statistics.InitialGamemodeJoinDateStat;
import net.dzultra.jfa.types.statistics.TimePlayedStat;

public class PlayerStatistics
extends APIDataObject<PlayerStatisticsRequest, PlayerStatisticsResponse> {
    private PlayerStats playerStats;

    public PlayerStatistics(String uuid) {
        this(new PlayerStatisticsRequest(uuid));
    }

    public PlayerStatistics(String data, boolean asUsername) {
        this(new PlayerStatisticsRequest(data, asUsername));
    }

    private PlayerStatistics(PlayerStatisticsRequest request) {
        super(request, request.getResponse());
        this.dataHandler();
    }

    @Override
    protected void dataHandler() {
        PlayerStatisticsResponse.PlayerStatisticsResult pSResult = ((PlayerStatisticsResponse)this.response).playerStatisticsResult();
        if (pSResult == null) {
            throw new InvalidResponseException(this);
        }
        String gamemodeText = pSResult.currentGamemode().getFirst();
        boolean isOnline = false;
        boolean isBedrock = false;
        Badge badge = null;
        if (!pSResult.status().isEmpty()) {
            isOnline = pSResult.status().getFirst().stream().anyMatch(Predicate.isEqual("Online"));
            isBedrock = pSResult.status().getFirst().stream().anyMatch(Predicate.isEqual("Bedrock"));
            for (String string : pSResult.status().getFirst()) {
                if (!string.contains("badge--")) continue;
                if (string.substring("badge--".length()).equals("green")) {
                    badge = Badge.GREEN;
                    continue;
                }
                if (!string.substring("badge--".length()).equals("blue")) continue;
                badge = Badge.BLUE;
            }
        }
        boolean isHidden = gamemodeText.contains("server hidden");
        Gamemode gamemode = null;
        String lastSeen = null;
        if (isHidden) {
            gamemode = Gamemode.HIDDEN;
        } else if (gamemodeText.contains("Last seen:")) {
            gamemode = Gamemode.OFFLINE;
            lastSeen = gamemodeText;
        } else if (gamemodeText.contains("Online on ")) {
            gamemode = Gamemode.getGamemodeByName(gamemodeText.substring("Online on ".length()));
        }
        PlayerStats.OneblockStats oneblockStats = null;
        PlayerStats.SurvivalStats survivalStats = null;
        PlayerStats.SkyblockStats skyblockStats = null;
        PlayerStats.CreativeStats creativeStats = null;
        PlayerStats.KingdomsStats kingdomsStats = null;
        PlayerStats.ParkourStats parkourStats = null;
        PlayerStats.PrisonStats prisonStats = null;
        block19: for (PlayerStatisticsResponse.GamemodeEntry entry : pSResult.serverGamemodes()) {
            switch (entry.name()) {
                case "Oneblock": {
                    oneblockStats = this.handleOneblockStats(entry);
                    continue block19;
                }
                case "Survival": {
                    survivalStats = this.handleSurvivalStats(entry);
                    continue block19;
                }
                case "Skyblock": {
                    skyblockStats = this.handleSkyblockStats(entry);
                    continue block19;
                }
                case "Kingdoms": {
                    kingdomsStats = this.handleKingdomsStats(entry);
                    continue block19;
                }
                case "Parkour": {
                    parkourStats = this.handleParkourStats(entry);
                    continue block19;
                }
                case "Creative": {
                    creativeStats = this.handleCreativeStats(entry);
                    continue block19;
                }
                case "Prison": {
                    prisonStats = this.handlePrisonStats(entry);
                    continue block19;
                }
            }
            throw new InvalidPlayerStatsException(this, entry);
        }
        if (oneblockStats == null || survivalStats == null || skyblockStats == null || creativeStats == null || kingdomsStats == null || parkourStats == null || prisonStats == null) {
            throw new InvalidPlayerStatsException(this, pSResult);
        }
        this.playerStats = new PlayerStats(pSResult.username(), pSResult.headUrl(), isOnline, isBedrock, isHidden, gamemode, badge, lastSeen, oneblockStats, survivalStats, skyblockStats, kingdomsStats, parkourStats, creativeStats, prisonStats);
    }

    @Override
    public String getName() {
        return "PlayerStatistics";
    }

    public PlayerStats getPlayerStats() {
        return this.playerStats;
    }

    private int intStat(List<List<String>> stats, int index) {
        String stat = stats.get(index).get(1);
        if (stat.matches("N/A")) {
            return 0;
        }
        return Integer.parseInt(stat);
    }

    private TimePlayedStat timePlayed(List<List<String>> stats) {
        return new TimePlayedStat(stats.get(0).get(1));
    }

    private DistanceTraveledStat distance(List<List<String>> stats) {
        return new DistanceTraveledStat(stats.get(9).get(1));
    }

    private <T extends PlayerStats.GenericStat> T handleStats(PlayerStatisticsResponse.GamemodeEntry entry, Function<List<List<String>>, T> constructor) {
        try {
            return (T)((PlayerStats.GenericStat)constructor.apply(entry.statistics()));
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            e.printStackTrace();
            throw new InvalidPlayerStatsException(this, entry);
        }
    }

    private PlayerStats.OneblockStats handleOneblockStats(PlayerStatisticsResponse.GamemodeEntry entry) {
        return this.handleStats(entry, stats -> new PlayerStats.OneblockStats(entry.name(), new InitialGamemodeJoinDateStat(entry.initialPlayerJoinDate()), this.timePlayed((List<List<String>>)stats), this.intStat((List<List<String>>)stats, 1), this.intStat((List<List<String>>)stats, 2), this.intStat((List<List<String>>)stats, 3), this.intStat((List<List<String>>)stats, 4), this.intStat((List<List<String>>)stats, 5), this.intStat((List<List<String>>)stats, 6), this.intStat((List<List<String>>)stats, 7), this.intStat((List<List<String>>)stats, 8), this.distance((List<List<String>>)stats)));
    }

    private PlayerStats.SurvivalStats handleSurvivalStats(PlayerStatisticsResponse.GamemodeEntry entry) {
        return this.handleStats(entry, stats -> new PlayerStats.SurvivalStats(entry.name(), new InitialGamemodeJoinDateStat(entry.initialPlayerJoinDate()), this.timePlayed((List<List<String>>)stats), this.intStat((List<List<String>>)stats, 1), this.intStat((List<List<String>>)stats, 2), this.intStat((List<List<String>>)stats, 3), this.intStat((List<List<String>>)stats, 4), this.intStat((List<List<String>>)stats, 5), this.intStat((List<List<String>>)stats, 6), this.intStat((List<List<String>>)stats, 7), this.intStat((List<List<String>>)stats, 8), this.distance((List<List<String>>)stats)));
    }

    private PlayerStats.SkyblockStats handleSkyblockStats(PlayerStatisticsResponse.GamemodeEntry entry) {
        return this.handleStats(entry, stats -> new PlayerStats.SkyblockStats(entry.name(), new InitialGamemodeJoinDateStat(entry.initialPlayerJoinDate()), this.timePlayed((List<List<String>>)stats), this.intStat((List<List<String>>)stats, 1), this.intStat((List<List<String>>)stats, 2), this.intStat((List<List<String>>)stats, 3), this.intStat((List<List<String>>)stats, 4), this.intStat((List<List<String>>)stats, 5), this.intStat((List<List<String>>)stats, 6), this.intStat((List<List<String>>)stats, 7), this.intStat((List<List<String>>)stats, 8), this.distance((List<List<String>>)stats)));
    }

    private PlayerStats.KingdomsStats handleKingdomsStats(PlayerStatisticsResponse.GamemodeEntry entry) {
        return this.handleStats(entry, stats -> new PlayerStats.KingdomsStats(entry.name(), new InitialGamemodeJoinDateStat(entry.initialPlayerJoinDate()), this.timePlayed((List<List<String>>)stats), this.intStat((List<List<String>>)stats, 1), this.intStat((List<List<String>>)stats, 2), this.intStat((List<List<String>>)stats, 3), this.intStat((List<List<String>>)stats, 4), this.intStat((List<List<String>>)stats, 5), this.intStat((List<List<String>>)stats, 6), this.intStat((List<List<String>>)stats, 7), this.intStat((List<List<String>>)stats, 8), this.distance((List<List<String>>)stats)));
    }

    private PlayerStats.ParkourStats handleParkourStats(PlayerStatisticsResponse.GamemodeEntry entry) {
        PlayerStats.ParkourStats parkourStats;
        List<List<String>> stats = entry.statistics();
        try {
            parkourStats = new PlayerStats.ParkourStats(entry.name(), new InitialGamemodeJoinDateStat(entry.initialPlayerJoinDate()), new TimePlayedStat(stats.get(0).get(1)), new DistanceTraveledStat(stats.get(1).get(1)), Integer.parseInt(stats.get(2).get(1)), Integer.parseInt(stats.get(3).get(1)), Integer.parseInt(stats.get(4).get(1)));
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            System.out.println(e.getMessage());
            throw new InvalidPlayerStatsException(this, entry);
        }
        return parkourStats;
    }

    private PlayerStats.CreativeStats handleCreativeStats(PlayerStatisticsResponse.GamemodeEntry entry) {
        return this.handleStats(entry, stats -> new PlayerStats.CreativeStats(entry.name(), new InitialGamemodeJoinDateStat(entry.initialPlayerJoinDate()), this.timePlayed((List<List<String>>)stats), this.intStat((List<List<String>>)stats, 1), this.intStat((List<List<String>>)stats, 2), this.intStat((List<List<String>>)stats, 3), this.intStat((List<List<String>>)stats, 4), this.intStat((List<List<String>>)stats, 5), this.intStat((List<List<String>>)stats, 6), this.intStat((List<List<String>>)stats, 7), this.intStat((List<List<String>>)stats, 8), this.distance((List<List<String>>)stats)));
    }

    private PlayerStats.PrisonStats handlePrisonStats(PlayerStatisticsResponse.GamemodeEntry entry) {
        return this.handleStats(entry, stats -> new PlayerStats.PrisonStats(entry.name(), new InitialGamemodeJoinDateStat(entry.initialPlayerJoinDate()), this.timePlayed((List<List<String>>)stats), this.intStat((List<List<String>>)stats, 1), this.intStat((List<List<String>>)stats, 2), this.intStat((List<List<String>>)stats, 3), this.intStat((List<List<String>>)stats, 4), this.intStat((List<List<String>>)stats, 5), this.intStat((List<List<String>>)stats, 6), this.intStat((List<List<String>>)stats, 7), this.intStat((List<List<String>>)stats, 8), this.distance((List<List<String>>)stats)));
    }
}

