/*
 * Decompiled with CFR 0.152.
 */
package net.dzultra.jfa.apidata;

import java.util.List;
import java.util.Map;
import net.dzultra.jfa.apidata.APIDataObject;
import net.dzultra.jfa.apidata.LeaderBoardIdMap;
import net.dzultra.jfa.exceptions.InvalidLeaderboardException;
import net.dzultra.jfa.exceptions.InvalidResponseException;
import net.dzultra.jfa.exceptions.NoEntryFoundException;
import net.dzultra.jfa.exceptions.NoExactMatchException;
import net.dzultra.jfa.requests.ServerLeaderboardsRequest;
import net.dzultra.jfa.responses.ServerLeaderboardsResponse;
import net.dzultra.jfa.types.Gamemode;
import net.dzultra.jfa.types.Period;
import net.dzultra.jfa.types.leaderboards.LeaderboardType;

public class ServerLeaderboard
extends APIDataObject<ServerLeaderboardsRequest, ServerLeaderboardsResponse> {
    private final LeaderboardType leaderboardType;
    private final Period period;
    private Leaderboard leaderboard;

    public ServerLeaderboard(LeaderboardType leaderboardType, Period period) {
        this(new ServerLeaderboardsRequest(leaderboardType, period), leaderboardType, period);
    }

    private ServerLeaderboard(ServerLeaderboardsRequest request, LeaderboardType type, Period period) {
        super(request, request.getResponse());
        this.leaderboardType = type;
        this.period = period;
        this.dataHandler();
    }

    @Override
    protected void dataHandler() {
        String title = this.leaderboardType.getTitle();
        List<ServerLeaderboardsResponse.LeaderboardResults> lbResults = ((ServerLeaderboardsResponse)this.response).leaderboardResults();
        if (lbResults == null || lbResults.isEmpty()) {
            throw new InvalidResponseException(this);
        }
        Gamemode gamemode = this.leaderboardType.getGamemode();
        Map<String, Integer> map = LeaderBoardIdMap.LEADERBOARD_IDS.get((Object)gamemode);
        if (map == null || !map.containsKey(title)) {
            throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.leaderboardType.getGamemode()) + ".\nThis error should kinda never be thrown. Wth are you doing?");
        }
        int leaderboardId = map.get(title);
        if (!lbResults.get(leaderboardId).name().equals(title)) {
            throw new NoExactMatchException(this, title);
        }
        if (lbResults.get(leaderboardId).entries().size() != 10) {
            throw new InvalidLeaderboardException(this, lbResults.get(leaderboardId).entries().size());
        }
        this.leaderboard = new Leaderboard(title, lbResults.get(leaderboardId).entries());
    }

    @Override
    public String getName() {
        return "ServerLeaderboard";
    }

    public LeaderboardType getLeaderboardType() {
        return this.leaderboardType;
    }

    public Period getPeriod() {
        return this.period;
    }

    public List<ServerLeaderboardsResponse.LeaderboardEntry> getEntries() {
        return this.leaderboard.entries();
    }

    public String getTitle() {
        return this.leaderboard.title();
    }

    public ServerLeaderboardsResponse.LeaderboardEntry getEntry(int position) {
        try {
            return this.leaderboard.entries().get(position - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoEntryFoundException(this, position);
        }
    }

    public record Leaderboard(String title, List<ServerLeaderboardsResponse.LeaderboardEntry> entries) {
    }
}

